#------------------------------------------------------------------------------
#    59bbs, blog like bulletin board system.
#    Copyright (C) 2007-2010 Kaga, Hiroaki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#------------------------------------------------------------------------------

package Lib::Conf;

require "config.cgi";

# RXgN^
sub new {
    my $self = {};

    $self->{system_dir} = $system_dir;      # VXefBNg
    $self->{data_dir} = $data_dir;          # f[^fBNg
    $self->{docroot_dir} = $docroot_dir;    # [gfBNg
    $self->{files_dir} = $files_dir;        # Ytt@CfBNg
    $self->{notify_mail} = $notify_mail;    # [Œʒm邩 0:ʒm 1:ʒm
    $self->{sendmail_path} = $sendmail_path;# sendmail̃pX
    $self->{admin_address} = $admin_address;# Ǘl[AhX
    $self->{excerpt_length} = $excerpt_length; # gbNobNM̗v̒
    $self->{summary_length} = $summary_length; # v̒
    $self->{anonymous} = $anonymous;        # ̏ꍇ̑֕
    $self->{site_title} = $site_title;      # TCgiuOj
    $self->{sub_title} = $sub_title;        # TCg̃Tu^Cg
    $self->{new_item_num} = $new_item_num;  # XV񍀖ڐ
    $self->{open_item_num} = $open_item_num;# I[vڐ
    $self->{topic_num} = $topic_num;        # gsbN\
    $self->{comment_num} = $comment_num;    # Rgۑ
    $self->{trackback_num} = $trackback_num;# gbNobNۑ
    $self->{comment_target} = $comment_target; # Rg̃AJ[^O
    $self->{trackback_target} = $trackback_target; # gbNobÑAJ[^O
    $self->{link_target} = $link_target;    # ֘AÑAJ[^O
    $self->{bookmark_target} = $bookmark_target; # ubN}[ÑAJ[^O
    $self->{result_count} = $result_count;  # ʂɕ\鍀ڐ
    $self->{default_status} = $default_status; # gsbNXe[^X̃ftHgl
    $self->{date_update} = $date_update;    # XV 0:XVȂ 1:XV
    $self->{add_update} = $add_update;      # XV֒ǉ 0:ǉȂ 1:ǉ
    $self->{good_point} = $good_point;      # ]ǂ
    $self->{normal_point} = $normal_point;  # ]ʁAgbNobN
    $self->{bad_point} = $bad_point;        # ]
    $self->{static_html} = $static_html;    # gsbNڍ׃y[WÓIHTMLt@Cŏo
    $self->{language} = $language;          #  auto: ja:{ en:p
    $self->{free_signup} = $free_signup;    # [U[o^  0:s 1:\
    $self->{accesskeyid} = $accesskeyid;    # Amazon WebT[rX ANZXL[ID
    $self->{secretaccesskey} = $secretaccesskey; # Amazon WebT[rX 閧ANZXL[

    bless($self);
    return $self;
}

# ----- get -----

# VXefBNg
sub get_system_dir {
    my $self = shift;
    return $self->{system_dir};
}

# f[^fBNg
sub get_data_dir {
    my $self = shift;
    return $self->{data_dir};
}

# hLg[gfBNg
sub get_docroot_dir {
    my $self = shift;
    return $self->{docroot_dir};
}

# Ytt@CfBNg
sub get_files_dir {
    my $self = shift;
    return $self->{files_dir};
}

# [Œʒm邩 0:ʒm 1:ʒm
sub get_notify_mail {
    my $self = shift;
    return $self->{notify_mail};
}

# sendmail̃pX
sub get_sendmail_path {
    my $self = shift;
    return $self->{sendmail_path};
}

# Ǘl[AhX
sub get_admin_address {
    my $self = shift;
    return $self->{admin_address};
}

# gbNobNM̗v̒
sub get_excerpt_length {
    my $self = shift;
    return $self->{excerpt_length};
}

# v̒
sub get_summary_length {
    my $self = shift;
    return $self->{summary_length};
}

# ̏ꍇ̑֕
sub get_anonymous {
    my $self = shift;
    return $self->{anonymous};
}

# TCg
sub get_site_title {
    my $self = shift;
    return $self->{site_title};
}

# TCg̃Tu^Cg
sub get_sub_title {
    my $self = shift;
    return $self->{sub_title};
}

# XV񍀖ڐ
sub get_new_item_num {
    my $self = shift;
    return $self->{new_item_num};
}

# I[vڐ
sub get_open_item_num {
    my $self = shift;
    return $self->{open_item_num};
}

# gsbN\
sub get_topic_num {
    my $self = shift;
    return $self->{topic_num};
}

# Rg\
sub get_comment_num {
    my $self = shift;
    return $self->{comment_num};
}

# gbNobN\
sub get_trackback_num {
    my $self = shift;
    return $self->{trackback_num};
}

# Rg̃AJ[^O
sub get_comment_target {
    my $self = shift;
    return $self->{comment_target};
}

# gbNobÑAJ[^O
sub get_trackback_target {
    my $self = shift;
    return $self->{trackback_target};
}

# ֘AÑAJ[^O
sub get_link_target {
    my $self = shift;
    return $self->{link_target};
}

# ubN}[ÑAJ[^O
sub get_bookmark_target {
    my $self = shift;
    return $self->{bookmark_target};
}

# 1y[Wɕ\鍀ڐ
sub get_result_count {
    my $self = shift;
    return $self->{result_count};
}

# gsbNXe[^X̃ftHgl
sub get_default_status {
    my $self = shift;
    return $self->{default_status};
}

# XV 0:XVȂ 1:XV
sub get_date_update {
    my $self = shift;
    return $self->{date_update};
}

# XV֒ǉ 0:ǉȂ 1:ǉ
sub get_add_update {
    my $self = shift;
    return $self->{add_update};
}

# ]ǂ
sub get_good_point {
    my $self = shift;
    return $self->{good_point};
}

# ]ʁAgbNobN
sub get_normal_point {
    my $self = shift;
    return $self->{normal_point};
}

# ]
sub get_bad_point {
    my $self = shift;
    return $self->{bad_point};
}

# gsbNڍ׃y[WÓIHTMLt@Cŏo
sub get_static_html {
    my $self = shift;
    return $self->{static_html};
}

#  auto: ja:{ en:p
sub get_language {
    my $self = shift;
    return $self->{language};
}

# [U[o^  0:s 1:\
sub get_free_signup {
    my $self = shift;
    return $self->{free_signup};
}

# Amazon WebT[rX ANZXL[ID
sub get_accesskeyid {
    my $self = shift;
    return $self->{accesskeyid};
}

# Amazon WebT[rX 閧ANZXL[
sub get_secretaccesskey {
    my $self = shift;
    return $self->{secretaccesskey};
}

# ----- set -----

# TCg
sub set_site_title {
    my $self = shift;
    $self->{site_title} = shift;
}

# TCg̃Tu^Cg
sub set_sub_title {
    my $self = shift;
    $self->{sub_title} = shift;
}

# Ǘl[AhX
sub set_admin_address {
    my $self = shift;
    $self->{admin_address} = shift;
}

# ̏ꍇ̑֕
sub set_anonymous {
    my $self = shift;
    $self->{anonymous} = shift;
}

# Xgy[Wɕ\鍀ڐ
sub set_result_count {
    my $self = shift;
    $self->{result_count} = shift;
}

# ÓIHTMLt@Co͂̎w
sub set_static_html {
    my $self = shift;
    $self->{static_html} = shift;
}

# [U[o^  0:s 1:\
sub set_free_signup {
    my $self = shift;
    $self->{free_signup} = shift;
}

#  auto: ja:{ en:p
sub set_language {
    my $self = shift;
    $self->{language} = shift;
}

# ----- update config.cgi -----

sub update_conf {
    my $self = shift;

    open my $templatefh, '<', "$self->{system_dir}/tmpl/config.tmpl";
    my $template = do { local $/; <$templatefh> };
    close $templatefh;

    $template =~ s/\$SITE_TITLE\$/$self->{site_title}/g;
    $template =~ s/\$SUB_TITLE\$/$self->{sub_title}/g;
    $template =~ s/\$ADMIN_ADDRESS\$/$self->{admin_address}/g;
    $template =~ s/\$ANONYMOUS\$/$self->{anonymous}/g;
    $template =~ s/\$SYSTEM_DIR\$/$self->{system_dir}/g;
    $template =~ s/\$DATA_DIR\$/$self->{data_dir}/g;
    $template =~ s/\$DOCROOT_DIR\$/$self->{docroot_dir}/g;
    $template =~ s/\$FILES_DIR\$/$self->{files_dir}/g;
    $template =~ s/\$NOTIFY_MAIL\$/$self->{notify_mail}/g;
    $template =~ s/\$SENDMAIL_PATH\$/$self->{sendmail_path}/g;
    $template =~ s/\$EXCERPT_LENGTH\$/$self->{excerpt_length}/g;
    $template =~ s/\$SUMMARY_LENGTH\$/$self->{summary_length}/g;
    $template =~ s/\$NEW_ITEM_NUM\$/$self->{new_item_num}/g;
    $template =~ s/\$OPEN_ITEM_NUM\$/$self->{open_item_num}/g;
    $template =~ s/\$TOPIC_NUM\$/$self->{topic_num}/g;
    $template =~ s/\$COMMENT_TARGET\$/$self->{comment_target}/g;
    $template =~ s/\$TRACKBACK_TARGET\$/$self->{trackback_target}/g;
    $template =~ s/\$LINK_TARGET\$/$self->{link_target}/g;
    $template =~ s/\$BOOKMARK_TARGET\$/$self->{bookmark_target}/g;
    $template =~ s/\$RESULT_COUNT\$/$self->{result_count}/g;
    $template =~ s/\$DEFAULT_STATUS\$/$self->{default_status}/g;
    $template =~ s/\$DATE_UPDATE\$/$self->{date_update}/g;
    $template =~ s/\$ADD_UPDATE\$/$self->{add_update}/g;
    $template =~ s/\$GOOD_POINT\$/$self->{good_point}/g;
    $template =~ s/\$NORMAL_POINT\$/$self->{normal_point}/g;
    $template =~ s/\$BAD_POINT\$/$self->{bad_point}/g;
    $template =~ s/\$STATIC_HTML\$/$self->{static_html}/g;
    $template =~ s/\$LANGUAGE\$/$self->{language}/g;
    $template =~ s/\$FREE_SIGNUP\$/$self->{free_signup}/g;
    $template =~ s/\$ACCESSKEYID\$/$self->{accesskeyid}/g;
    $template =~ s/\$SECRETACCESSKEY\$/$self->{secretaccesskey}/g;

    my $configfile = "config.cgi";
    open my $conffh, '>', $configfile;
    print {$conffh} "$template";
    close $conffh;
}

1;
# End of Conf.pm
