#!/usr/bin/perl
#------------------------------------------------------------------------------
#    59bbs, blog like bulletin board system.
#    Copyright (C) 2007-2010 Kaga, Hiroaki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#------------------------------------------------------------------------------

use strict;
use warnings;

use Lib::Logger;
use Lib::Error;
use Lib::User;
use Lib::Conf;

my $logger = Lib::Logger->new();
my $error = Lib::Error->new();
my $conf = Lib::Conf->new();

sub act() {
    my ($act, $cgi) = @_;

    if ($act eq 'view_topic') {
        _view_topic($cgi);
    }
    elsif ($act eq 'input_topic') {
        _input_topic($cgi);
    }
    elsif ($act eq 'new_topic') {
        _new_topic($cgi);
    }
    else {
        $error->print_error('00002e');
    }
}

sub _view_topic() {
    my ($cgi) = @_;

    my $topicid = $cgi->param('id');
    my $url = "./?func=detail&id=$topicid";
    if ($conf->get_static_html()) {
        $url = "detail$topicid.html";
    }
    print "Status: 301 Moved Permanently\n";
    print "Location: $url", "\n\n";
}

sub _input_topic() {
    my ($cgi) = @_;

    my $newurl = './?act=view_editor';
    my $bookmarkurl = $cgi->param('url');
    if ($bookmarkurl ne '') {
        $newurl .= "&url=$bookmarkurl"
    }

    print "Status: 301 Moved Permanently\n";
    print "Location: $newurl", "\n\n";
}

sub _new_topic() {
    my ($cgi) = @_;

    my $newurl = './?act=new_post';
    my $bookmarkurl = $cgi->param('url');
    if ($bookmarkurl ne '') {
        $newurl .= "&url=$bookmarkurl"
    }

    print "Status: 301 Moved Permanently\n";
    print "Location: $newurl", "\n\n";
}

1;
