/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.kino.plugin.google.ui;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import nu.mine.kino.plugin.google.core.GoogleCorePlugin;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class GooglePlugin
extends AbstractUIPlugin {
    private static final Logger logger;
    private static GooglePlugin plugin;
    private ResourceBundle resourceBundle;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("nu.mine.kino.plugin.google.ui.GooglePlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public GooglePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        this.resourceBundle = null;
    }

    public static GooglePlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = GooglePlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("nu.mine.kino.plugin.google.ui.GooglePluginResources");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"nu.mine.kino.plugin.google.ui", (String)path);
    }

    public static void log(String message, Exception e) {
        Status status = new Status(4, GooglePlugin.getPluginId(), 4, message, (Throwable)e);
        GooglePlugin.getDefault().getLog().log((IStatus)status);
    }

    public static void log(String message) {
        GooglePlugin.log(message, null);
    }

    public static void log(Exception e) {
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        String message = stringWriter.getBuffer().toString();
        GooglePlugin.log(message, e);
    }

    public static String getPluginId() {
        return GooglePlugin.getDefault().getBundle().getSymbolicName();
    }

    public String getSplellingSuggestion(String text, IProgressMonitor monitor) {
        String searchText;
        String suggestionText = null;
        String myGoogleKey = GooglePlugin.getDefault().getPreferenceStore().getString("stringPreference");
        suggestionText = GoogleCorePlugin.getDefault().getSplellingSuggestion(myGoogleKey, text);
        if (suggestionText != null) {
            CheckThread dialog = new CheckThread(text, suggestionText);
            this.checkSyncExec(dialog);
            if (dialog.isOK()) {
                searchText = suggestionText;
                logger.debug((Object)"\u30b9\u30da\u30eb\u30df\u30b9\u306e\u5019\u88dc\u306b\u5909\u66f4\u3057\u307e\u3059");
                monitor.setTaskName("\u300c" + suggestionText + "\u300d\u306b\u5909\u66f4\u3057\u3066Google\u3092\u691c\u7d22\u4e2d...");
            } else {
                searchText = text;
                logger.debug((Object)"\u30b9\u30da\u30eb\u30df\u30b9\u306e\u5019\u88dc\u306b\u5909\u66f4\u3057\u307e\u305b\u3093(\u30e6\u30fc\u30b6\u304c\u30ad\u30e3\u30f3\u30bb\u30eb)");
            }
        } else {
            logger.debug((Object)"\u30b9\u30da\u30eb\u30df\u30b9\u306e\u5019\u88dc\u304c\u3042\u308a\u307e\u305b\u3093\u3067\u3057\u305f");
            searchText = text;
        }
        return searchText;
    }

    private boolean checkSyncExec(Runnable thread) {
        if (!Display.getDefault().isDisposed()) {
            Display.getDefault().syncExec(thread);
            return true;
        }
        return false;
    }

    private class CheckThread
    implements Runnable {
        private final Logger logger;
        private int returnCode;
        private String text;
        private String suggestionText;
        static /* synthetic */ Class class$0;

        public CheckThread(String text, String suggestionText) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("nu.mine.kino.plugin.google.ui.GooglePlugin$CheckThread");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.logger = Logger.getLogger((Class)clazz);
            this.text = text;
            this.suggestionText = suggestionText;
        }

        public void run() {
            StringBuffer message = new StringBuffer();
            message.append("\u88dc\u6b63\u3057\u307e\u3059\u304b\uff1f ");
            message.append(this.text);
            message.append(" -> ");
            message.append(this.suggestionText);
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            MessageDialog dialog = new MessageDialog(window.getShell(), "\u30b9\u30da\u30eb\u30df\u30b9\u3057\u3066\u3044\u307e\u305b\u3093\u304b\uff1f", null, new String(message), 3, new String[]{"\u3059\u308b", "\u3057\u306a\u3044"}, 1);
            this.returnCode = dialog.open();
        }

        public boolean isOK() {
            return this.returnCode == 0;
        }
    }
}

