/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.kino.plugin.google.ui.views;

import nu.mine.kino.googleapis.GoogleSearchResult;
import nu.mine.kino.googleapis.ResultElement;
import nu.mine.kino.plugin.google.core.GoogleCorePlugin;
import nu.mine.kino.plugin.google.ui.GooglePlugin;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

class SearchJob
extends Job {
    private final Logger logger;
    private String text;
    private ResultElement[] elements;
    private final TableViewer viewer;
    static /* synthetic */ Class class$0;

    public SearchJob(String name, String text, TableViewer viewer) {
        super(name);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("nu.mine.kino.plugin.google.ui.views.SearchJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logger = Logger.getLogger((Class)clazz);
        this.text = text;
        this.viewer = viewer;
    }

    public IStatus run(IProgressMonitor monitor) {
        this.logger.debug((Object)"run(IProgressMonitor) - start");
        monitor.beginTask("\u300c" + this.text + "\u300d\u3067Google\u3092\u691c\u7d22\u4e2d...", 10);
        try {
            String searchText = null;
            monitor.subTask("\u30b9\u30da\u30eb\u30c1\u30a7\u30c3\u30af");
            monitor.worked(1);
            searchText = GooglePlugin.getDefault().getSplellingSuggestion(this.text, monitor);
            monitor.worked(3);
            if (monitor.isCanceled()) {
                this.logger.debug((Object)"run(IProgressMonitor) - end");
                return Status.CANCEL_STATUS;
            }
            monitor.subTask("\u691c\u7d22\u4e2d");
            String myGoogleKey = GooglePlugin.getDefault().getPreferenceStore().getString("stringPreference");
            GoogleSearchResult result = GoogleCorePlugin.getDefault().search(myGoogleKey, searchText);
            monitor.worked(3);
            this.logger.debug((Object)"run(IProgressMonitor) - \u691c\u7d22\u7d42\u4e86");
            if (monitor.isCanceled()) {
                this.logger.debug((Object)"run(IProgressMonitor) - end");
                return Status.CANCEL_STATUS;
            }
            this.elements = result.getResultElements();
            this.logger.debug((Object)"run(IProgressMonitor) - Elements\u306e\u53d6\u5f97\u5b8c\u4e86");
        }
        catch (CoreException e) {
            this.logger.error((Object)"run(IProgressMonitor)", (Throwable)e);
            return e.getStatus();
        }
        if (this.elements.length != 0) {
            this.checkAsyncExec(new Runnable(){

                public void run() {
                    SearchJob.this.logger.debug((Object)"run() - start");
                    if (!SearchJob.this.viewer.getTable().isDisposed()) {
                        SearchJob.this.viewer.setInput((Object)SearchJob.this.elements);
                    }
                    SearchJob.this.logger.debug((Object)"run() - end");
                }
            });
        } else {
            this.checkAsyncExec(this.informationThread("\u691c\u7d22\u7d50\u679c\u306f0\u4ef6\u3067\u3057\u305f"));
        }
        monitor.worked(10);
        monitor.done();
        this.logger.debug((Object)"run(IProgressMonitor) - end");
        return Status.OK_STATUS;
    }

    private Runnable informationThread(final String message) {
        return new Runnable(){

            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                MessageDialog.openInformation((Shell)window.getShell(), (String)"Google\u691c\u7d22", (String)message);
            }
        };
    }

    private boolean checkAsyncExec(Runnable thread) {
        if (!Display.getDefault().isDisposed()) {
            Display.getDefault().asyncExec(thread);
            return true;
        }
        return false;
    }
}

