/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.kino.plugin.google.core;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.rpc.ServiceException;
import nu.mine.kino.googleapis.GoogleSearchPort;
import nu.mine.kino.googleapis.GoogleSearchResult;
import nu.mine.kino.googleapis.GoogleSearchServiceLocator;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class GoogleCorePlugin
extends Plugin {
    private static final Logger logger;
    private GoogleSearchPort googleSearch;
    private static GoogleCorePlugin plugin;
    private ResourceBundle resourceBundle;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("nu.mine.kino.plugin.google.core.GoogleCorePlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public GoogleCorePlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("nu.mine.kino.plugin.google.core.GoogleCorePluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        logger.debug((Object)"start(BundleContext) - start");
        super.start(context);
        try {
            GoogleSearchServiceLocator locator = new GoogleSearchServiceLocator();
            this.googleSearch = locator.getGoogleSearchPort();
        }
        catch (ServiceException e) {
            logger.error((Object)e);
            GoogleCorePlugin.log((Exception)((Object)e));
        }
        logger.debug((Object)"start(BundleContext) - end");
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static GoogleCorePlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = GoogleCorePlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public GoogleSearchResult search(String myGoogleKey, String searchText) throws CoreException {
        logger.debug((Object)"search(String) - start");
        GoogleSearchResult result = null;
        if (this.googleSearch != null) {
            try {
                result = this.googleSearch.doGoogleSearch(myGoogleKey, searchText, 1, 10, false, "", false, "lang_ja", "", "");
            }
            catch (RemoteException e) {
                logger.error((Object)e);
                GoogleCorePlugin.log(e);
                Status status = new Status(4, GoogleCorePlugin.getPluginId(), 4, e.toString(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        logger.debug((Object)"search(String) - end");
        return result;
    }

    public String getSplellingSuggestion(String myGoogleKey, String text) {
        logger.debug((Object)"getSplellingSuggestion(String, String) - start");
        String suggestionText = null;
        try {
            suggestionText = this.googleSearch.doSpellingSuggestion(myGoogleKey, text);
        }
        catch (Exception e) {
            logger.warn((Object)e);
            logger.warn((Object)"\u30b9\u30da\u30eb\u30df\u30b9\u88dc\u6b63\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
        }
        logger.debug((Object)"getSplellingSuggestion(String, String) - end");
        return suggestionText;
    }

    public static void log(String message, Exception e) {
        Status status = new Status(4, GoogleCorePlugin.getPluginId(), 4, message, (Throwable)e);
        GoogleCorePlugin.getDefault().getLog().log((IStatus)status);
    }

    public static void log(String message) {
        GoogleCorePlugin.log(message, null);
    }

    public static void log(Exception e) {
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        String message = stringWriter.getBuffer().toString();
        GoogleCorePlugin.log(message, e);
    }

    public static String getPluginId() {
        return GoogleCorePlugin.getDefault().getBundle().getSymbolicName();
    }
}

