/*******************************************************************************
 * Copyright (c) 2005 Masatomi KINO.
 * All rights reserved. 
 * $Id: Utility.java,v 1.2 2005/06/21 15:50:58 cvsuser Exp $
 *******************************************************************************/
//쐬: 2005/06/18
package nu.mine.kino.plugin.google.ui;

import org.apache.log4j.Logger;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;

import org.eclipse.swt.program.Program;

/**
 * @author Masatomi KINO
 * @version $Revision: 1.2 $
 */
public class Utility {
    /**
     * Logger for this class
     */
    private static final Logger logger = Logger.getLogger(Utility.class);

    public static String filter(String input) {
        StringBuffer filtered = new StringBuffer(input.length());
        char c;
        for (int i = 0; i < input.length(); i++) {
            c = input.charAt(i);
            if (c == '\\') {
                filtered.append("");
            } else if (c == '/') {
                filtered.append("");
            } else if (c == ':') {
                filtered.append("");
            } else if (c == ',') {
                filtered.append("");
            } else if (c == ',') {
                filtered.append("");
            } else if (c == ',') {
                filtered.append("");
            } else if (c == ';') {
                filtered.append("");
            } else if (c == '*') {
                filtered.append("");
            } else if (c == '?') {
                filtered.append("");
            } else if (c == '"') {
                filtered.append("");
            } else if (c == '<') {
                filtered.append("");
            } else if (c == '>') {
                filtered.append("");
            } else if (c == '|') {
                filtered.append("");
            } else {
                filtered.append(c);
            }
        }
        if (filtered.length() <= 3) {
            filtered.append("000");
        }
        return (filtered.toString());
    }

    /**
     * V[gJbgN쐬郁\bhB
     * 
     * @param url
     *            V[gJbg
     * @param file
     *            oB
     * @return
     */
    public static boolean write(String url, File file) {
        String tmp = "URL=" + url;
        BufferedWriter writer = null;
        try {
            // trueȂǋLAfalseȂ㏑B
            writer = new BufferedWriter(new FileWriter(file));
            String header = "[InternetShortcut]";
            writer.write(header, 0, header.length());
            writer.newLine();
            writer.write(tmp, 0, tmp.length());
            writer.newLine();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        } catch (IOException e) {
            e.printStackTrace();
            return false;
        } finally {
            try {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public static void executeBrowser(String url) {
        // gq"html"̃AvP[VJB
        Program program = Program.findProgram("html");
        logger.debug("URLJ܂F " + url);
        if (program != null) {
            program.execute(url);
        } else {
            logger.warn("uEU܂BOS̃oOȂ");
            logger.debug("dȂ̂ŁAWindowsp̂ł܂B");
            try {
                Runtime.getRuntime().exec(
                        new String[] { "rundll32.exe",
                                "url.dll,FileProtocolHandler", url });
            } catch (IOException e) {
                logger.error("WindowŝłAuEU܂łBOS̃oOȂ");
            }
        }

    }
}
