//$Id: CompilationUnitEditorContextAction.java,v 1.1 2005/05/22 14:29:05 cvsuser Exp $
//쐬: 2005/05/22
package nu.mine.kino.plugin.google.ui.popup.actions;

import nu.mine.kino.plugin.google.ui.GooglePlugin;
import nu.mine.kino.plugin.google.ui.views.GoogleResultView;

import org.apache.log4j.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.AbstractTextEditor;

/**
 * @author Masatomi KINO
 * @version $Revision: 1.1 $
 */
public class CompilationUnitEditorContextAction implements
        IEditorActionDelegate {
    /**
     * Logger for this class
     */
    private static final Logger logger = Logger
            .getLogger(CompilationUnitEditorContextAction.class);

    private ISelection selection;

    private IEditorPart editorPart;

    /*
     * ( Javadoc)
     * 
     * @see org.eclipse.ui.IEditorActionDelegate#setActiveEditor(org.eclipse.jface.action.IAction,
     *      org.eclipse.ui.IEditorPart)
     */
    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editorPart = targetEditor;
    }

    /*
     * ( Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    /*
     * ( Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        logger.debug("run(IAction) - start");

        AbstractTextEditor editor = (AbstractTextEditor) editorPart;

        final ITextSelection textSelection = (ITextSelection) selection;
        logger.debug("IĂ镶" + textSelection.getText());

        IWorkbenchPage workbenchPage = editor.getSite().getPage();
        // logger.debug(workbenchPage);
        // logger.debug(PlatformUI.getWorkbench().getActiveWorkbenchWindow()
        // .getActivePage());

        try {
            logger.debug("View擾܂");
            final GoogleResultView view = (GoogleResultView) workbenchPage
                    .showView("nu.mine.kino.plugin.google.ui.views.GoogleResultView");
            logger.debug("View擾܂");
            logger.debug(view);
            view.search(textSelection.getText());

        } catch (PartInitException e) {
            logger.error(e);
            GooglePlugin.log(e);
        }

        logger.debug("run(IAction) - end");
    }

}
