//$Id: GoogleResultView.java,v 1.7 2005/06/19 02:05:18 cvsuser Exp $
//쐬: 2005/05/21
package nu.mine.kino.plugin.google.ui.views;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;

import nu.mine.kino.googleapis.ResultElement;
import nu.mine.kino.plugin.google.ui.GooglePlugin;
import nu.mine.kino.plugin.google.ui.Utility;
import nu.mine.kino.plugin.google.ui.views.fields.IField;
import nu.mine.kino.plugin.google.ui.views.fields.SummaryField;
import nu.mine.kino.plugin.google.ui.views.fields.TitleField;
import nu.mine.kino.plugin.google.ui.views.fields.URLField;
import nu.mine.kino.plugin.google.ui.views.internal.TableSorter;

import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.ViewPart;

public class GoogleResultView extends ViewPart {

    private Action clearAction;

    private TableSorter sorter;

    /**
     * Logger for this class
     */
    private static final Logger logger = Logger
            .getLogger(GoogleResultView.class);

    class ViewLabelProvider extends LabelProvider implements
            ITableLabelProvider {
        /**
         * Logger for this class
         */
        private final Logger logger = Logger.getLogger(ViewLabelProvider.class);

        private final IField[] fields;

        public ViewLabelProvider(IField[] fields) {
            this.fields = fields;
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof ResultElement) {
                ResultElement element = (ResultElement) obj;
                return fields[index].getValue(element);
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    private TableViewer viewer;

    private static final String TAG_COLUMN_WIDTH = "columnWidth";

    // TableLayoutƈꏏɂȂĎgBeJ̕\ȂǏݒ肷B
    // private final ColumnLayoutData[] DEFAULT_COLUMN_LAYOUTS = {
    // new ColumnWeightData(200), new ColumnWeightData(200),
    // new ColumnWeightData(200) };

    // TableLayoutƈꏏɂȂĎgBeJ̕\ȂǏݒ肷B
    private final ColumnPixelData[] DEFAULT_COLUMN_LAYOUTS = {
            new ColumnPixelData(200), new ColumnPixelData(200),
            new ColumnPixelData(200) };

    private final IField[] VISIBLE_FIELDS = { new TitleField(),
            new SummaryField(), new URLField() };

    private Table table;

    private Action doubleClickAction;

    private Action openBrowserAction;

    private IMemento memento;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    public void createPartControl(Composite parent) {
        Composite container = new Composite(parent, SWT.NONE);
        container.setLayout(new FillLayout());

        viewer = new TableViewer(container, SWT.FULL_SELECTION | SWT.BORDER
                | SWT.H_SCROLL | SWT.V_SCROLL);
        // \[^ǉ
        viewer.setSorter(getSorter());
        viewer.addDoubleClickListener(new IDoubleClickListener() {
            public void doubleClick(DoubleClickEvent e) {
                doubleClickAction.run();
            }
        });

        int dragOption = DND.DROP_COPY | DND.DROP_MOVE;
        Transfer[] transfers = new Transfer[] { TextTransfer.getInstance(),
                FileTransfer.getInstance() };
        viewer.addDragSupport(dragOption, transfers, new DragSourceAdapterImpl(
                viewer));

        viewer.setContentProvider(new ArrayContentProvider());
        viewer.setLabelProvider(new ViewLabelProvider(VISIBLE_FIELDS));
        viewer.setInput(getViewSite());
        initTable(viewer);

        createActions();
        initializeToolBar();
        initializeMenu();

        // viewer͕ʂContexteMenu 쐬
        hookContextMenu();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu"); //$NON-NLS-1$
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener() {
            public void menuAboutToShow(IMenuManager manager) {
                fillContextMenu(manager);
                // DisableɂAEnabledɂ
                ISelection selection = viewer.getSelection();
                Object obj = ((IStructuredSelection) selection)
                        .getFirstElement();
                if (obj == null) {
                    openBrowserAction.setEnabled(false);
                } else {
                    openBrowserAction.setEnabled(true);
                }
            }
        });

        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        getSite().registerContextMenu(menuMgr, viewer);
        // getSite().registerContextMenu("hogeID",menuMgr, viewer);
        // ʂIDꍇ(łhogeID)
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add(openBrowserAction);
        // Other plug-ins can contribute there actions here
        manager.add(new Separator(IWorkbenchActionConstants.MB_ADDITIONS));
        manager.add(new Separator(IWorkbenchActionConstants.MB_ADDITIONS
                + "-end"));
    }

    private void initTable(final TableViewer viewer) {
        // wb_NbNƂɔ郊Xi[쐬B
        SelectionListener headerListener = getHeaderListener();
        table = viewer.getTable();

        TableLayout layout = new TableLayout();
        table.setLayout(layout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);

        ColumnLayoutData[] columnLayouts = getColumnLayouts();

        for (int i = 0; i < columnLayouts.length; i++) {
            layout.addColumnData(columnLayouts[i]);
            TableColumn tc = new TableColumn(table, SWT.NONE, i);
            tc.setText(VISIBLE_FIELDS[i].getColumnHeaderText());
            tc.setImage(VISIBLE_FIELDS[i].getColumnHeaderImage());
            tc.addSelectionListener(headerListener);
        }
    }

    /**
     * tB[hColumnLayoutData[]Amemento̒lŏꂽ ColumnLayoutData[]Ԃ\bhB
     * 
     * @return
     */
    private ColumnLayoutData[] getColumnLayouts() {

        ColumnPixelData[] result = new ColumnPixelData[DEFAULT_COLUMN_LAYOUTS.length];
        for (int i = 0; i < DEFAULT_COLUMN_LAYOUTS.length; i++) {
            int width = DEFAULT_COLUMN_LAYOUTS[i].width;

            if (memento != null) {
                // gAO̕擾Ă
                Integer widthInt = memento.getInteger(TAG_COLUMN_WIDTH + i);
                if (widthInt != null && widthInt.intValue() > 0) {
                    width = widthInt.intValue();
                }
            }
            result[i] = new ColumnPixelData(width);
        }
        return result;
    }

    /*
     * ( Javadoc)
     * 
     * @see org.eclipse.ui.part.ViewPart#saveState(org.eclipse.ui.IMemento)
     */
    public void saveState(IMemento memento) {
        super.saveState(memento);
        saveColumnWidth(memento);
    }

    /**
     * Jgɕۑ郁\bhłB
     * 
     * @param memento
     */
    private void saveColumnWidth(IMemento memento) {
        TableColumn[] columns = viewer.getTable().getColumns();
        for (int i = 0; i < columns.length; i++) {
            memento.putInteger(TAG_COLUMN_WIDTH + i, columns[i].getWidth());
        }
    }

    /**
     * ̕Ōs\bhłB ʂr[ɔzu܂B
     * 
     * @param text
     *            
     */
    public void search(final String text) {

        SearchJob job = new SearchJob("Google Search", text, viewer);
        // _CAOo
        job.setUser(true);
        job.schedule();

    }

    private void createActions() {
        openBrowserAction = new Action("TCgɃANZX") {
            public void run() {
                ISelection selection = viewer.getSelection();
                Object obj = ((IStructuredSelection) selection)
                        .getFirstElement();
                if (obj != null) {
                    ResultElement element = (ResultElement) obj;
                    executeBrowser(element.getURL());
                }
            }
        };

        openBrowserAction.setToolTipText("TCgɃANZX");
        openBrowserAction.setImageDescriptor(ImageDescriptor.createFromFile(
                getClass(), "home.gif"));
        doubleClickAction = new Action("") {
            public void run() {
                ISelection selection = viewer.getSelection();
                Object obj = ((IStructuredSelection) selection)
                        .getFirstElement();

                ResultElement element = (ResultElement) obj;
                executeBrowser(element.getURL());
            }
        };

        clearAction = new Action("NA") {
            public void run() {
                viewer.setInput(new Object());
            }
        };
        clearAction.setImageDescriptor(ImageDescriptor.createFromFile(
                getClass(), "clear.gif"));

    }

    private void executeBrowser(String url) {
        // gq"html"̃AvP[VJB
        Program program = Program.findProgram("html");
        logger.debug("URLJ܂F " + url);
        if (program != null) {
            program.execute(url);
        } else {
            logger.warn("uEU܂BOS̃oOȂ");
            logger.debug("dȂ̂ŁAWindowsp̂ł܂B");
            try {
                Runtime.getRuntime().exec(
                        new String[] { "rundll32.exe",
                                "url.dll,FileProtocolHandler", url });
            } catch (IOException e) {
                logger.error("WindowŝłAuEU܂łBOS̃oOȂ");
            }
        }

    }

    private void initializeToolBar() {
        IToolBarManager tbm = getViewSite().getActionBars().getToolBarManager();

        tbm.add(clearAction);

        tbm.add(openBrowserAction);
    }

    private void initializeMenu() {
        IMenuManager manager = getViewSite().getActionBars().getMenuManager();
    }

    public void setFocus() {
    }

    private class DragSourceAdapterImpl extends DragSourceAdapter {
        private StructuredViewer viewer;

        public DragSourceAdapterImpl(StructuredViewer viewer) {
            this.viewer = viewer;
        }

        /**
         * hbOf[^eventɒlZbg邽߂̃\bh Method declared on DragSourceListener
         */
        public void dragSetData(DragSourceEvent event) {
            logger.debug("dragSetData(DragSourceEvent) - start");

            // viewerResultElementoB
            IStructuredSelection selection = (IStructuredSelection) viewer
                    .getSelection();
            Object obj = ((IStructuredSelection) selection).getFirstElement();
            ResultElement element = (ResultElement) obj;

            // ŃCxgĂH
            if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
                logger.debug("FileTransfer event.dataType");
                // FileTransferAt@CNX쐬
                // t@C̃pX̔zeventɃZbgB
                // (΁AeventŎw肳ꂽꏊ̃t@ChbvӏɈړ)
                try {
                    File resultFile = createFileFromResultElement(element);
                    event.data = new String[] { resultFile.getAbsolutePath() };
                } catch (IOException e) {
                    logger.error(e);
                    GooglePlugin.log(e);
                }
                // ł̃t@CRs[B
            } else if (TextTransfer.getInstance().isSupportedType(
                    event.dataType)) {
                // TextTransferAʂ̃TCg̃^CgeventɃZbg
                logger.debug("TextTransfer event.dataType");
                event.data = element.getTitle();
            } else if (PluginTransfer.getInstance().isSupportedType(
                    event.dataType)) {
                logger.debug("PluginTransfer event.dataType");
            }
            logger.debug(event);
            logger.debug("dragSetData(DragSourceEvent) - end");
        }

        private File createFileFromResultElement(ResultElement element)
                throws IOException {

            // e|Ƀt@CāAt@CgĈړB
            String name = element.getTitle();
            File resultFile = File.createTempFile(Utility.filter(name), ".url");
            // t@CɕςȂ̂̂ƁAOsK؂ȃmB
            Utility.write(element.getURL(), resultFile);
            logger.debug(resultFile.getAbsolutePath());
            resultFile.deleteOnExit();
            return resultFile;
        }

    }

    /**
     * wb_NbNƂɔ郊Xi[쐬B
     * 
     * @return
     */
    private SelectionListener getHeaderListener() {
        return new SelectionAdapter() {
            /**
             * Handles the case of user selecting the header area.
             */
            public void widgetSelected(SelectionEvent e) {
                // Jԍ擾
                int column = viewer.getTable().indexOf((TableColumn) e.widget);
                // TopPrioritỹJAo[XB
                if (column == getSorter().getTopPriority()) {
                    getSorter().reverseTopPriority();
                } else {
                    // łȂATopPriorityɂB
                    getSorter().setTopPriority(column);
                }
                setSorter(getSorter());
            }
        };
    }

    private TableSorter getSorter() {
        if (sorter == null) {
            int[] priorities = new int[getFields().length];
            int[] directions = new int[getFields().length];
            for (int i = 0; i < getFields().length; i++) {
                priorities[i] = i;
            }
            // 1Ŗ߂
            Arrays.fill(directions, TableSorter.ASCENDING);
            sorter = new TableSorter(getFields(), priorities, directions);
            // sorter.restoreState(getDialogSettings());
        }
        return sorter;
    }

    /**
     * @param aSorter
     */
    private void setSorter(TableSorter aSorter) {
        TableSorter newSorter = new TableSorter(aSorter);
        sorter = newSorter;
        // newSorter.saveState(getDialogSettings());
        sorterChanged();
    }

    /**
     * \[^[ύXꂽƂɌĂ΂郁\bhBĕ`悵ĂH
     */
    private void sorterChanged() {
        viewer.setSorter(getSorter());

        getSite().getShell().getDisplay().asyncExec(new Runnable() {
            public void run() {
                viewer.getControl().setRedraw(false);
                viewer.refresh(false);
                viewer.getControl().setRedraw(true);
            }
        });
        logger.debug("\[g܂");
    }

    private IField[] getFields() {
        // IField[] vProps = getVisibleFields();
        // IField[] hProps = getHiddenFields();
        // IField[] fields = new IField[vProps.length + hProps.length];
        // System.arraycopy(vProps, 0, fields, 0, vProps.length);
        // System.arraycopy(hProps, 0, fields, vProps.length, hProps.length);
        //        
        // return fields;
        return VISIBLE_FIELDS;
    }

}
