/*******************************************************************************
 * Copyright (c) 2005 Masatomi KINO.
 * All rights reserved. 
 * $Id: SearchJob.java,v 1.1 2005/06/19 03:32:15 cvsuser Exp $
 *******************************************************************************/
//쐬: 2005/06/18
package nu.mine.kino.plugin.google.ui.views;

import nu.mine.kino.googleapis.GoogleSearchResult;
import nu.mine.kino.googleapis.ResultElement;
import nu.mine.kino.plugin.google.core.GoogleCorePlugin;
import nu.mine.kino.plugin.google.ui.GooglePlugin;
import nu.mine.kino.plugin.google.ui.preferences.PreferenceConstants;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/**
 * @author Masatomi KINO
 * @version $Revision: 1.1 $
 */
class SearchJob extends Job {
    /**
     * Logger for this class
     */
    private final Logger logger = Logger.getLogger(SearchJob.class);

    private String text;

    private ResultElement[] elements;

    private final TableViewer viewer;

    /**
     * @param name
     */
    public SearchJob(String name, String text, TableViewer viewer) {
        super(name);
        this.text = text;
        this.viewer = viewer;
    }

    public IStatus run(IProgressMonitor monitor) {
        logger.debug("run(IProgressMonitor) - start");

        monitor.beginTask("u" + text + "vGoogle...", 10);

        try {
            String searchText = null;

            // Xy`FbNJn
            monitor.subTask("Xy`FbN");
            monitor.worked(1);
            searchText = GooglePlugin.getDefault().getSplellingSuggestion(text,
                    monitor);
            monitor.worked(3);
            // Xy`FbNI

            if (monitor.isCanceled()) {
                logger.debug("run(IProgressMonitor) - end");
                return Status.CANCEL_STATUS;
            }

            // Jn
            monitor.subTask("");
            // ݒʂAGoogle Key擾

            String myGoogleKey = GooglePlugin.getDefault().getPreferenceStore()
                    .getString(PreferenceConstants.GOOGLE_KEY);
            GoogleSearchResult result = GoogleCorePlugin.getDefault().search(
                    myGoogleKey, searchText);

            monitor.worked(3);
            // I
            logger.debug("run(IProgressMonitor) - I");

            if (monitor.isCanceled()) {
                logger.debug("run(IProgressMonitor) - end");
                return Status.CANCEL_STATUS;
            }

            // ResultElement[] elementsTmp = result.getResultElements();
            // elements = new ResultElement[elementsTmp.length];
            // for (int i = 0; i < elementsTmp.length; i++) {
            // elements[i] = new ResultElementAdapter(elementsTmp[i]);
            // }

            elements = result.getResultElements();

            logger.debug("run(IProgressMonitor) - Elements̎擾");

        } catch (CoreException e) {
            logger.error("run(IProgressMonitor)", e);
            return e.getStatus();
        }

        // ////////////////////////

        // ʂO0łȂꍇ͕`悷B
        // UIXbhɈϏ
        if (elements.length != 0) {
            checkAsyncExec(new Runnable() {
                public void run() {
                    logger.debug("run() - start");
                    // Viewer[Uɂďꂽ܂ꍇ

                    if (!viewer.getTable().isDisposed()) {
                        viewer.setInput(elements);
                    }
                    logger.debug("run() - end");
                }
            });
        } else {
            // ʂO0̏ꍇ̓G[_CAOB
            checkAsyncExec(informationThread("ʂ0ł"));
        }

        // ////////////////////////
        monitor.worked(10);
        monitor.done();

        logger.debug("run(IProgressMonitor) - end");
        return Status.OK_STATUS;
    }

    private Runnable informationThread(final String message) {
        return new Runnable() {
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                MessageDialog.openInformation(window.getShell(), "Google",
                        message);
            }
        };

    }

    private boolean checkAsyncExec(Runnable thread) {
        if (!Display.getDefault().isDisposed()) {
            Display.getDefault().asyncExec(thread);
            return true;
        } else {
            return false;
        }
    }
}