package jp.wda.gpss.system;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import jp.wda.gpss.Socklet;

/**
 * Socklet𓮓Iɓǂݍނ߂̃NX[_hNXB<BR>
 *
 * @version	1.04		2003/11/27
 * @since		1.04		2003/11/27
 * @author	amoi
 */
class SockletLoader extends ClassLoader {
	// RXgN^ ///////////////////////////////////////////////////////////////////
	//                                                                    Constructors //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 *	ftHg̐ݒpăIuWFNg\zRXgN^
	 */
	SockletLoader(File classpath, ClassLoader parent) {
		super(parent);
		this.classpath = classpath;
	}

	// tB[h` ///////////////////////////////////////////////////////////////
	//                                                                          Fields //
	/////////////////////////////////////////////////////////////////////////////////////

	/**
	 * [h̃NXpX
	 */
	private File classpath;

	// CX^X\bh /////////////////////////////////////////////////////////////
	//                                                                Instance Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * SockletNXǂݍ݂܂B
	 * 
	 * @param className ǂݍSockletNX
	 * @return ǂݍ܂ꂽSocklet
	 * 
	 * @throws ClassNotFoundException
	 * @throws IllegalArgumentException
	 * @throws IllegalAccessException
	 * @throws InstantiationException
	 */
	Socklet loadSocklet(String className)
		throws
			ClassNotFoundException,
			IllegalArgumentException,
			IllegalAccessException,
			InstantiationException {
		return (Socklet) loadObject(className);

	}

	/**
	 * w肳ꂽNX̃NXǂݍ݂܂B
	 * 
	 * @param className ǂݍރNX
	 * @return ǂݍ܂ꂽNX̃CX^X
	 * 
	 * @throws ClassNotFoundException
	 * @throws IllegalArgumentException
	 * @throws IllegalAccessException
	 * @throws InstantiationException
	 */
	Object loadObject(String className)
		throws
			ClassNotFoundException,
			IllegalArgumentException,
			IllegalAccessException,
			InstantiationException {
		Class cls = findClass(className);
		if (cls != null) {
			return cls.newInstance();
		}

		throw new ClassNotFoundException(className);
	}

	/* ***********************************************************************>> */;
	/**
	 * ClassLoader#findClass(String className)̃I[o[Ch
	 * 
	 * @param className ǂݍރNX
	 * @return ǂݍ܂ꂽNX
	 * 
	 * @throws ClassNotFoundException
	 * @see java.lang.ClassLoader#findClass(java.lang.String)
	 */
	public Class findClass(String className) throws ClassNotFoundException {
		Class cls = findLoadedClass(className);
		if (cls != null) {
			return cls;
		}

		try {
			return defineClass(className);
		} catch (Throwable ex) {
			return getParent().loadClass(className);
		}
	}

	/**
	 * ClassLoader#loadClass(java.lang.String)̃I[o[Ch
	 * 
	 * @param className ǂݍރNX
	 * @return ǂݍ܂ꂽNX
	 * 
	 * @throws ClassNotFoundException
	 * @see java.lang.ClassLoader#loadClass(java.lang.String)
	 */
	public Class loadClass(String className) throws ClassNotFoundException {
		return loadClass(className, false);
	}

	/**
	 * ClassLoader#loadClass(java.lang.String, boolean)̃I[o[Ch
	 * 
	 * @param className ǂݍރNX
	 * @param resolve   NXߏ邩ǂ 
	 * @return ǂݍ܂ꂽNX
	 * 
	 * @throws ClassNotFoundException
	 * @see java.lang.ClassLoader#loadClass(java.lang.String, boolean)
	 */
	protected Class loadClass(String className, boolean resolve)
		throws ClassNotFoundException {
		Class cls = findClass(className);
		if (resolve) {
			resolveClass(cls);
		}

		return cls;
	}

	/* ***********************************************************************>> */;
	/**
	 * w肳ꂽNX̃NXǂݍ݂܂B
	 * 
	 * @param className ǂݍރNX
	 * @return ǂݍ܂ꂽNX
	 * 
	 * @throws IOException
	 * @throws ClassNotFoundException
	 * @throws IllegalArgumentException
	 * @throws IllegalAccessException
	 * @throws InstantiationException
	 */
	Class defineClass(String className)
		throws
			IOException,
			ClassNotFoundException,
			IllegalArgumentException,
			IllegalAccessException,
			InstantiationException {
		String classFilePath =
			className.replace('.', File.separatorChar) + ".class";
		File classFile = new File(classpath, classFilePath);
		if (!classFile.exists()) {
			return Class.forName(className);
		}

		byte[] bytes = getBytes(classFile);
		Class cls = defineClass(className, bytes, 0, bytes.length);
		resolveClass(cls);
		return cls;
	}

	// \bh /////////////////////////////////////////////////////////////////////
	//                                                                 Private Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * NXt@CoCgƂēǂݍ݂܂B
	 * 
	 * @param file ǂݍރNXt@C
	 * @return oCg
	 * 
	 * @throws IOException
	 */
	private byte[] getBytes(File file) throws IOException {
		FileInputStream fis = null;
		byte[] bytes = null;
		byte[] buf = new byte[20480];
		try {
			fis = new FileInputStream(file);
			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			int n = 0;
			while ((n = fis.read(buf, 0, buf.length)) != -1) {
				baos.write(buf, 0, n);
			}
			bytes = baos.toByteArray();
		} finally {
			if (fis != null) {
				fis.close();
			}
		}
		return bytes;
	}
}
