/*
 * Decompiled with CFR 0.152.
 */
package FESI.Interpreter;

import FESI.ClassFile.EventAdaptorClassFile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public final class EventAdaptorGenerator
extends ClassLoader {
    private static String packagePrefix = "FESI.ClassFile";
    private static String adaptorInfix = ".DYN_EE_ADAPTOR.";
    private static String adaptorClassNamePrefix = String.valueOf(packagePrefix) + adaptorInfix;
    private static EventAdaptorGenerator generator = new EventAdaptorGenerator();

    private boolean debug() {
        return false;
    }

    private EventAdaptorGenerator() {
    }

    private static Class loadClassNamed(String string) throws ClassNotFoundException {
        return generator.loadClass(string);
    }

    static Class getAdaptorClassForListenerClass(Class clazz) throws ClassNotFoundException {
        return EventAdaptorGenerator.loadClassNamed(EventAdaptorGenerator.mapListenerNameToAdaptorName(clazz.getName()));
    }

    static Class getAdaptorClassForListenerClass(String string) throws ClassNotFoundException {
        return EventAdaptorGenerator.loadClassNamed(EventAdaptorGenerator.mapListenerNameToAdaptorName(string));
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(string);
        if (this.debug()) {
            System.err.println("loadClass(" + string + ")");
        }
        if (clazz == null) {
            if (EventAdaptorGenerator.isAdaptorClassName(string)) {
                clazz = this.generateAdaptorClass(string);
            } else {
                try {
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    if (classLoader != null) {
                        clazz = classLoader.loadClass(string);
                    }
                    if (clazz == null) {
                        clazz = this.findSystemClass(string);
                    }
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    throw new ClassNotFoundException(noClassDefFoundError.getMessage());
                }
            }
        }
        if (clazz != null) {
            if (bl) {
                this.resolveClass(clazz);
            }
        } else {
            throw new ClassNotFoundException(string);
        }
        if (this.debug()) {
            System.err.println("loaded: " + clazz.getName());
        }
        return clazz;
    }

    private static String mapListenerNameToAdaptorName(String string) {
        return String.valueOf(adaptorClassNamePrefix) + string;
    }

    private static boolean isAdaptorClassName(String string) {
        return string.startsWith(adaptorClassNamePrefix);
    }

    public static String getBaseNameFromAdaptorName(String string) {
        if (string != null && EventAdaptorGenerator.isAdaptorClassName(string)) {
            return string.substring(adaptorClassNamePrefix.length());
        }
        return null;
    }

    private Class generateAdaptorClass(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        byte[] byArray = null;
        Class<?> clazz = null;
        if (this.debug()) {
            System.err.println("generateAdaptorClass(" + string + ")");
        }
        try {
            new EventAdaptorClassFile(string, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        byArray = byteArrayOutputStream.toByteArray();
        try {
            clazz = this.defineClass(string, byArray, 0, byArray.length);
        }
        catch (ClassFormatError classFormatError) {
            System.err.println("Failed to define adaptor for " + string);
            System.err.println("Caught: " + classFormatError);
            classFormatError.printStackTrace();
        }
        return clazz;
    }
}

