package jp.moja.socklet.util.security;

import jp.wda.gpss.SocketProcessor;

/**
 * IPAhXŐڑs`FbJ[
 * @author TakenoriAdachi(TheCoolMuseum)
 */
public class IPAddressChecker extends ClientChecker {

	private String[] addresses;

	private int trueOperation;

	private int falseOperation;

	public IPAddressChecker(String addresses, int trueOperation, int falseOperation) {
		this.addresses = addresses.split(",");
		for (int i = 0; i < this.addresses.length; i++) {
			String str = this.addresses[i];
			str = str.trim();
			str = str.replaceAll("\\.", "\\\\.");
			str = str.replaceAll("\\*", ".*");
			this.addresses[i] = str;
		}
		this.trueOperation = trueOperation;
		this.falseOperation = falseOperation;
	}

	public int enter(SocketProcessor client) {
		String ipAddress = client.getIPAddress();
		return check(ipAddress);
	}

	private int check(String ipAddress) {
		for (int i = 0; i < this.addresses.length; i++) {
			if (ipAddress.matches(addresses[i])) {
				return trueOperation;
			}
		}
		return falseOperation;
	}
}
