package jp.wda.gpss.system;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import jp.moja.socklet.util.security.AccessController;
import jp.wda.gpss.GeneralSocklet;
import jp.wda.gpss.Progress;
import jp.wda.gpss.Socklet;
import jp.wda.gpss.SockletDeployInfo;
import jp.wda.gpss.SockletDeployingException;
import jp.wda.gpss.util.Finder;
import jp.wda.gpss.util.FinderElement;

import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

/**
 * \Pbg҂CT[oNX<BR>
 *
 * @version	1.04		2003/11/27
 * @since		1.00004	2003/05/25
 * @author	amoi
 */
public abstract class ExecutableBase implements Runnable {
	// RXgN^ ///////////////////////////////////////////////////////////////////
	//                                                                    Constructors //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 *	ftHg̐ݒpăIuWFNg\zRXgN^
	 */
	ExecutableBase(Configuration config) {
		super();

		// ݒ
		this.config = config;
		startServer();
	}

	// JtB[h ///////////////////////////////////////////////////////////////////
	//                                                            Public Static Fields //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * ftHgSocklet
	 */
	public static final String DEFAULT_APPLICATION_NAME = "Default";
	/**
	 * VXeR}hSocklet
	 */
	public static final String SYSTEM_APPLICATION_NAME = "SystemCommandSocklet";
	/**
	 * Ҏ󂯃T[oɂĔzꂽƂ<BR>
	 * gpss.Socklet#deployedBy()œꂽSockletA̕Ɠꍇ́A
	 * Ҏ󂯃T[oɂĔzꂽƂӖ܂B
	 * 
	 * @see jp.wda.gpss.Socklet#deployedBy()
	 */
	public static final String DEPLOY_BY_SYSTEM = "BySystemServer";

	/* ***********************************************************************>> */;
	/**
	 * ftHg̃bZ[Wobt@TCY
	 */
	public static final int DEFAULT_BUFFER_SIZE = 30;

	// tB[h` ///////////////////////////////////////////////////////////////
	//                                                                          Fields //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * ScriptSocklet[hp̃NX[_
	 */
	protected SockletLoader scriptLoader;

	/* ***********************************************************************>> */;
	/**
	 * T[oݒ
	 */
	private Configuration config;
	/**
	 * ݒt@Cɐݒ肳ꂽA\Pbg̃GR[fBO擾܂B
	 * @return GR[fBO
	 */
	public String getEncoding() {
		return config.getEncoding();
	}
	/**
	 * ݒt@Cɐݒ肳ꂽAT[ȏҎ󂯃|[gԍ擾܂B
	 * @return T[ȏҎ󂯃|[gԍ
	 */
	public int getPort() {
		return config.getPort();
	}
	/**
	 * ݒt@Cɐݒ肳ꂽAڑpR}h̃^CAEgԁi~bj擾܂B
	 * @return ڑpR}h̃^CAEgԁi~bj
	 */
	public int getInitialTimeout() {
		return config.getTimeout();
	}
	/**
	 * ݒt@Cɐݒ肳ꂽAbZ[WMpobt@TCY擾܂B
	 * @return bZ[WMpobt@TCY
	 */
	public int getMessagesBufferSize() {
		return config.getMessagesBufferSize();
	}
	/**
	 * w肳ꂽzSockletȂꍇɁAftHgSockletgp邩ǂB
	 * gpꍇ͐^Ԃ܂B
	 * ̐ݒ͏ݒt@C<system default="validate / invalidate">ɂčsȂ܂B
	 * @return ftHgSockletgp邩ǂ
	 */
	boolean isUsingDefault() {
		return config.isUsingDefault();
	}
	/**
	 * w肳ꂽźASockletz擾܂B
	 * @param name z
	 * @return Sockletz
	 */
	SockletDeployInfo getSockletInformation(String name) {
		return config.getInformation(name);
	}
	/**
	 * w肳ꂽgq̃XNvgt@Czu擾܂B
	 * @param ext gq
	 * @return XNvgt@Czu
	 */
	ScriptInfo getScriptInfomation(String ext) {
		return config.getScriptInfomation(ext);
	}
	/**
	 * w肳ꂽÕXNvgSockletz擾܂B
	 * @param name z
	 * @return Sockletz
	 */
	SockletDeployInfo getScriptSockletInformation(String name) {
		return config.getScriptApplicationInfo(name);
	}

	AccessController getSecurityController() {
		return config.getSecurityController();
	}

	/* ***********************************************************************>> */;
	/**
	 * VXeR}hpSocklet
	 */
	private SystemCommandSocklet syscomsocklet = null;

	/**
	 * SystemCommandSocklet̔zēǍ܂B
	 */
	void reloadSystemCommandInfo() {
		syscomsocklet.setInfo(this, config.getSyscomInfo());
	}

	/**
	 * w肳ꂽSystemCommandSockletÃT[oŋNꂽSockletł邩mF܂B
	 * @param sys mFSystemCommandSocklet
	 * @return ̃T[oŋNꂽSockletłΐ^
	 */
	boolean checkSystemCommandSocklet(SystemCommandSocklet sys) {
		return (sys != null && sys == syscomsocklet);
	}

	/**
	 * SystemCommandSockletɎwSockleť݂̐lʒm܂B
	 * @param app l̕ωSocklet
	 */
	void notifyToSystemCommandSocklet(Socklet app) {
		if (syscomsocklet != null
			&& !(app instanceof SystemCommandSocklet)
			&& DEPLOY_BY_SYSTEM.equals(app.deployedBy())) {
			syscomsocklet.sendAllToClients(
				"ntf=" + app.getName() + ":" + app.countClients());
		}
	}

	/* ***********************************************************************>> */;
	/**
	 * Sockletꗗ
	 */
	private ArrayList apps;
	/**
	 * SockletꗗIteratorƂĎ擾܂B
	 * @return Sockletꗗ
	 */
	Iterator getSocklets() {
		return new ArrayList(apps).iterator();
	}

	/**
	 * w肳ꂽzSocklet擾܂B<BR>
	 * w肳ꂽzSocklet̃T[oɔzĂȂꍇ́AnullԂ܂B
	 * 
	 * @param appname Sockletz
	 * @return w肳ꂽzSocklet
	 */
	public Socklet getSocklet(String appname) {
		return (Socklet)new SAFinderByName(appname).get(apps);
	}

	/**
	 * ݋NSockletꗗAJ}؂ŕ\擾܂B
	 */
	public String getSockletsList() {
		StringBuffer ret = new StringBuffer();
		ret.append("lst=");
		Iterator it = getSocklets();
		boolean delsw = it.hasNext();
		while (it.hasNext()) {
			Socklet socklet = (Socklet)it.next();
			if (socklet == syscomsocklet
				|| !DEPLOY_BY_SYSTEM.equals(socklet.deployedBy())) {
				continue;
			}
			ret.append(socklet.getName());
			ret.append(':');
			ret.append(socklet.countClients());
			ret.append(',');
		}
		if (delsw) {
			ret.deleteCharAt(ret.length() - 1);
		}

		return ret.toString();
	}

	/**
	 * w肳ꂽSockletI܂B
	 * @param socklet ISocklet
	 * @param message NCAgɑIbZ[W
	 */
	void terminateSocklet(Socklet socklet, String message) {
		if (socklet == null) {
			return;
		}

		socklet.disconnectAllClients(message);
		socklet.destroy();
		apps.remove(socklet);
		terminateLinkedSocklets(
			new SAFinderByDeployer(socklet.getName()).getList(apps),
			message);
	}

	/**
	 * zAgSockletI܂B
	 * @param links zAgSockletꗗ
	 * @param message NCAgɑIbZ[W
	 */
	private void terminateLinkedSocklets(List links, String message) {
		for (int i = 0; i < links.size(); i++) {
			terminateSocklet((Socklet)links.get(i), message);
		}
	}

	/* ***********************************************************************>> */;
	/**
	 * \Pbg󋵐iǗIuWFNg
	 */
	private Progress loggers = new Progress();
	/**
	 * \Pbg󋵐iǗIuWFNg擾܂B
	 * @return \Pbg󋵐iǗIuWFNg
	 */
	public Progress getProgress() {
		return loggers;
	}

	// CX^X\bh /////////////////////////////////////////////////////////////
	//                                                                Instance Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * NCAg\PbgIuWFNgAڑpR}hMA
	 * NCAg\PbgIuWFNg܂B<BR>
	 * <BR>
	 * ڑpR}h":"؂ŁA͈ȉ̒ʂłB<BR>
	 * <HR>
	 * Socklet̔z:[U[:pX[h:p[^
	 * <HR>
	 * [U[ApX[hyяp[^͏ȗł܂B<BR>
	 * o^ĂȂSockletw肳ꂽꍇ́ASockletgp܂B<BR>
	 * <BR>
	 * p[^"&"؂ŁA͈ȉ̒ʂłB
	 * <HR>
	 * p[^=l&p[^=l&...
	 * <HR>
	 * <BR>
	 * ڑR}h̗܂B<BR>
	 * <B>YChat:amoi:****:chatroom=ROOM1&charactor=smily</B>
	 * 
	 * @param client NCAg\PbgIuWFNg
	 * @param command ڑpR}h
	 */
	public void doInitialCommand(SocketProcessorBase client, String command) {
		//-- 040319 TakenoriAdachi
		// hC|V[ʒm@\
		// <cross-domain-request/>Ȃ̂<policy-file-request/>Ȃ̂mF
		if (command.startsWith("<cross-domain-request")
			|| command.startsWith("<policy-file-request")) {
			//System.out.println(command);
			String xml = config.getCrossDomainPolicy();
			client.send(xml);
			return;
		}
		//--
		String[] commandbuf = new String[] { command };

		// AvP[Vݒ
		String appname = getNextCommand(commandbuf, ":");
		if (appname == null || appname.length() == 0) {
			appname = DEFAULT_APPLICATION_NAME;
		}

		Socklet app = getSocklet(appname);
		if (app == null) {
			if (isUsingDefault()) {
				app = (Socklet)apps.get(0);
			} else {
				client.setApplication(null);
				return;
			}
		}

		app.addClient(client);
		client.setApplication(app);
		notifyToSystemCommandSocklet(app);
		loggers.syslog(
			"["
				+ client.getIPAddress()
				+ "] connect to \""
				+ app.getName()
				+ "\" (ID:"
				+ client.getClientID()
				+ ")");

		if (commandbuf[0] == null) {
			return;
		}

		// [U[ݒ
		String username = getNextCommand(commandbuf, ":");
		if (username != null && username.length() > 0) {
			client.setUserName(username);
		}
		if (commandbuf[0] == null) {
			return;
		}

		// pX[hݒ
		String password = getNextCommand(commandbuf, ":");
		if (password != null && password.length() > 0) {
			client.setPassword(password);
		}
		if (commandbuf[0] == null) {
			return;
		}

		// p[^ݒ
		String params = getNextCommand(commandbuf, ":");
		if (params != null && params.length() > 0) {
			String[] paramsbuf = new String[] { params };
			while (paramsbuf[0] != null) {
				String param = getNextCommand(paramsbuf, "&");
				client.addInitParam(param);
			}
		}
	}

	/* ***********************************************************************>> */;
	/**
	 * Ҏ󂯃T[oXbh̏ełB<BR>
	 * ̃\bhaccept()\bhĂ΂܂̂ŁA
	 * Xbh̋̓Iȏ͂̃\bhI[o[ChċLqĂB<BR>
	 * ܂AsetRestartAfterShutdown()\bhĂяoaccept()\bh̏~ƁA
	 * ̌㒼ɑҎ󂯃T[oXbhċN܂B
	 * 
	 * @see ExecutableBase#accept()
	 * @see java.lang.Runnable#run()
	 */
	public void run() {
		try {
			accept();
		} finally {
			if (restartsw) {
				startServer();
			}
		}
	}

	/* ***********************************************************************>> */;
	/**
	 * X^[gXe[^X
	 */
	private boolean restartsw = false;
	/**
	 * Ҏ󂯃XbhIƁǍ㒼ɃT[oċN܂B
	 */
	void setRestartAfterShutdown() {
		restartsw = true;
	}

	// \bh /////////////////////////////////////////////////////////////////////
	//                                                                 Private Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * ݒt@Cǂݍ݁AK[ݒ肵܂B
	 * 
	 * @return ǂݍ݂ɐ^
	 */
	void loadConfig() throws ConfigurationError {
		config.loadConfig();
		// Oo͐ݒ
		if (!config.setSysLog()) {
			// ftHg̃VXeOo͐ݒ
			config.addLogger(
				Progress.SYSTEM_LOGGER,
				"WARN",
				"./logs/gpss.log",
				"UTF-8",
				"[%d{yyyy/MM/dd HH:mm:ss} %-5p] %m%n");
		}
		PropertyConfigurator.configure(config.getLogProperties());
		Iterator lit = config.getLoggerNames().iterator();
		while (lit.hasNext()) {
			String name = (String)lit.next();
			Logger logger = Logger.getLogger(name);
			if (logger != null) {
				loggers.setLogger(name, logger);
			}
		}

		return;
	}

	/* ***********************************************************************>> */;
	/**
	 * t@Cǂݍ݁AT[o[AXbhJn܂B
	 */
	void startServer() {
		this.apps = new ArrayList();
		try {
			loadConfig();
		} catch (ConfigurationError e) {
			System.out.println(e.toString());
			System.out.println("T[o[Nł܂łB");
			return;
		}

		// ftHgSocklet̒ǉ
		if (!config.setDefault()) {
			DefaultSocklet dsock = new DefaultSocklet();
			dsock.init(
				new SockletDeployInfo(DEFAULT_APPLICATION_NAME),
				null,
				loggers);
			apps.add(dsock);
		}

		// VXeR}hSocklet̒ǉ
		syscomsocklet = new SystemCommandSocklet();
		syscomsocklet.setMain(this);
		syscomsocklet.init(config.getSyscomInfo(), null, loggers);
		apps.add(syscomsocklet);

		// ScriptSocklet̔zp̃NX[_ݒ
		this.scriptLoader =
			new SockletLoader(
				config.getClasspath(),
				Thread.currentThread().getContextClassLoader());

		// Socklet̔z
		Iterator it = config.getInformations().iterator();
		while (it.hasNext()) {
			SockletDeployInfo sockletInfo = (SockletDeployInfo)it.next();
			try {
				Socklet socklet =
					deployNewSocklet(sockletInfo, DEPLOY_BY_SYSTEM, null);
			} catch (SockletDeployingException e) {
				loggers.errlog("Socklet̔zɎs܂B", e);
				continue;
			}
			loggers.syslog(
				"Socklet\""
					+ sockletInfo.getName()
					+ "\"("
					+ sockletInfo.getClassname()
					+ ")z܂B");
		}

		// XNvgSocklet̔z
		it = config.getScriptInfomations().iterator();
		if (it.hasNext()) {
			loggers.syslog("XNvgSocklet̔zJn܂B");
		}
		while (it.hasNext()) {
			ScriptInfo info = (ScriptInfo)it.next();
			loggers.syslog(
				info.getDirectory().getAbsolutePath()
					+ "ɂ"
					+ info.getExtention()
					+ "XNvgAvP[Vz܂B");
			deployScripts(info.getDirectory(), info, "");
		}

		// ҂XbhJn
		restartsw = false;
		new Thread(this, "MainServer").start();
	}

	/* ***********************************************************************>> */;
	/**
	 * VKSockletNAVɃT[oɔz܂B
	 * 
	 * @param sockletinfo ǉSockletz
	 * @exception SockletDeployingException Socklet̔zɎsꍇ
	 */
	Socklet deployNewSocklet(
		SockletDeployInfo sockletinfo,
		String deployer,
		SockletLoader loader)
		throws SockletDeployingException {
		if (sockletinfo == null) {
			return null;
		}
		if (sockletinfo.getName() == null || sockletinfo.getName().length() == 0) {
			throw new SockletDeployingException("zw肳Ă܂B");
		}
		if (sockletinfo.getClassname() == null
			|| sockletinfo.getClassname().length() == 0) {
			throw new SockletDeployingException(
				"z" + sockletinfo.getName() + "SockletNXw肳Ă܂B");
		}
		if (getSocklet(sockletinfo.getName()) != null) {
			throw new SockletDeployingException(
				"z" + sockletinfo.getName() + "Socklet͊ɔzĂ܂B");
		}

		if (loader == null) {
			loader = new SockletLoader(config.getClasspath(), this.scriptLoader);
		}

		Socklet socklet = null;
		try {
			socklet = loader.loadSocklet(sockletinfo.getClassname());
		} catch (ClassCastException e) {
			e.printStackTrace();
			throw new SockletDeployingException(
				"NX["
					+ sockletinfo.getName()
					+ "("
					+ sockletinfo.getClassname()
					+ ")]́ASockletł͂܂B");
		} catch (Throwable e) {
			throw new SockletDeployingException(
				"Socklet["
					+ sockletinfo.getName()
					+ "("
					+ sockletinfo.getClassname()
					+ ")]͌܂łB\n"
					+ e.toString());
		}
		if (socklet == null) {
			throw new SockletDeployingException(
				"Socklet["
					+ sockletinfo.getName()
					+ "("
					+ sockletinfo.getClassname()
					+ ")]܂łB");
		}

		socklet.deployedBy(this, deployer);
		if (socklet instanceof GeneralSocklet) {
			((GeneralSocklet)socklet).setMain(this);
		}

		apps.add(socklet);

		ArrayList links = new ArrayList();
		HashMap linkedSocklets = new HashMap();
		socklet.init(sockletinfo, links, loggers);

		// ASockletT[oɔzB
		Iterator it = links.iterator();
		while (it.hasNext()) {
			Object next = it.next();
			if (next instanceof SockletDeployInfo) {
				try {
					Socklet linkSocklet =
						deployNewSocklet(
							(SockletDeployInfo)next,
							socklet.getName(),
							loader);

					if (linkSocklet != null
						&& linkSocklet.allowAccessFromOtherSocklet(socklet)) {
						linkedSocklets.put(
							((SockletDeployInfo)next).getName(),
							linkSocklet);
					}
				} catch (SockletDeployingException e) {
					loggers.errlog(socklet.getName() + "̘ASockletzɎs܂B", e);
				}
			}
		}
		socklet.afterDeployedLinks(linkedSocklets);

		return socklet;
	}

	/**
	 * XNvgSocklet̔zusȂ܂B<BR>
	 * AvP[V́AXNvgzu[gfBNg̑΃pX"."ŋ؂̂ɂȂ܂B<BR>
	 * <BR>
	 * Ⴆ΁AXNvgzu[gfBNg"/scripts/"ƂƁA<BR>
	 * "/scripts/test1.fjs"XNvg"test1"SockletƂāA<BR>
	 * "/scripts/app/echo.fjs"XNvg"app.echo"SockletƂĔzu܂B<BR>
	 * <BR>
	 * XNvgzu[gfBNǵAݒt@C̒Ŏw肳܂B<BR>
	 * 
	 * @param dir zuXNvgt@C̒uĂfBNg
	 * @param info XNvgSockletzu
	 * @param header Sockletwb_
	 */
	private void deployScripts(File dir, ScriptInfo info, String header) {
		File[] childs = dir.listFiles();
		for (int i = 0; i < childs.length; i++) {
			String name = childs[i].getName();
			if (childs[i].isDirectory()) {
				deployScripts(childs[i], info, header + name + ".");
				continue;
			}

			// gq
			if (name.length() < info.getExtention().length()) {
				continue;
			}
			String ext =
				name.substring(name.length() - info.getExtention().length());
			if (!ext.equalsIgnoreCase(info.getExtention())) {
				continue;
			}

			// XNvgSocklet̒ǉz
			SockletDeployInfo sockletInfo =
				config.getScriptApplicationInfo(
					header + name.substring(0, name.length() - ext.length()));
			sockletInfo.addInitParam("source", childs[i].getAbsolutePath());
			sockletInfo.addInitParam("sourceEncoding", info.getEncoding());
			sockletInfo.setClassname(info.getJSClass().getName());
			try {
				Socklet socklet =
					deployNewSocklet(
						sockletInfo,
						DEPLOY_BY_SYSTEM,
						this.scriptLoader);
				if (socklet instanceof ScriptSocklet) {
					((ScriptSocklet)socklet).setExtention(ext);
					((ScriptSocklet)socklet).setScriptFile(childs[i]);
				}
			} catch (SockletDeployingException e) {
				loggers.errlog("Script Socklet̔zɎs܂B", e);
				continue;
			}
			loggers.syslog(
				"Script Socklet\"" + sockletInfo.getName() + "\"z܂B");
		}
	}

	// NX\bh ///////////////////////////////////////////////////////////////////
	//                                                                   Class Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * w肳ꂽR}h񂩂؂蕶܂ł̃R}h擾܂B<BR>
	 * ŃR}h񂪏Iꍇ́Acommand[0]nullɐݒ肵܂B<BR>
	 * (StringTokenizergΗǂ̂͂킩Ⴂłc)
	 * 
	 * @param command R}h
	 * @param separator ؂蕶
	 * @return ̃R}h
	 */
	protected static String getNextCommand(String[] command, String separator) {
		int sep = command[0].indexOf(separator);
		String next;
		if (sep < 0) {
			next = command[0];
			command[0] = null;
		} else {
			next = command[0].substring(0, sep);
			if (command[0].length() > sep + 1) {
				command[0] = command[0].substring(sep + 1);
			} else {
				command[0] = null;
			}
		}
		return next;
	}

	// ۃ\bh /////////////////////////////////////////////////////////////////////
	//                                                                Abstract Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * T[oJnANCAg̐ڑ󂯕t鏈LqĂB
	 * ̃\bh́ARunnable#run()\bhĂ΂܂B
	 */
	public abstract void accept();

	/* ***********************************************************************>> */;
	/**
	 * SystemCommandSockletĂ΂郁\bhłB<BR>
	 * T[oI鏈LqĂB
	 * 
	 * @param sys ĂяoSystemCommandSocklet
	 * @see jp.wda.gpss.ExecutableBase#checkSystemCommandSocklet(SystemCommandSocklet)
	 */
	abstract void shutdown(SystemCommandSocklet sys);

	/* ***********************************************************************>> */;
	/**
	 * SystemCommandSockletĂ΂郁\bhłB<BR>
	 * T[oċN鏈LqĂB
	 * 
	 * @param sys ĂяoSystemCommandSocklet
	 * @see jp.wda.gpss.ExecutableBase#checkSystemCommandSocklet(SystemCommandSocklet)
	 */
	abstract void restart(SystemCommandSocklet sys);

	/* ***********************************************************************>> */;
	/**
	 * SystemCommandSockletĂ΂郁\bhłB<BR>
	 * w肵zSockletċN鏈LqĂB
	 * 
	 * @param sys ĂяoSystemCommandSocklet
	 * @param name Sockletz
	 * @return ċNɐ^Ԃ悤ɂĂB
	 * @see jp.wda.gpss.ExecutableBase#checkSystemCommandSocklet(SystemCommandSocklet)
	 */
	abstract boolean restartSocklet(SystemCommandSocklet sys, String name);

	/* ***********************************************************************>> */;
	/**
	 * SystemCommandSockletĂ΂郁\bhłB<BR>
	 * ݒt@CēǍ鏈LqĂB
	 * 
	 * @param sys ĂяoSystemCommandSocklet
	 * @return ēǍɐ^Ԃ悤ɂĂB
	 * @see jp.wda.gpss.ExecutableBase#checkSystemCommandSocklet(SystemCommandSocklet)
	 */
	abstract boolean reloadConfig(SystemCommandSocklet sys);

	// NX ///////////////////////////////////////////////////////////////////////
	//                                                                     Inner Class //
	/////////////////////////////////////////////////////////////////////////////////////
	/**
	 *	SockletOpNX
	 */
	private class SAFinderByName extends Finder {
		public SAFinderByName(String name) {
			super();
			group.add(new SAFinderByNameElement(true, name));
		}
		public SAFinderByName(boolean not, String name) {
			super();
			group.add(new SAFinderByNameElement(not, name));
		}
		public Object getReturnValue(Object elem) {
			return elem;
		}

		private class SAFinderByNameElement extends FinderElement {
			SAFinderByNameElement(boolean not, String name) {
				super(not, name);
			}
			public Object getFindValue(Object elem) {
				if (!(elem instanceof Socklet)) {
					return null;
				}
				return ((Socklet)elem).getName();
			}
		}
	}

	/**
	 *	SockletzҖpNX
	 */
	private class SAFinderByDeployer extends Finder {
		public SAFinderByDeployer(String name) {
			super();
			group.add(new SAFinderByDeployerElement(true, name));
		}
		public SAFinderByDeployer(boolean not, String name) {
			super();
			group.add(new SAFinderByDeployerElement(not, name));
		}
		public Object getReturnValue(Object elem) {
			return elem;
		}

		private class SAFinderByDeployerElement extends FinderElement {
			SAFinderByDeployerElement(boolean not, String name) {
				super(not, name);
			}
			public Object getFindValue(Object elem) {
				if (!(elem instanceof Socklet)) {
					return null;
				}
				return ((Socklet)elem).deployedBy();
			}
		}
	}
}
