package jp.wda.gpss.system;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.Iterator;

import jp.wda.gpss.Progress;
import jp.wda.gpss.Socklet;
import jp.wda.gpss.SockletDeployInfo;
import jp.wda.gpss.SockletDeployingException;

/**
 * <FONT SIZE=2><I><B>
 * [ OProject GPSS for FlashMX ] FlashMXpėp\PbgT[o
 * </B></I></FONT><BR>
 * \Pbg҂CT[oNX<BR>
 * <BR>
 * Ԗڂ̈ɁAconfig.xmlݒt@Cw肵āANĂB<BR>
 *
 * @version	1.04		2003/11/27
 * @since		1.00		2003/04/29
 * @author	amoi, (ERE)RT
 */
public class MainNio extends ExecutableBase {
	// AvP[VGg[|Cg ///////////////////////////////////////////////
	//                                                         Application Entry Point //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * Ҏ󂯃CT[oN܂B<BR>
	 * Ԗڂ̈ɁAconfig.xmlݒt@Cw肵āANĂB<BR>
	 * 
	 * @param args
	 */
	public static void main(String[] args) {
		if (args.length == 0) {
			System.out.println("Usage : ");
			System.out.println("  java jp.wda.gpss.system.Main config.xml");
			System.out.println("    config.xml - ݒt@C");

			return;
		}
		File configfile = new File(args[0]);
		if (!configfile.exists()) {
			System.out.println("ݒt@C܂B");
			System.out.println("File : " + configfile.getAbsolutePath());
			return;
		}

		MainNio main = new MainNio(new Configuration(configfile));
	}

	// RXgN^ ///////////////////////////////////////////////////////////////////
	//                                                                    Constructors //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 *	ftHg̐ݒpăIuWFNg\zRXgN^
	 */
	private MainNio(Configuration config) {
		super(config);

		this.terminator = false;
	}

	/* ***********************************************************************>> */;
	/**
	 * JVMKx[WRN^ɂČĂ΂AIB<BR>
	 * zĂSĂSocklet̏IsȂ܂B<BR>
	 * IĂꍇ́AɉsȂ܂B
	 */
	protected void finalize() {
		if (this.terminator) {
			return;
		}

		Iterator it = getSocklets();
		while (it.hasNext()) {
			Socklet app = (Socklet) it.next();
			app.destroy();
		}
	}

	// tB[h` ///////////////////////////////////////////////////////////////
	//                                                                          Fields //
	/////////////////////////////////////////////////////////////////////////////////////

	/**
	 * T[o[`l
	 */
	private ServerSocketChannel serverChannel;
	/**
	 * ZN^[
	 */
	private Selector selector;
	
	/**
	 * T[oIXCb`
	 */
	private boolean terminator = false;

	/**
	 * f[^Mobt@
	 */
	private ByteBuffer buffer = null;
	/**
	 * bZ[Wꎞobt@
	 */
	private ByteBuffer tempBuffer = null;
	
	/**
	 * obt@̃GR[_[EfR[_[
	 */
	private Charset codec = null;

	// \bh /////////////////////////////////////////////////////////////////////
	//                                                                 Private Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * T[oJnAڑEf[^󂯕t܂B
	 * @see jp.wda.gpss.system.ExecutableBase#accept()
	 */
	public void accept() {
		System.out.println("Starting server...");

		buffer = ByteBuffer.allocateDirect(4096);
		tempBuffer = ByteBuffer.allocateDirect(4096);

		codec = Charset.forName(getEncoding());
		ServerSocket serverSocket = null;

		try {

			serverChannel = ServerSocketChannel.open();
			serverSocket = serverChannel.socket();
			selector = Selector.open();

			serverSocket.bind(new InetSocketAddress(getPort()));

			serverChannel.configureBlocking(false);

			serverChannel.register(selector, SelectionKey.OP_ACCEPT);

			// T[oNĂԂ́BBB
			while (true) {
				int n = selector.select();
				if (terminator) {
					break;
				}
				if (n == 0) {
					continue;
				}
				Iterator it = selector.selectedKeys().iterator();

				// look at each key in the selected set
				while (it.hasNext()) {
					SelectionKey key = (SelectionKey) it.next();

					//NCAgڑ
					if (key.isAcceptable()) {
						//System.out.println("Accept");
						createSocketProcessor(selector, key);
					}

					//ǂݍݏ
					if (key.isReadable()) {
						//System.out.println("Read");
						readMessage(key);
					}

					it.remove();
				}
			}
		} catch (ClosedSelectorException cse) {
			//  ZN^[N[YĂ
			getProgress().syslog("Selector closed.");
		} catch (Throwable e) {
			//  ڑsƂ`
			e.printStackTrace();
		} finally {
			if (serverChannel != null) {
				try {
					serverChannel.close();
					selector.close();
				} catch (Exception e) {
					;
				}
			}
			this.terminator = false;
		}
	}

	private void readMessage(SelectionKey key)
		throws IOException, InterruptedException {
		int length = 0;
		byte b = 0;
		SocketChannel socketChannel = (SocketChannel) key.channel();
		SocketProcessorImplNio client =
			(SocketProcessorImplNio) (key.attachment());
		buffer.clear();
		try {
			while ((length = socketChannel.read(buffer)) > 0) {
				//System.out.println("Read length = " + length);
				buffer.flip();
				while (buffer.hasRemaining()) {
					b = buffer.get();
					if (b != 0) {
						tempBuffer.put(b);
					} else {
						tempBuffer.flip();
						String message =
							codec.decode(tempBuffer).toString();
						client.setMessage(message, true);
						//System.out.println("F" + message);
						tempBuffer.clear();
					}
				}
				if (b != 0) {
					tempBuffer.flip();
					String message = codec.decode(tempBuffer).toString();
					client.setMessage(message, false);
					//System.out.println("rF" + message);
					tempBuffer.clear();
				}
				buffer.clear();
			}
		} catch (ClosedChannelException e) {
			getProgress().errlog(
				"\Pbg͊ɃN[YĂ܂B:" + client.getClientID());
		}
		if (length < 0) {
			//System.out.println("Closed");
			client.terminate();
		}
		//Thread.sleep(5000);
	}

	/* ***********************************************************************>> */;
	/**
	 * \PbgɃNCAg\PbgIuWFNg쐬܂B
	 * 
	 * @param socket	ʐMp\Pbg
	 */
	private void createSocketProcessor(Selector selector, SelectionKey key) {
		SocketProcessorImplNio client = null;
		try {
			ServerSocketChannel server = (ServerSocketChannel) key.channel();
			SocketChannel channel = server.accept();
			Socket socket = channel.socket();
			getProgress().syslog(
				"Create Client... " + socket.getInetAddress().getHostAddress());
			client =
				new SocketProcessorImplNio(
					this,
					channel,
					getEncoding(),
					getMessagesBufferSize());
			if (channel != null) {
				channel.configureBlocking(false);
				channel.register(selector, SelectionKey.OP_READ, client);
			}

			getProgress().syslog(
				"Create Client... " + socket.getInetAddress().getHostAddress());

			socket.setSoTimeout(getInitialTimeout()); //
			socket.setSoTimeout(10); //ς薳ہEE

			getProgress().syslog(
				"Welcome "
					+ client.getIPAddress()
					+ "! (ID:"
					+ client.getClientID()
					+ ")");

		} catch (InterruptedIOException e) {
			getProgress().errlog("^CAEgݒɎs܂B:" + client.getClientID(), e);
			return;
		} catch (IOException e) {
			e.printStackTrace();
			return;
		}

		return;
	}

	// SystemCommandSockletp\bh ///////////////////////////////////////////////////
	//                                                Methods for SystemCommandSocklet //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * T[oI܂B
	 * @param sys ĂяoSystemCommandSocklet
	 * @see jp.wda.gpss.ExecutableBase#shutdown(SystemCommandSocklet)
	 */
	void shutdown(SystemCommandSocklet sys) {
		if (!checkSystemCommandSocklet(sys)) {
			return;
		}

		getProgress().syslog("Shutdown server...");

		// ڑ̑SNCAgؒf
		Iterator it = getSocklets();
		while (it.hasNext()) {
			Socklet app = (Socklet) it.next();
			app.disconnectAllClients("Good by...");
			app.destroy();
		}

		this.terminator = true;

		try {
			serverChannel.close();
			selector.close();
		} catch (IOException ioe) {
			getProgress().syslog("Shutdown Failed!");
			return;
		}
		getProgress().syslog("Shutdown successfully!");
	}

	/* ***********************************************************************>> */;
	/**
	 * T[oċN܂B
	 * @param sys ĂяoSystemCommandSocklet
	 * @see jp.wda.gpss.ExecutableBase#restart(SystemCommandSocklet)
	 */
	void restart(SystemCommandSocklet sys) {
		if (!checkSystemCommandSocklet(sys)) {
			return;
		}

		setRestartAfterShutdown();
		shutdown(sys);
	}

	/* ***********************************************************************>> */;
	/**
	 * w肵zSockletċN܂
	 * 
	 * @param sys ĂяoSystemCommandSocklet
	 * @param name Sockletz
	 * @return ċNɐ^
	 * @see jp.wda.gpss.ExecutableBase#restartSocklet(SystemCommandSocklet, String)
	 */
	boolean restartSocklet(SystemCommandSocklet sys, String name) {
		if (!checkSystemCommandSocklet(sys)) {
			return false;
		}

		getProgress().syslog("Restart socklet \"" + name + "\"");
		Socklet socklet = this.getSocklet(name);
		SockletDeployInfo info = null;
		String scriptExt = null;
		File scriptFile = null;
		SockletLoader loader = null;
		if (socklet != null && socklet instanceof ScriptSocklet) {
			scriptExt = ((ScriptSocklet) socklet).getExtention();
			scriptFile = ((ScriptSocklet) socklet).getScriptFile();
			ScriptInfo scrinfo = getScriptInfomation(scriptExt);

			if (scrinfo != null && scriptFile != null && scriptFile.exists()) {
				info = getScriptSockletInformation(name);
				info.addInitParam("source", scriptFile.getAbsolutePath());
				info.addInitParam("sourceEncoding", scrinfo.getEncoding());
				info.setClassname(scrinfo.getJSClass().getName());
			}

			loader = this.scriptLoader;
		} else {
			info = getSockletInformation(name);
		}

		if (info == null) {
			getProgress().syslog(
				"Socket \"" + name + "\"'s infomation is not found.",
				Progress.ERROR);
			return false;
		}

		// Socklet̒~
		terminateSocklet(socklet, "Good by...");

		getProgress().syslog(
			"Socklet\""
				+ info.getName()
				+ "\"("
				+ info.getClassname()
				+ ")z܂B");
		try {
			socklet = deployNewSocklet(info, DEPLOY_BY_SYSTEM, loader);
			if (socklet instanceof ScriptSocklet) {
				((ScriptSocklet) socklet).setExtention(scriptExt);
				((ScriptSocklet) socklet).setScriptFile(scriptFile);
			}
		} catch (SockletDeployingException e) {
			getProgress().errlog("Socklet̔zɎs܂B", e);
			return false;
		}
		return true;
	}

	/* ***********************************************************************>> */;
	/**
	 * ݒt@CēǍ܂B
	 * @param sys ĂяoSystemCommandSocklet
	 * @return ēǍɐ^
	 * @see jp.wda.gpss.ExecutableBase#reloadCongif(SystemCommandSocklet)
	 */
	boolean reloadConfig(SystemCommandSocklet sys) {
		if (!checkSystemCommandSocklet(sys)) {
			return false;
		}

		System.out.println("Reload config...");
		try {
			loadConfig();
		} catch (ConfigurationError e) {
			getProgress().errlog("ݒt@C̍ēǍɎs܂B", e);
			return false;
		}

		reloadSystemCommandInfo();

		System.out.println("Reload config successfully!");
		return true;
	}
	/**
	 * obt@p̃R[_[擾
	 * @return T[o[̃R[_[
	 */
	public Charset getCharCoder() {
		return codec;
	}

}

/**
 * <FONT SIZE=2><I><B>
 * [ OProject GPSS for FlashMX ] FlashMXpėp\PbgT[o
 * </B></I></FONT><BR>
 *	NCAg\PbgC^[tF[X̎
 *
 *	@author	amoi
 */
final class SocketProcessorImplNio
	extends SocketProcessorBase
	implements Runnable {
	// RXgN^ ///////////////////////////////////////////////////////////////////
	//                                                                    Constructors //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 *	CT[oƃ\Pbgw肵ăIuWFNg\z܂B
	 *
	 * @param main CT[o
	 * @param socket \Pbg
	 */
	public SocketProcessorImplNio(
		MainNio server,
		SocketChannel channel,
		String encoding,
		int buffersize)
		throws IOException {
		super(
			server,
			encoding,
			buffersize,
			channel.socket().getInetAddress().getHostAddress());
		this.channel = channel;
		this.codec = server.getCharCoder();
	}

	// tB[h` ///////////////////////////////////////////////////////////////
	//                                                                          Fields //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * \Pbg`l
	 */
	private SocketChannel channel;

	/**
	 * byteBufferGR[_[
	 */
	private Charset codec;

	/**
	 * bZ[Wobt@
	 */
	private StringBuffer messageBuffer = new StringBuffer();


	// vpeB ///////////////////////////////////////////////////////////////////////
	//                                                                      Properties //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * T[o[ItO
	 */
	private boolean terminated = true;
	/**
	 * T[o[ItO
	 */
	public boolean isTerminated() {
		return terminated;
	}

	// CX^X\bh /////////////////////////////////////////////////////////////
	//                                                                Instance Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	void setMessage(String message, boolean execute) {
		messageBuffer.append(message);
		if (execute) {
			if (getApplication() != null) {
				onCommand(messageBuffer.toString());
			} else {
				onInitialize(messageBuffer.toString());
			}
			messageBuffer = new StringBuffer();
		}
	}

	/* ***********************************************************************>> */;
	/**
	 * \PbgR}hMAAvP[ṼC^v^ɗ܂B
	 *	@see java.lang.Runnable#run()
	 */
	public void run() {
		//܂EE
	}

	private void onInitialize(String mesage) {
		try {
			getProgress().log(
				"debuglogger",
				"connection:" + mesage + " [" + getClientID() + "]");
			doInitialCommand(mesage);

			// Sockletݒ肳ĂȂꍇ͒ɏIB
			if (getApplication() == null) {
				terminate();
				return;
			}

			// NCAg̐ڑsAʂʒm܂B
			// ʒmbZ[WMɎsꍇ͒ɏIB
			if (!getApplication().checkConnection(this)) {
				terminate();
				return;
			}

			this.terminated = false;

			// ^CAEgԂݒ  ʂ
			channel.socket().setSoTimeout(getApplication().getTimeout());
		} catch (SocketException ioe) {
			getProgress().errlog(ioe.getMessage() + ":" + getClientID());
			terminate();
		} catch (Throwable e) {
			getProgress().errlog("O܂B" + getClientID(), e);

		}
	}

	private void onCommand(String message) {
		try {
			if (!getApplication().doCommand(this, message)) {
				terminate();
			}
		} catch (Throwable e) {
			getProgress().errlog("O܂B" + getClientID(), e);

		}
	}


	/* ***********************************************************************>> */;
	/**
	 * NCAgɃbZ[W𑗂܂B<BR>
	 * bZ[Wnull"\0"I[Ƃ܂B<BR>
	 * ̃\bhł́AMp̕ʃXbhgp܂B<BR>
	 * NCAgɃbZ[WM̂҂܂B<BR>
	 *
	 * @param msg NCAgɑ郁bZ[W
	 * @return Mɐꍇ͐^Asꍇ͋U
	 */
	public boolean send(String message) {
		if (this.channel == null) {
			getProgress().errlog("C^r܂B" + getClientID());
			return false;
		}
		try {
			channel.write(codec.encode(message + "\0"));
		} catch (IOException e) {
			getProgress().errlog(
				"MɎs܂B" + getClientID() + "\n" + message,
				e);
			return false;
		}

		return true;
	}

	/* ***********************************************************************>> */;
	/**
	 * NCAg\PbgIɏI܂B
	 * @see jp.wda.gpss.SocketProcessor#terminate()
	 */
	public synchronized void terminate() {
		this.terminated = true;
		
		// fobOpóB
		getProgress().log("debuglogger", "disconnect [" + getClientID() + "]");
		
		try {
			// AvP[V炱̃NCAg폜
			if (getApplication() != null) {
				getApplication().preRemoveClient(this);
				getApplication().removeClient(this);
				notifyToSystemCommandSocklet();
			}
		} catch (Throwable e) {
			getProgress().errlog("IɗO܂B" + getClientID(), e);
			e.printStackTrace();
		}
		
		// \Pbg
		try {
			if (this.channel != null) {
				this.channel.close();
			}
		} catch (IOException e) {
			;
		}
		
		this.channel = null;
	}

	/**
	 * NCAgɏIbZ[WoANCAg\PbgI܂B
	 * @param message IbZ[W
	 * @see jp.wda.gpss.SocketProcessor#terminate(String)
	 */
	public synchronized void terminate(String message) {
		send(message);
		terminate();
	}

}
