package jp.wda.gpss.system;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Priority;

import jp.wda.gpss.*;
import jp.wda.gpss.Progress;
import jp.wda.gpss.Socklet;
import jp.wda.gpss.SocketProcessor;
import jp.wda.gpss.util.Finder;

/**
 * VXeR}hpSocklet
 *
 * @version	1.04		2003/11/27
 * @since		1.00002	2003/04/30
 * @author	amoi
 */
final class SystemCommandSocklet implements Socklet {
	// tB[h` ///////////////////////////////////////////////////////////////
	//                                                                          Fields //
	/////////////////////////////////////////////////////////////////////////////////////
	
	/* ***********************************************************************>> */;
	/**
	 * Sockletz
	 */
	private SockletDeployInfo info;
	/**
	 * Sockletzݒ肵܂B<BR>
	 * @param server \PbgҎ󂯃CT[o
	 * @param info Sockletz
	 */
	public final void setInfo(ExecutableBase server, SockletDeployInfo info){
		if(server == null){ return; }
		if(info != null){
			this.info = info;
		}
	}

	/* ***********************************************************************>> */;
	/**
	 *	CT[o<BR>
	 */
	private ExecutableBase server;
	/**
	 * CT[oݒ肵܂B<BR>
	 * @param server \PbgҎ󂯃CT[o
	 */
	public final void setMain(ExecutableBase server){
		if(server != null){
			this.server = server;
		}
	}

	/* ***********************************************************************>> */;
//	private boolean allow;
	private Progress progress;
	private static final String ALLOW_FLAG_SYSKEY = "gpss.system.SystemCommandSocklet.allowflag";
	
	/* ***********************************************************************>> */;
	/**
	 * ڑNCAgꗗ
	 */
	private ArrayList clients;
	
	// CX^X\bh /////////////////////////////////////////////////////////////
	//                                                                Instance Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * Socklet̔z擾܂B<BR>
	 * zƂ́AGPSSݒt@C<application>m[hɋLqꂽname̒lłB<BR>
	 * NCAǵÁhzh𗊂ɁASocklet܂B<BR>
	 * 
	 * @return Socklet
	 * @see jp.wda.gpss.Socklet#getName()
	 */
	public final String getName(){ return info.getName(); }

	/* ***********************************************************************>> */;
	/**
	 * ^CAEg(~bP)擾܂B<BR>
	 *
	 * @return ^CAEg(~bP)
	 * @see jp.wda.gpss.Socklet#getTimeout()
	 */
	public final int getTimeout(){ return info.getTimeout(); }
	/**
	 * ^CAEg(~bP)ݒ肵܂B<BR>
	 *
	 * @param timeout ݒ肷^CAEg(~bP)
	 * @see jp.wda.gpss.Socklet#setTimeout(int)
	 */
	public final void setTimeout(int timeout){ info.setTimeout(timeout); }

	/* ***********************************************************************>> */;
	public final List getInitParams(String key){
		return info.getInitParams(key);
	}
	
	// I[@[Ch /////////////////////////////////////////////////////////////////
	//                                                               Over Ride Methods //
	/////////////////////////////////////////////////////////////////////////////////////
	
	/* ***********************************************************************>> */;
	public final synchronized void addClient(SocketProcessor client){
		clients.add(client);
	}
	public final synchronized void removeClient(SocketProcessor client){
		clients.remove(client);
	}
	public final int countClients(){
		return clients.size();
	}
	public final void sendAllToClients(String message){
		Iterator i = new ArrayList(clients).iterator();
		while(i.hasNext()){
			SocketProcessor client = (SocketProcessor)i.next();
			if(!client.send(message)){ client.terminate(); continue; }
		}
	}
	public final synchronized void disconnectAllClients(String message){
		Iterator i = new ArrayList(clients).iterator();
		while(i.hasNext()){
			((SocketProcessor)i.next()).terminate();
		}
	}
	public void preRemoveClient(SocketProcessor client) { ; }
	public void afterDeployedLinks(Map linkedSocklets){ return; }
	public void destroy(){ ; }
	public String deployedBy(){ return Main.DEPLOY_BY_SYSTEM; }
	public void deployedBy(ExecutableBase server, String name){ return; }
	public void sendToAllClients(String message){ return; }
	public void sendToClients(String message, Finder finder){ return; }
	public void sendToClients(String message, String condition){ return; }
	
	/* ***********************************************************************>> */;
	/**
	 * Socklet̃ANZX邩ǂmF܂B<BR>
	 * Sockletł́AɃANZX܂B
	 * 
	 * @param from ANZX݂ĂASocklet
	 * @return ɋUԂ܂B
	 * @see jp.wda.gpss.Socklet#allowAccessFromOtherSocklet(Socklet)
	 */
	public final boolean allowAccessFromOtherSocklet(Socklet from){
		return false; 
	}

	/* ***********************************************************************>> */;
	/**
	 * Socklet܂B<BR>
	 * 
	 * @param info Sockletz
	 * @param links nullłB
	 * @param progress \Pbg󋵐iǗIuWFNgB
	 * @see jp.wda.gpss.Socklet#init(SockletDeployInfo, List, Progress)
	 */
	public final void init(SockletDeployInfo info, List links, Progress progress){
		clients = new ArrayList();
		this.info = info;
		this.progress = progress;
	}
	public void init(){ return; }

	/* ***********************************************************************>> */;
	public boolean checkConnection(SocketProcessor client) {
		boolean allow = false;
		Iterator it = getInitParams("allow").iterator();
		while(it.hasNext()){
			if(client.getIPAddress().equals(it.next())){
				allow = true;
				break;
			}
		}
		client.setAttribute(ALLOW_FLAG_SYSKEY, new Boolean(allow));  // add 2004.10.11
		client.send(allow ? "+OK" : "-Your connection is not allowed.");
		
		return allow;
	}
	
	private boolean getAllowFlag(SocketProcessor client){
		Boolean result = (Boolean)client.getAttribute(ALLOW_FLAG_SYSKEY);
		if(result == null){ return false; }
		
		return result.booleanValue();
	}

	/* ***********************************************************************>> */;
	public boolean doCommand(SocketProcessor client, String command) {
//		if(!allow){ return false; }
		if(!getAllowFlag(client)){ return false; } // mod 2004.10.11
		if(command == null){
			client.terminate("+God bye...");
			return false;
		}
		
		if(command.equals(RELOAD)){
			if(this.server.reloadConfig(this)){
				client.send("+Reload config successfully!");
			}else{
				client.send("-Reload config failure...");
			}
				
			return true;
		}
		
		int restartlen = RESTART.length();
		if(command.length() > restartlen + 2 && command.substring(0, restartlen).equals(RESTART)){
			String sockletname = command.substring(restartlen + 1);
			if(this.server.restartSocklet(this, sockletname)){
				client.send("+Restart socklet \"" + sockletname + "\" successfully!");
			}else{
				client.send("-Restart socklet \"" + sockletname + "\" failure...");
			}
			return true;
		}
		
		if(command.equals(GETLIST)){
			client.send(this.server.getSockletsList());
			return true;
		}
		
		if(command.equals(SHUTDOWN)){
			client.terminate();
			
			this.server.shutdown(this);
			return false;
		}
		
		if(command.equals(RESTART)){
			client.terminate();
			
			this.server.restart(this);
			return false;
		}
		
		client.send("-" + command + " is not found.");
		return true;
	}
	
	public void log(Object message, Priority priority, Throwable throwable){;}
	
	public static final String RESTART  = "restart";
	public static final String SHUTDOWN = "shutdown";
	public static final String RELOAD   = "reload";
	public static final String GETLIST  = "getSockletsList";
	
}
