/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.g2.system;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.ByteBuffer;
import jp.wda.g2.ConnectingConditions;
import jp.wda.g2.Connection;
import jp.wda.g2.SocketProcessor;
import jp.wda.g2.exception.GPSSException;
import jp.wda.g2.system.SockletContainer;
import jp.wda.g2.system.SockletLinkage;
import jp.wda.gpss.util.Logger;
import jp.wda.gpss.util.PseudoUUID;

public abstract class AbstractSocketProcessor
implements SocketProcessor {
    protected final Logger syslog = Logger.getLogger("jp.wda.g2.systemlog");
    private SockletLinkage linkage = null;
    private Connection connection = null;
    private String clientID;
    private String ipAddress = null;
    private String encoding = "UTF-8";
    private long timeout = 0L;
    private boolean terminated = false;
    private Object attributes = null;
    private ConnectingConditions connectingConditions = null;

    public AbstractSocketProcessor(Connection connection, SockletContainer container) throws GPSSException {
        this.connection = connection;
        if (connection != null) {
            this.ipAddress = connection.getSocketChannel().socket().getInetAddress().getHostAddress();
        }
        try {
            this.clientID = new PseudoUUID(this.ipAddress).toString();
        }
        catch (IOException ex) {
            throw new GPSSException();
        }
        this.linkage = new SockletLinkage(this, container);
        this.terminated = false;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getIPAddress() {
        return this.ipAddress;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String s) {
        this.encoding = s;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long s) {
        this.timeout = s;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public Object getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Object s) {
        this.attributes = s;
    }

    public ConnectingConditions getConnectingConditions() {
        return this.connectingConditions;
    }

    public void setConnectingConditions(ConnectingConditions s) {
        if (this.connectingConditions != null) {
            return;
        }
        this.connectingConditions = s;
    }

    public void doCommand(ByteBuffer command) {
        try {
            this.linkage.doCommand(command);
        }
        catch (GPSSException ex) {
            this.syslog.errormessage(ex);
            this.terminate();
        }
        catch (UndeclaredThrowableException ex) {
            Throwable th = ex.getUndeclaredThrowable();
            if (th instanceof InvocationTargetException && (th = ((InvocationTargetException)th).getTargetException()) instanceof GPSSException) {
                this.syslog.errormessage((GPSSException)th);
                this.terminate();
                return;
            }
            this.syslog.errormessage("EGSS50001", new Object[]{this.getClientID(), command}, ex);
        }
        catch (Throwable ex) {
            this.syslog.errormessage("EGSS50001", new Object[]{this.getClientID(), command}, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        AbstractSocketProcessor abstractSocketProcessor = this;
        synchronized (abstractSocketProcessor) {
            if (this.terminated) {
                return;
            }
            this.terminated = true;
        }
        this.linkage.removeClient(true);
        this.getConnection().closeConnection();
    }
}

