/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.g2.system;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import jp.wda.g2.SocketProcessor;
import jp.wda.g2.SockletDeployer;
import jp.wda.g2.exception.GPSSException;
import jp.wda.g2.security.AllowDomain;
import jp.wda.g2.system.AccessControledSocklet;
import jp.wda.g2.system.SockletLinkage;

public abstract class AbstractSockletDeployer
extends AccessControledSocklet
implements SockletDeployer {
    private int port = 9090;
    private List<AllowDomain> allowDomains = new ArrayList<AllowDomain>();

    public void setPort(int s) {
        this.port = s;
    }

    public void allowDomain(String domain) {
        if (domain == null || domain.length() == 0) {
            return;
        }
        int colon = domain.indexOf(58);
        String ports = null;
        if (colon >= 0) {
            ports = domain.substring(colon + 1);
            domain = domain.substring(0, colon);
        }
        if (domain.length() == 0) {
            domain = "*";
        }
        if (ports == null || ports.length() == 0) {
            ports = Integer.toString(this.port);
        }
        this.allowDomains.add(new AllowDomain(domain, ports));
    }

    public String getCrossDomainPolicy() {
        if (this.allowDomains.size() == 0) {
            this.allowDomains.add(new AllowDomain("*", Integer.toString(this.port)));
        }
        StringBuilder result = new StringBuilder("<cross-domain-policy>");
        int i = 0;
        while (i < this.allowDomains.size()) {
            result.append(this.allowDomains.get(i));
            ++i;
        }
        result.append("</cross-domain-policy>");
        return result.toString();
    }

    public boolean accept(SocketProcessor client, SockletLinkage linkage) {
        return true;
    }

    public boolean denied(SocketProcessor client, SockletLinkage linkage) {
        return false;
    }

    public void desert(SocketProcessor client, SockletLinkage linkage) {
    }

    public void destroy() {
    }

    public Object doCommand(SocketProcessor client, ByteBuffer command, SockletLinkage linkage) throws GPSSException {
        if (linkage.hasNext()) {
            return linkage.getNext().doCommand(command);
        }
        String com = Charset.forName(client.getEncoding()).decode(command).toString();
        if (com == null || com.length() == 0) {
            return null;
        }
        if (com.charAt(0) == '<') {
            client.terminate(this.getCrossDomainPolicy());
            return null;
        }
        return this.select(client, com, linkage);
    }

    public abstract Object select(SocketProcessor var1, String var2, SockletLinkage var3) throws GPSSException;
}

