/* *****************************************************************************
 * 
 * Copyright(C) The GPSS Project Team and the Others. All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 * 
 * ***************************************************************************** */
package jp.wda.g2.extention.socklet;

import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import jp.wda.g2.GeneralSocklet;
import jp.wda.g2.SockletRequest;
import jp.wda.g2.exception.CommandParseException;
import jp.wda.g2.exception.GPSSException;

/**
 * 
 * 
 * <div style="font-weight:bold; font-size:10.5pt;">
 * [ύX]
 * </div><dl style="margin:0px; border:1px solid #eee; padding:10px; font-size:10pt;">
 * 
 * <dt> 2.0.0-a1 </dt><dd> 2006/03/02 23:45:07  </dd>
 * 
 * </dl>
 * @version	2.0.0-a1
 * @since		2.0.0-a1
 * 
 * @author		A M O I
 */
public abstract class CommandSocklet extends GeneralSocklet implements ICommandSocklet {
	// RXgN^ ///////////////////////////////////////////////////////////////////
	//                                                                    Constructors //
	/////////////////////////////////////////////////////////////////////////////////////

	/**
	 * ftHg̐ݒpăIuWFNg\zRXgN^
	 * 
	 */
	public CommandSocklet() {
		super();
	}
	
	// vpeB ///////////////////////////////////////////////////////////////////////
	//                                                                      Properties //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */
	/** XXX */
	private boolean execIgnoreCase = true;
	/**
	 * R}h̑啶ʂ邩ǂ肵܂B
	 * ^Ԃꍇ́A啶ʂ܂B
	 * @return 啶ʂȂȂ^
	 */
	public boolean isExecIgnoreCase(){ return execIgnoreCase; }
	/**
	 * XXXݒ肵܂B<BR>
	 * @param s ݒl<BR>
	 */
	public void setExecIgnoreCase(boolean s){ execIgnoreCase = s; }
	
	// CX^X\bh /////////////////////////////////////////////////////////////
	//                                                                Instance Methods //
	/////////////////////////////////////////////////////////////////////////////////////
	
	/** {@inheritDoc} */
	public Object doCommand(SockletRequest req) throws GPSSException{
		CommandRequest request = new CommandRequestImpl(req);
		preProcess(request);
		
		request = parseCommand((CommandRequestImpl)request);
		if(request.getName() == null || request.getName().length() == 0){
			throw new CommandParseException(request.getCommand());
		}
		
		return doCommandMethod(request);
	}
	
	/**
	 * 
	 * @param request
	 * @return
	 * @throws GPSSException
	 */
	public Object doCommandMethod(CommandRequest request) throws GPSSException{
		String name = request.getName();
		if(execIgnoreCase){
			name = name.substring(0, 1).toUpperCase() + 
					(name.length() > 1 ? 
					 name.substring(1).toLowerCase() : "");
		}
		
		// \bh
		String methodname = request.toString();
		Method method = methodsCache.get(methodname);
		if(method == null){
			try{
				method = getClass().getMethod("cmd" + name, request.getType());
				methodsCache.put(methodname, method);
			}catch(NoSuchMethodException e){
				return cmdUndefined(request);
			}catch(SecurityException e){
				e.printStackTrace();
				return null;
			}
		}
		
		// R}h\bhs
		try{
			return method.invoke(this, request.getParams());
		}catch(Throwable e){
			syslog.fatalmessage(e);
			throw new CommandParseException(request.getCommand());
		}
	}
	
	private ConcurrentMap<String, Method> methodsCache = new ConcurrentHashMap<String, Method>();
	
	/**
	 * ĂR}h͂A\bhtNV邽߂̏쐬܂B<BR>
	 * ڑ̃NCAgAR}hMĂƂɌĂ΂܂B<BR>
	 * hNXł͂̃\bhI[o[ChAR}h̉ߕ@LqĂB<BR>
	 * 
	 * @param request MR}h
	 */
	protected abstract CommandRequest parseCommand(CommandRequestImpl request) throws GPSSException;
	
	/**
	 * R}htNV\bh`̏sȂ܂B
	 * 
	 * @param request
	 */
	public Object cmdUndefined(CommandRequest request) throws GPSSException{
		return request.handoverRequest();
	}
	
	/**
	 * R}hsOsȂ܂B<BR>
	 * ̃\bh̖߂ĺAR}htNV\bhɈn܂B<BR>
	 * SẴR}hɋʂ鏈Lqꍇ́Ã\bhI[o[ChĂB<BR>
	 * SockletExceptionO𓊂ƁAR}h̉߂𒆎~AdoCommandŒɋUԂ܂B
	 * 
	 * @param request MR}h
	 * @throws GPSSException R}hߏ𒆎~ꍇB
	 */
	public void preProcess(CommandRequest request) throws GPSSException{
	}

}
