/* *****************************************************************************
 * 
 * Copyright(C) The GPSS Project Team and the Others. All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 * 
 * ***************************************************************************** */
package jp.wda.g2;

import java.nio.ByteBuffer;

import jp.wda.g2.exception.GPSSException;
import jp.wda.g2.system.SockletLinkage;

/**
 * SockletC^[tF[X<BR>
 * <BR>
 * SĂSocklet́ÃC^[tF[XKv܂B<BR>
 * ʏ̏ꍇ́Ajp.wda.g2.GeneralSockletpy`łB<BR>
 *
 * 
 * <div style="font-weight:bold; font-size:10.5pt;">
 * [ύX]
 * </div><dl style="margin:0px; border:1px solid #eee; padding:10px; font-size:10pt;">
 * 
 * <dt> 2.0.0-a1 </dt><dd> 2006/02/25 14:40:03  </dd>
 * 
 * </dl>
 * @version	2.0.0-a1
 * @since		2.0.0-a1
 * 
 * @author		A M O I
 */
public interface Socklet {

	/**
	 * ڑpR}hMANCAǧs߂̃\bhB<BR>
	 * ̃\bh́AT[oVNCAg̐ڑmF_ŁA
	 * ̃NCAg邽߂ɌĂ΂܂B<BR>
	 * ڑNCAgɑ΂ԏ߂Ɉ񂾂Ă΂܂B<BR>
	 * SocketProcessorNX̃\bhgpāÃNXK؂ł邩A
	 * ܂NCAgɕKvȏ^ĂB<BR>
	 * <BR>
	 * ̃NCAgK؂łȂƔfꂽꍇ́AUfalseԂĂB
	 * ɃNCAg\PbgI܂B<BR>
	 * ̑̏ꍇ́A^ԂĂB^ԂƁANCAg\Pbgp܂B<BR>
	 * 
	 * @param client   ڑ݂ĂNCAg
	 * @param linkage 
	 * @return AIꍇ͋UB
	 */
	public boolean checkConnection(SocketProcessor client, SockletLinkage linkage);
	
	/**
	 * NCAg폜OɌĂяo郁\bhB<BR>
	 * ڑ̃NCAgؒfÃAvP[V珜O钼OɌĂ΂܂B<BR>
	 * ڑNCAgɑ΂AIOɈ񂾂Ă΂܂B<BR>
	 * ̐ڑNCAgցÃNCAgؒfꂽƂʒm悤ȏꍇ́A
	 * ̃\bhŋLqĂB<BR>
	 *
	 * @param client ꂩ폜NCAg
	 * @param linkage 
	 */
	public void preRemoveClient(SocketProcessor client, SockletLinkage linkage);
	
	/**
	 * R}h邽߂̃\bhB<BR>
	 * ڑ̃NCAgAR}hMĂƂɌĂ΂܂B
	 * TuNX͂̃b\hŁANCAg瑗ĂR}hĂB<BR>
	 * NCAg̐ڑɉxłĂ΂܂B<BR>
	 * <BR>
	 * R}h𑗂Ă\Pbgɑ΂āAbZ[W𑗐Mꍇ́Aȉ̃\bhgpĂB<BR>
	 * <BR>
	 * client.send(<I>M郁bZ[W</I>);<BR>
	 * <BR>
	 * ڑ̑SNCAgփbZ[W𑗐Mꍇ́Aȉ̃\bhgpĂB<BR>
	 * <BR>
	 * sendToAllClients(<I>M郁bZ[W</I>); <BR>
	 * <BR>
	 * ܂ÃNCAgւ̂݃bZ[W𑗂肽ꍇ́A
	 * SocketProcessorFinderhNXpĈȉ̃\bhgpĂB<BR>
	 * <BR>
	 * sendToClients(<I>M郁bZ[W</I>, <I>SocketProcessorFinder</I>);<BR>
	 * ܂́A<BR>
	 * sendToClients(<I>M郁bZ[W</I>, <I>MNCAǧ</I>);<BR>
	 * <BR>
	 * SocketProcessorFinderɂ́A[U[ł̌pNXp^lł̌pNXȂǂpӂĂ܂B<BR>
	 * 
	 * @param client R}h𑗐MĂNCAg\Pbg
	 * @param command MR}h
	 * @param linkage 
	 * @return R}h
	 * @throws GPSSException R}hGPSSException𓊂ƁAɃNCAg\PbgI܂B
	 */
	public Object doCommand(SocketProcessor client, ByteBuffer command, SockletLinkage linkage) throws GPSSException;
	
	/**
	 * SockletT[rX~ۂɁAҎ󂯃CT[oɂČĂяo܂B<BR>
	 * Socklet̏I[`LqÃ\bhĂB
	 */
	public void destroy();
	
	/**
	 * 
	 *
	 */
	public void destroyAllSocklets();

}
