/* *****************************************************************************
 * 
 * Copyright(C) The GPSS Project Team and the Others. All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 * 
 * ***************************************************************************** */
package jp.wda.g2.system;

import java.nio.ByteBuffer;

import jp.wda.g2.SocketProcessor;
import jp.wda.g2.Socklet;
import jp.wda.g2.exception.GPSSException;
import jp.wda.g2.exception.SockletNotFoundException;

/**
 * 
 * 
 * <div style="font-weight:bold; font-size:10.5pt;">
 * [ύX]
 * </div><dl style="margin:0px; border:1px solid #eee; padding:10px; font-size:10pt;">
 * 
 * <dt> 2.0.0-a1 </dt><dd> 2006/02/25 15:01:44  </dd>
 * 
 * </dl>
 * @version	2.0.0-a1
 * @since		2.0.0-a1
 * 
 * @author		A M O I
 */
public class SockletLinkage {
	// RXgN^ ///////////////////////////////////////////////////////////////////
	//                                                                    Constructors //
	/////////////////////////////////////////////////////////////////////////////////////

	/**
	 * ftHg̐ݒpăIuWFNg\zRXgN^
	 * 
	 */
	public SockletLinkage(SocketProcessor client, SockletContainer container) throws GPSSException {
		super();
		
		this.client = client;
		setContainer(container);
	}

	// tB[h` ///////////////////////////////////////////////////////////////
	//                                                                          Fields //
	/////////////////////////////////////////////////////////////////////////////////////

	/** XXX */
	private SocketProcessor client = null;

	// vpeB ///////////////////////////////////////////////////////////////////////
	//                                                                      Properties //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */
	/** XXX */
	private SockletContainer container = null;
	/**
	 * XXX擾܂B<BR>
	 * @return XXX
	 */
	public SockletContainer getContainer(){ return container; }
	/**
	 * XXXݒ肵܂B<BR>
	 * @param container ݒl<BR>
	 */
	private void setContainer(SockletContainer container) throws GPSSException{
		if(container == null || container.getSocklet() == null){ throw new SockletNotFoundException(""); }
		
		this.container = container;
		container.accept(client, this);
	}
	public Socklet getSocklet(){
		if(container == null){ return null; }
		return container.getSocklet();
	}

	/* ***********************************************************************>> */
	/** XXX */
	private SockletLinkage next = null;
	/**
	 * XXX擾܂B<BR>
	 * @return XXX
	 */
	public SockletLinkage getNext(){ return next; }
	/**
	 * XXXݒ肵܂B<BR>
	 * @param s ݒl<BR>
	 */
	private void setNext(SockletLinkage s){
		this.next = s;
	}
	
	/**
	 * XXXݒ肵܂B<BR>
	 * @param container ݒl<BR>
	 * @param removeChildren 
	 */
	public void setNextSocklet(SockletContainer container, boolean removeChildren) throws GPSSException{
		if(container.getMainReactor() == null){
			container.setMainReactor(this.container.getMainReactor());
		}
		SockletLinkage next = new SockletLinkage(client, container);
		
		SockletLinkage old = this.next;
		this.next = next;
		
		if(old == null){ return; }
		
		old.removeClient(removeChildren);
		if(old.hasNext() && !removeChildren){
			next.setNext(old.getNext());
		}
	}
	/**
	 * XXX擾܂B<BR>
	 * @return XXX
	 */
	public boolean hasNext(){ return next != null; }

	/* ***********************************************************************>> */
	/** XXX */
	private Object attributes = null;
	/**
	 * XXX擾܂B<BR>
	 * @return XXX
	 */
	public Object getAttributes(){ return attributes; }
	/**
	 * XXXݒ肵܂B<BR>
	 * @param s ݒl<BR>
	 */
	public void setAttributes(Object s){ attributes = s; }
	
	// CX^X\bh /////////////////////////////////////////////////////////////
	//                                                                Instance Methods //
	/////////////////////////////////////////////////////////////////////////////////////
	
	/**
	 * 
	 * @param command 
	 */
	public Object doCommand(ByteBuffer command) throws GPSSException{
		if(this.container == null){ return null; }
		
		return container.doCommand(client, command, this);
	}
	
	/**
	 * 
	 * @param removeChildren 
	 */
	void removeClient(boolean removeChildren){
		container.desert(client, this);
		
		if(removeChildren && hasNext()){ next.removeClient(removeChildren); }
	}

	// bZ[WM\bh ///////////////////////////////////////////////////////////
	//                                                    Methods for Sending messages //
	/////////////////////////////////////////////////////////////////////////////////////
	
	/**
	 * w肳ꂽNCAgꗗɌāAbZ[W𑗐M܂B<BR>
	 * 
	 * @param sender bZ[W𑗐MĂNCAg
	 * @param clients MNCAgꗗ
	 * @param message M郁bZ[W
	 */
	private void sendToClients(SocketProcessor[] clients, String message) {
		for(int i = 0; i < clients.length; i++){
			if (!clients[i].send(message)) {
				clients[i].terminate();
				continue;
			}
		}
	}

	/**
	 * ݂Sockletɐڑ̑SẴNCAgɌāAbZ[W𑗐M܂B<BR>
	 * ̃\bh́Aw肳ꂽStringɉH邱ƂȂM܂A
	 * Flash XMLSocket̋KɑA񖖔͕K\0ƂđM܂̂ŁA
	 * Socklet҂͓ɂӎKv͂܂B
	 * 
	 * @param message M郁bZ[W
	 */
	public final void sendToAllClients(String message) {
		sendToClients(container.getAllClients(), message);
	}

}
