package jp.wda.g2.util;

import java.io.StringReader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import jp.wda.g2.SocketProcessor;
import jp.wda.g2.exception.GPSSException;
import jp.wda.g2.exception.XMLAttributeException;
import jp.wda.g2.exception.XMLParseException;
import jp.wda.g2.system.GPSSConstants;
import jp.wda.gpss.util.Logger;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

/**
 * ɒPXML쐬pNX
 *
 * @version	1.00		2003/07/07
 * @since		1.00007	2003/06/08
 * @author	amoi
 */
public class SimpleXMLCreator {
	// RXgN^ ///////////////////////////////////////////////////////////////////
	//                                                                    Constructors //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * m[hw肵ăIuWFNg\zRXgN^
	 * @param name m[h
	 */
	public SimpleXMLCreator(String name) {
		super();
		setName(name);
		setText("");

		attr = new Hashtable<Object, Object>();
		children = new LinkedList<SimpleXMLCreator>();
	}

	// tB[h` ///////////////////////////////////////////////////////////////
	//                                                                          Fields //
	/////////////////////////////////////////////////////////////////////////////////////

	/**
	 * ŗLꗗ
	 */
	private Hashtable<Object, Object> attr;
	/**
	 * qm[hꗗ
	 */
	private LinkedList<SimpleXMLCreator> children;
	/**
	 * eLXgm[h
	 */
	private String text;

	// vpeB ///////////////////////////////////////////////////////////////////////
	//                                                                      Properties //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */
//	/**
//	 * Socklet
//	 */
//	private SockletLinkage linkage;
//	/**
//	 *	Socklet擾<BR>
//	 *	@return Socklet
//	 */
//	public SockletLinkage getSockletHolder() {
//		return linkage;
//	}
//	/**
//	 *	Sockletݒ肷<BR>
//	 *	@param s ݒl<BR>
//	 */
//	public void setSockletHolder(SockletLinkage s) {
//		linkage = s;
//	}

	/* ***********************************************************************>> */
	/**
	 *	m[h<BR>
	 */
	private String name = null;
	/**
	 *	m[h擾<BR>
	 *	@return m[h
	 */
	public String getName() {
		return name;
	}
	/**
	 *	m[hݒ肷<BR>
	 *	@param s ݒl<BR>
	 */
	public void setName(String s) {
		name = s;
	}

	// CX^X\bh /////////////////////////////////////////////////////////////
	//                                                                Instance Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * ̃IuWFNgɁAw肳ꂽǑŗLlݒ肵܂<BR>
	 * @param key ŗL<BR>
	 * @param value ŗLl<BR>
	 */
	public final void setAttribute(Object key, Object value) {
		attr.put(key, value);
	}
	/**
	 * ̃IuWFNgɐݒ肳ĂAw肳ꂽǑŗLl擾܂B<BR>
	 * @param key ŗL
	 * @return ŗLl
	 */
	public final Object getAttribute(Object key) {
		return attr.get(key);
	}
	/**
	 * ŗLɊi[ĂSĂ̑ꗗSetr[擾܂B<BR>
	 * @return ꗗSetr[<BR>
	 */
	public Set getAttributes() {
		return attr.entrySet();
	}
	/**
	 * w肳ꂽ̌ŗLݒ肳Ă邩mF܂B<BR>
	 * @param key ŗL<BR>
	 * @return w肳ꂽݒ肳Ăΐ^<BR>
	 */
	public boolean containsAttributeKey(Object key) {
		return attr.containsKey(key);
	}
	/**
	 * ŗLɊi[Ă鑮ꗗSetr[擾܂B<BR>
	 * @return ꗗSetr[<BR>
	 */
	public Set getAttributeKeys() {
		return attr.keySet();
	}
	/**
	 * w肳ꂽ̌ŗL폜܂B<BR>
	 * @param key ŗL<BR>
	 */
	public Object removeAttribute(Object key) {
		return attr.remove(key);
	}

	/**
	 * ̃IuWFNgɁAw肳ꂽǑŗLlݒ肵܂<BR>
	 * @param key ŗL<BR>
	 * @param value ŗLl<BR>
	 */
	public final void setAttribute(Object key, int value) {
		attr.put(key, new Integer(value));
	}
	/**
	 * ̃IuWFNgɐݒ肳ĂAw肳ꂽǑŗLl𐮐lƂĎ擾܂B<BR>
	 * @param key ŗL
	 * @return ŗLl
	 */
	public final int getAttributeInt(Object key) throws XMLAttributeException {
		Object ret = attr.get(key);
		if (ret instanceof Integer) {
			return ((Integer) ret).intValue();
		}
		throw new XMLAttributeException("w肳ꂽ(" + key + ")int^ł͂܂B");
	}
	/**
	 * ̃IuWFNgɁAw肳ꂽǑŗLl𒷐lƂĐݒ肵܂<BR>
	 * @param key ŗL<BR>
	 * @param value ŗLl<BR>
	 */
	public final void setAttribute(Object key, long value) {
		attr.put(key, new Long(value));
	}
	/**
	 * ̃IuWFNgɐݒ肳ĂAw肳ꂽǑŗLl𒷐lƂĎ擾܂B<BR>
	 * @param key ŗL
	 * @return ŗLl
	 */
	public final long getAttributeLong(Object key) throws XMLAttributeException {
		Object ret = attr.get(key);
		if (ret instanceof Long) {
			return ((Long) ret).longValue();
		}
		throw new XMLAttributeException("w肳ꂽ(" + key + ")long^ł͂܂B");
	}
	/**
	 * ̃IuWFNgɁAw肳ꂽǑŗLllƂĐݒ肵܂<BR>
	 * @param key ŗL<BR>
	 * @param value ŗLl<BR>
	 */
	public final void setAttribute(Object key, double value) {
		attr.put(key, new Double(value));
	}
	/**
	 * ̃IuWFNgɐݒ肳ĂAw肳ꂽǑŗLllƂĎ擾܂B<BR>
	 * @param key ŗL
	 * @return ŗLl
	 */
	public final double getAttributeDouble(Object key)
		throws XMLAttributeException {
		Object ret = attr.get(key);
		if (ret instanceof Double) {
			return ((Double) ret).doubleValue();
		}
		throw new XMLAttributeException("w肳ꂽ(" + key + ")double^ł͂܂B");
	}
	/**
	 * ̃IuWFNgɁAw肳ꂽǑŗLl^UlƂĐݒ肵܂<BR>
	 * @param key ŗL<BR>
	 * @param value ŗL^Ul<BR>
	 */
	public final void setAttribute(Object key, boolean value) {
		attr.put(key, new Boolean(value));
	}
	/**
	 * ̃IuWFNgɐݒ肳ĂAw肳ꂽǑŗLl^UlƂĎ擾܂B<BR>
	 * @param key ŗL
	 * @return ŗL^Ul
	 */
	public final boolean getAttributeBoolean(Object key)
		throws XMLAttributeException {
		Object ret = attr.get(key);
		if (ret instanceof Boolean) {
			return ((Boolean) ret).booleanValue();
		}
		throw new XMLAttributeException("w肳ꂽ(" + key + ")boolean^ł͂܂B");
	}

	/* ***********************************************************************>> */;
	/**
	 * ̃m[hɎqm[hǉ܂
	 * @param name qm[h
	 * @return ǉꂽqm[h
	 */
	public SimpleXMLCreator addChild(String name) {
		SimpleXMLCreator child = new SimpleXMLCreator(name);
		children.add(child);
		return child;
	}
	/**
	 * ̃m[hɎqm[hǉ܂
	 * @param child ǉqm[h
	 */
	public void addChild(SimpleXMLCreator child) {
		children.add(child);
	}
	/**
	 * w肳ꂽqm[h폜܂
	 * @param child 폜qm[h
	 */
	public void removeChild(SimpleXMLCreator child) {
		children.remove(child);
	}
	/**
	 * w肳ꂽO͂߂̎qm[h폜܂
	 * @param name 폜qm[h
	 */
	public void removeChild(String name) {
		Iterator it = children.iterator();
		while (it.hasNext()) {
			SimpleXMLCreator child = (SimpleXMLCreator) it.next();
			if (child.getName().equals(name)) {
				it.remove();
				return;
			}
		}
	}
	/**
	 * w肳ꂽOSĂ̎qm[h폜܂
	 * @param name 폜qm[h
	 */
	public void removeChildren(String name) {
		Iterator it = children.iterator();
		while (it.hasNext()) {
			SimpleXMLCreator child = (SimpleXMLCreator) it.next();
			if (child.getName().equals(name)) {
				it.remove();
			}
		}
	}
	/**
	 * SĂ̎qm[h폜܂
	 */
	public void removeChildren() {
		children = new LinkedList<SimpleXMLCreator>();
	}
	/**
	 * ̃m[hɐݒ肳ĂASĂ̎qm[h擾܂B
	 * @return qm[hꗗ
	 */
	public List<SimpleXMLCreator> getChildren() {
		return new LinkedList<SimpleXMLCreator>(children);
	}
	/**
	 * ̃m[hɐݒ肳ĂAw肵OׂĂ̎qm[h擾܂B
	 * @param name 擾qm[h
	 * @return qm[hꗗ
	 */
	public List getChildren(String name) {
		List<SimpleXMLCreator> list = new LinkedList<SimpleXMLCreator>();
		Iterator it = children.iterator();
		while (it.hasNext()) {
			SimpleXMLCreator child = (SimpleXMLCreator) it.next();
			if (child.getName().equals(name)) {
				list.add(child);
			}
		}
		return list;
	}
	/**
	 * ̃m[hɐݒ肳ĂAqm[h擾܂B
	 * @return qm[h
	 */
	public int sizeOfChildren() {
		return children.size();
	}
	/**
	 * ̃m[hɐݒ肳ĂAw肳ꂽԂ̎qm[h擾܂B
	 * @param idx ݒ菇ԍ ԏ߂ɐݒ肳ꂽm[h0łB
	 * @return qm[h
	 */
	public SimpleXMLCreator getChild(int idx) {
		if (idx >= children.size()) {
			return null;
		}
		return (SimpleXMLCreator) children.get(idx);
	}
	/**
	 * ̃m[hɐݒ肳ĂAw肳ꂽO͂߂̎qm[h擾܂
	 * @param name 폜qm[h
	 * @return qm[h
	 */
	public SimpleXMLCreator getChild(String name) {
		Iterator it = children.iterator();
		while (it.hasNext()) {
			SimpleXMLCreator child = (SimpleXMLCreator) it.next();
			if (child.getName().equals(name)) {
				return child;
			}
		}
		return null;
	}
	/**
	 * eLXgm[hݒ
	 * @param textNode eLXgm[h
	 */
	public void setText(String textNode) {
		text = textNode;
	}
	/**
	 * eLXgm[h擾
	 * @return eLXgm[h
	 */
	public String getText() {
		return text;
	}
//
//	/* ***********************************************************************>> */;
//	/**
//	 * RXgN^Ŏw肳ꂽSockletɏSNCAgɁA
//	 * ̃IuWFNgɐݒ肳ĂXML`̕𑗐M܂B
//	 */
//	public void send() {
//		if (linkage == null) {
//			return;
//		}
//		linkage.sendToAllClients(toString());
//	}
//	/**
//	 * RXgN^Ŏw肳ꂽSockletɏNCAg̓A
//	 * w肳ꂽ̃NCAgɂ̂
//	 * ̃IuWFNgɐݒ肳ĂXML`̕𑗐M܂B
//	 * @param finder MNCAgpIuWFNg
//	 */
//	public void send(Finder finder) {
//		if (socklet == null) {
//			return;
//		}
//		socklet.sendToClients(toString(), finder);
//	}
//	/**
//	 * RXgN^Ŏw肳ꂽSockletɏNCAg̓A
//	 * w肳ꂽ̃NCAgɂ̂
//	 * ̃IuWFNgɐݒ肳ĂXML`̕𑗐M܂B
//	 * @param condition MNCAǧ
//	 */
//	public void send(String condition) {
//		if (socklet == null) {
//			return;
//		}
//		socklet.sendToClients(toString(), condition);
//	}
	/**
	 * w肳ꂽNCAg
	 * ̃IuWFNgɐݒ肳ĂXML`̕𑗐M܂B
	 * @param client MNCAg
	 */
	public void send(SocketProcessor client) {
		if (client == null) {
			return;
		}
		client.send(toString());
	}

	/* ***********************************************************************>> */;
	/**
	 * ̃IuWFNgXML`ŕ\ꂽԂ܂B
	 * 
	 * @return ̃IuWFNgXML`ŕ\ꂽ
	 */
	public String toString() {
		StringBuffer ret = new StringBuffer("<");
		ret.append(name);

		Set attributes = getAttributes();
		Iterator it = attributes.iterator();
		while (it.hasNext()) {
			Map.Entry entry = (Map.Entry) it.next();

			Object value = entry.getValue();
			value = convertEntity(value);

			ret.append(' ');
			ret.append(entry.getKey());
			ret.append("=\"");
			ret.append(value);
			ret.append("\"");
		}
		if (children.size() == 0 && text == "") {
			ret.append(" />");
			return ret.toString();
		}

		ret.append('>');
		ret.append(convertEntity(text));
		for (int i = 0; i < children.size(); i++) {
			ret.append(children.get(i));
		}
		ret.append("</");
		ret.append(name);
		ret.append('>');

		return ret.toString();
	}
	/**
	 * XMLGeBeBQƂւ̕ϊ
	 * @param text ϊÕeLXg
	 * @return ϊ̃eLXg
	 */
	private Object convertEntity(Object text) {
		String str;
		StringBuffer buf;
		char c;

		if (text != null && text instanceof String) {
			str = (String) text;
			buf = new StringBuffer(str.length() + 20);
		} else {
			return text;
		}

		for (int i = 0; i < str.length(); i++) {
			c = str.charAt(i);
			switch (c) {
				case '<' :
					buf.append("&lt;");
					break;
				case '>' :
					buf.append("&gt;");
					break;
				case '\'' :
					buf.append("&apos;");
					break;
				case '\"' :
					buf.append("&quot;");
					break;
				case '&' :
					buf.append("&amp;");
					break;
				default :
					buf.append(c);
					break;
			}
		}
		return buf.toString();
	}

	// NX\bh ///////////////////////////////////////////////////////////////////
	//                                                                   Class Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/**
	 * w肳ꂽXML͂AVSimpleXMLCreatorIuWFNg\z܂B
	 * 
	 * @param xml ͂XML
	 * @return ͂ꂽSimpleXMLCreatorIuWFNg
	 */
	public static SimpleXMLCreator parse(String xml) throws GPSSException {
		Logger syslog = Logger.getLogger(GPSSConstants.SYSTEMLOG_CATEGORY);
		InputSource src = new InputSource(new StringReader(xml));
		Document doc = null;
		
		try{
			DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = dbfactory.newDocumentBuilder();
			doc = builder.parse(src);
		}catch(Throwable ex){
			syslog.error("command:" + xml);
			syslog.fatalmessage(ex);
			throw new XMLParseException(ex.getMessage());
		}
		
		if(doc == null){ throw new XMLParseException("doc is null."); }

		// XMLIuWFNg쐬
		Element root = doc.getDocumentElement();
		SimpleXMLCreator ret = new SimpleXMLCreator(root.getTagName());
		setXMLElements(ret, root);
		return ret;
	}

	private static void setXMLElements(SimpleXMLCreator xml, Element element) {
		NamedNodeMap attrs = element.getAttributes();

		for (int i = 0; i < attrs.getLength(); i++) {
			Node attr = attrs.item(i);
			xml.setAttribute(attr.getNodeName(), attr.getNodeValue());
		}

		NodeList children = element.getChildNodes();
		for (int i = 0; i < children.getLength(); i++) {
			Node node = children.item(i);
			if(node instanceof Text){
				xml.setText(((Text)node).getWholeText());
				continue;
			}
			if(!(node instanceof Element)){ continue; }
			
			Element child = (Element)node;
			SimpleXMLCreator childxml = xml.addChild(child.getTagName());
			setXMLElements(childxml, child);
		}
	}
	

	public static void main(String[] args) {
		SimpleXMLCreator node = new SimpleXMLCreator("node");
		node.setAttribute("attr", "<Test>=\"value\"");
		System.out.println(node);
		
		String xml = "<TagTest name=\"name dayo\" value=\"value dayo\"><test>aiueo</test><test></test></TagTest>";
		try{
			SimpleXMLCreator creator = SimpleXMLCreator.parse(xml);
			System.out.println(creator.getName());
		}catch(Throwable ex){
			ex.printStackTrace();
		}
	}
}

