/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.g2.system;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.wda.g2.Connection;
import jp.wda.g2.SocketProcessor;
import jp.wda.g2.SocketProcessorFactory;
import jp.wda.g2.SocketReactor;
import jp.wda.g2.Socklet;
import jp.wda.g2.SockletDeployer;
import jp.wda.g2.exception.GPSSException;
import jp.wda.g2.system.SockletContainer;
import jp.wda.gpss.util.Logger;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;

public abstract class AbstractSocketReactor
extends Thread
implements SocketReactor {
    protected final Logger syslog = Logger.getLogger("jp.wda.g2.systemlog");
    private SocketProcessorFactory socketProcessorFactory = null;
    private int port = 9090;
    private SockletDeployer defaultSocklet = null;
    private SockletContainer defaultSockletContainer = null;
    private Map<SockletContainer, List<SocketProcessor>> sockletClients = new HashMap<SockletContainer, List<SocketProcessor>>();

    public AbstractSocketReactor() {
        super("GPSS2 Main");
    }

    public AbstractSocketReactor(String threadName) {
        super(threadName);
    }

    public void setSocketProcessorFactory(SocketProcessorFactory s) {
        this.socketProcessorFactory = s;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int s) {
        this.port = s;
    }

    public SockletDeployer getDefaultSocklet() {
        return this.defaultSocklet;
    }

    public void setDefaultSocklet(SockletDeployer socklet) {
        this.defaultSocklet = socklet;
        this.defaultSocklet.setPort(this.port);
        this.defaultSocklet.addChild("SystemCmdSockletAdminOnly", this.getSystemCommandSocklet());
        this.defaultSockletContainer = new SockletContainer(null, this.defaultSocklet);
        this.defaultSockletContainer.setMainReactor(this);
    }

    public abstract Socklet getSystemCommandSocklet();

    public SockletContainer getDefaultSockletContainer() {
        return this.defaultSockletContainer;
    }

    public void run() {
        this.accept();
    }

    protected abstract void accept();

    public SocketProcessor accept(Connection connection) throws GPSSException {
        SocketProcessor client = this.socketProcessorFactory.createProcessor(connection, this.defaultSockletContainer);
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void notifyAcceptance(SockletContainer container, SocketProcessor client) {
        Map<SockletContainer, List<SocketProcessor>> map = this.sockletClients;
        synchronized (map) {
            List<SocketProcessor> clients = this.sockletClients.get(container);
            if (clients == null) {
                clients = Collections.synchronizedList(new ArrayList());
                this.sockletClients.put(container, clients);
            }
            clients.add(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDesertion(SockletContainer container, SocketProcessor client) {
        Map<SockletContainer, List<SocketProcessor>> map = this.sockletClients;
        synchronized (map) {
            List<SocketProcessor> clients = this.sockletClients.get(container);
            if (clients == null) {
                return;
            }
            clients.remove(client);
        }
    }

    public static final void startServer(String config) {
        S2Container container = S2ContainerFactory.create((String)config);
        System.out.println("hotswapMode:" + container.isHotswapMode());
        container.init();
    }
}

