/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.impl;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.impl.S2ContainerImpl;

public final class S2ContainerBehavior {
    private static Provider provider = new DefaultProvider();

    private S2ContainerBehavior() {
    }

    public static Provider getProvider() {
        return provider;
    }

    public static void setProvider(Provider p) {
        provider = p;
    }

    public static ComponentDef acquireFromGetComponent(S2Container container, Object key) {
        return S2ContainerBehavior.getProvider().acquireFromGetComponent(container, key);
    }

    public static ComponentDef acquireFromGetComponentDef(S2Container container, Object key) {
        return S2ContainerBehavior.getProvider().acquireFromGetComponentDef(container, key);
    }

    public static ComponentDef acquireFromHasComponentDef(S2Container container, Object key) {
        return S2ContainerBehavior.getProvider().acquireFromHasComponentDef(container, key);
    }

    public static ComponentDef acquireFromInjectDependency(S2Container container, Object key) {
        return S2ContainerBehavior.getProvider().acquireFromInjectDependency(container, key);
    }

    public static class DefaultProvider
    implements Provider {
        public ComponentDef acquireFromGetComponent(S2Container container, Object key) {
            return this.acquireFromGetComponentDef(container, key);
        }

        public ComponentDef acquireFromGetComponentDef(S2Container container, Object key) {
            ComponentDef cd = this.getComponentDef(container, key);
            if (cd == null) {
                throw new ComponentNotFoundRuntimeException(key);
            }
            return cd;
        }

        public ComponentDef acquireFromHasComponentDef(S2Container container, Object key) {
            return this.getComponentDef(container, key);
        }

        public ComponentDef acquireFromInjectDependency(S2Container container, Object key) {
            return this.acquireFromGetComponentDef(container, key);
        }

        protected ComponentDef getComponentDef(S2Container container, Object key) {
            return ((S2ContainerImpl)container).internalGetComponentDef(key);
        }
    }

    public static interface Provider {
        public ComponentDef acquireFromGetComponent(S2Container var1, Object var2);

        public ComponentDef acquireFromGetComponentDef(S2Container var1, Object var2);

        public ComponentDef acquireFromHasComponentDef(S2Container var1, Object var2);

        public ComponentDef acquireFromInjectDependency(S2Container var1, Object var2);
    }
}

