/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaAdapter;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class NativeJavaObject
implements Scriptable,
Wrapper,
Externalizable {
    static final int JSTYPE_UNDEFINED = 0;
    static final int JSTYPE_NULL = 1;
    static final int JSTYPE_BOOLEAN = 2;
    static final int JSTYPE_NUMBER = 3;
    static final int JSTYPE_STRING = 4;
    static final int JSTYPE_JAVA_CLASS = 5;
    static final int JSTYPE_JAVA_OBJECT = 6;
    static final int JSTYPE_JAVA_ARRAY = 7;
    static final int JSTYPE_OBJECT = 8;
    public static final byte CONVERSION_TRIVIAL = 1;
    public static final byte CONVERSION_NONTRIVIAL = 0;
    public static final byte CONVERSION_NONE = 99;
    protected Scriptable prototype;
    protected Scriptable parent;
    protected Object javaObject;
    protected Class staticType;
    protected JavaMembers members;
    private Hashtable fieldAndMethods;

    public NativeJavaObject() {
    }

    public NativeJavaObject(Scriptable scope, Object javaObject, Class staticType) {
        this.parent = scope;
        this.javaObject = javaObject;
        this.staticType = staticType;
        this.initMembers();
    }

    protected void initMembers() {
        Class<?> dynamicType = this.javaObject != null ? this.javaObject.getClass() : this.staticType;
        this.members = JavaMembers.lookupClass(this.parent, dynamicType, this.staticType);
        this.fieldAndMethods = this.members.getFieldAndMethodsObjects(this, this.javaObject, false);
    }

    public boolean has(String name, Scriptable start) {
        return this.members.has(name, false);
    }

    public boolean has(int index, Scriptable start) {
        return false;
    }

    public Object get(String name, Scriptable start) {
        Object result;
        if (this.fieldAndMethods != null && (result = this.fieldAndMethods.get(name)) != null) {
            return result;
        }
        return this.members.get(this, name, this.javaObject, false);
    }

    public Object get(int index, Scriptable start) {
        throw this.members.reportMemberNotFound(Integer.toString(index));
    }

    public void put(String name, Scriptable start, Object value) {
        if (this.prototype == null || this.members.has(name, false)) {
            this.members.put(this, name, this.javaObject, value, false);
        } else {
            this.prototype.put(name, this.prototype, value);
        }
    }

    public void put(int index, Scriptable start, Object value) {
        throw this.members.reportMemberNotFound(Integer.toString(index));
    }

    public boolean hasInstance(Scriptable value) {
        return false;
    }

    public void delete(String name) {
    }

    public void delete(int index) {
    }

    public Scriptable getPrototype() {
        if (this.prototype == null && this.javaObject instanceof String) {
            return ScriptableObject.getClassPrototype(this.parent, "String");
        }
        return this.prototype;
    }

    public void setPrototype(Scriptable m) {
        this.prototype = m;
    }

    public Scriptable getParentScope() {
        return this.parent;
    }

    public void setParentScope(Scriptable m) {
        this.parent = m;
    }

    public Object[] getIds() {
        return this.members.getIds(false);
    }

    public static Object wrap(Scriptable scope, Object obj, Class staticType) {
        Context cx = Context.getContext();
        return cx.getWrapFactory().wrap(cx, scope, obj, staticType);
    }

    public Object unwrap() {
        return this.javaObject;
    }

    public String getClassName() {
        return "JavaObject";
    }

    Function getConverter(String converterName) {
        Object converterFunction = this.get(converterName, (Scriptable)this);
        if (converterFunction instanceof Function) {
            return (Function)converterFunction;
        }
        return null;
    }

    Object callConverter(Function converterFunction) throws JavaScriptException {
        Function f = converterFunction;
        return f.call(Context.getContext(), f.getParentScope(), this, ScriptRuntime.emptyArgs);
    }

    Object callConverter(String converterName) throws JavaScriptException {
        Function converter = this.getConverter(converterName);
        if (converter == null) {
            return this.javaObject.toString();
        }
        return this.callConverter(converter);
    }

    public Object getDefaultValue(Class hint) {
        if (hint == null || hint == ScriptRuntime.StringClass) {
            return this.javaObject.toString();
        }
        try {
            if (hint == ScriptRuntime.BooleanClass) {
                return this.callConverter("booleanValue");
            }
            if (hint == ScriptRuntime.NumberClass) {
                return this.callConverter("doubleValue");
            }
        }
        catch (JavaScriptException javaScriptException) {
            // empty catch block
        }
        throw Context.reportRuntimeError0("msg.default.value");
    }

    public static boolean canConvert(Object fromObj, Class to) {
        int weight = NativeJavaObject.getConversionWeight(fromObj, to);
        return weight < 99;
    }

    public static int getConversionWeight(Object fromObj, Class to) {
        int fromCode = NativeJavaObject.getJSTypeCode(fromObj);
        int result = 99;
        switch (fromCode) {
            case 0: {
                if (to != ScriptRuntime.StringClass && to != ScriptRuntime.ObjectClass) break;
                result = 1;
                break;
            }
            case 1: {
                if (to.isPrimitive()) break;
                result = 1;
                break;
            }
            case 2: {
                if (to == Boolean.TYPE) {
                    result = 1;
                    break;
                }
                if (to == ScriptRuntime.BooleanClass) {
                    result = 2;
                    break;
                }
                if (to == ScriptRuntime.ObjectClass) {
                    result = 3;
                    break;
                }
                if (to != ScriptRuntime.StringClass) break;
                result = 4;
                break;
            }
            case 3: {
                if (to.isPrimitive()) {
                    if (to == Double.TYPE) {
                        result = 1;
                        break;
                    }
                    if (to == Boolean.TYPE) break;
                    result = 1 + NativeJavaObject.getSizeRank(to);
                    break;
                }
                if (to == ScriptRuntime.StringClass) {
                    result = 9;
                    break;
                }
                if (to == ScriptRuntime.ObjectClass) {
                    result = 10;
                    break;
                }
                if (!ScriptRuntime.NumberClass.isAssignableFrom(to)) break;
                result = 2;
                break;
            }
            case 4: {
                if (to == ScriptRuntime.StringClass) {
                    result = 1;
                    break;
                }
                if (to == ScriptRuntime.ObjectClass || to == ScriptRuntime.SerializableClass || to == ScriptRuntime.ComparableClass) {
                    result = 2;
                    break;
                }
                if (!to.isPrimitive() || to == Boolean.TYPE) break;
                if (to == Character.TYPE) {
                    result = 3;
                    break;
                }
                result = 4;
                break;
            }
            case 5: {
                if (to == ScriptRuntime.ClassClass) {
                    result = 1;
                    break;
                }
                if (to == ScriptRuntime.ObjectClass) {
                    result = 3;
                    break;
                }
                if (to != ScriptRuntime.StringClass) break;
                result = 4;
                break;
            }
            case 6: 
            case 7: {
                if (to == ScriptRuntime.StringClass) {
                    result = 2;
                    break;
                }
                if (to.isPrimitive() && to != Boolean.TYPE) {
                    result = fromCode == 7 ? 0 : 2 + NativeJavaObject.getSizeRank(to);
                    break;
                }
                Object javaObj = fromObj;
                if (javaObj instanceof Wrapper) {
                    javaObj = ((Wrapper)javaObj).unwrap();
                }
                if (!to.isInstance(javaObj)) break;
                result = 0;
                break;
            }
            case 8: {
                if (fromObj instanceof NativeArray && to.isArray()) {
                    result = 1;
                    break;
                }
                if (to == ScriptRuntime.ObjectClass) {
                    result = 2;
                    break;
                }
                if (to == ScriptRuntime.StringClass) {
                    result = 3;
                    break;
                }
                if (!to.isPrimitive() && to == Boolean.TYPE) break;
                result = 3 + NativeJavaObject.getSizeRank(to);
            }
        }
        return result;
    }

    static int getSizeRank(Class aType) {
        if (aType == Double.TYPE) {
            return 1;
        }
        if (aType == Float.TYPE) {
            return 2;
        }
        if (aType == Long.TYPE) {
            return 3;
        }
        if (aType == Integer.TYPE) {
            return 4;
        }
        if (aType == Short.TYPE) {
            return 5;
        }
        if (aType == Character.TYPE) {
            return 6;
        }
        if (aType == Byte.TYPE) {
            return 7;
        }
        if (aType == Boolean.TYPE) {
            return 99;
        }
        return 8;
    }

    static int getJSTypeCode(Object value) {
        if (value == null) {
            return 1;
        }
        if (value == Undefined.instance) {
            return 0;
        }
        if (value instanceof Scriptable) {
            if (value instanceof NativeJavaClass) {
                return 5;
            }
            if (value instanceof NativeJavaArray) {
                return 7;
            }
            if (value instanceof NativeJavaObject) {
                return 6;
            }
            return 8;
        }
        Class<?> valueClass = value.getClass();
        if (valueClass == ScriptRuntime.StringClass) {
            return 4;
        }
        if (valueClass == ScriptRuntime.BooleanClass) {
            return 2;
        }
        if (value instanceof Number) {
            return 3;
        }
        if (valueClass == ScriptRuntime.ClassClass) {
            return 5;
        }
        if (valueClass.isArray()) {
            return 7;
        }
        return 6;
    }

    public static Object coerceType(Class type, Object value) {
        return NativeJavaObject.coerceType(type, value, true);
    }

    static Object coerceType(Class type, Object value, boolean useErrorHandler) {
        if (value != null && value.getClass() == type) {
            return value;
        }
        switch (NativeJavaObject.getJSTypeCode(value)) {
            case 1: {
                if (type.isPrimitive()) {
                    NativeJavaObject.reportConversionError(value, type, !useErrorHandler);
                }
                return null;
            }
            case 0: {
                if (type == ScriptRuntime.StringClass || type == ScriptRuntime.ObjectClass) {
                    return "undefined";
                }
                NativeJavaObject.reportConversionError("undefined", type, !useErrorHandler);
                break;
            }
            case 2: {
                if (type == Boolean.TYPE || type == ScriptRuntime.BooleanClass || type == ScriptRuntime.ObjectClass) {
                    return value;
                }
                if (type == ScriptRuntime.StringClass) {
                    return value.toString();
                }
                NativeJavaObject.reportConversionError(value, type, !useErrorHandler);
                break;
            }
            case 3: {
                if (type == ScriptRuntime.StringClass) {
                    return ScriptRuntime.toString(value);
                }
                if (type == ScriptRuntime.ObjectClass) {
                    return NativeJavaObject.coerceToNumber(Double.TYPE, value, useErrorHandler);
                }
                if (type.isPrimitive() && type != Boolean.TYPE || ScriptRuntime.NumberClass.isAssignableFrom(type)) {
                    return NativeJavaObject.coerceToNumber(type, value, useErrorHandler);
                }
                NativeJavaObject.reportConversionError(value, type, !useErrorHandler);
                break;
            }
            case 4: {
                if (type == ScriptRuntime.StringClass || type == ScriptRuntime.ObjectClass || type == ScriptRuntime.SerializableClass || type == ScriptRuntime.ComparableClass) {
                    return value;
                }
                if (type == Character.TYPE || type == ScriptRuntime.CharacterClass) {
                    if (((String)value).length() == 1) {
                        return new Character(((String)value).charAt(0));
                    }
                    return NativeJavaObject.coerceToNumber(type, value, useErrorHandler);
                }
                if (type.isPrimitive() && type != Boolean.TYPE || ScriptRuntime.NumberClass.isAssignableFrom(type)) {
                    return NativeJavaObject.coerceToNumber(type, value, useErrorHandler);
                }
                NativeJavaObject.reportConversionError(value, type, !useErrorHandler);
                break;
            }
            case 5: {
                if (value instanceof Wrapper) {
                    value = ((Wrapper)value).unwrap();
                }
                if (type == ScriptRuntime.ClassClass || type == ScriptRuntime.ObjectClass) {
                    return value;
                }
                if (type == ScriptRuntime.StringClass) {
                    return value.toString();
                }
                NativeJavaObject.reportConversionError(value, type, !useErrorHandler);
                break;
            }
            case 6: 
            case 7: {
                if (type.isPrimitive()) {
                    if (type == Boolean.TYPE) {
                        NativeJavaObject.reportConversionError(value, type, !useErrorHandler);
                    }
                    return NativeJavaObject.coerceToNumber(type, value, useErrorHandler);
                }
                if (value instanceof Wrapper) {
                    value = ((Wrapper)value).unwrap();
                }
                if (type == ScriptRuntime.StringClass) {
                    return value.toString();
                }
                if (type.isInstance(value)) {
                    return value;
                }
                NativeJavaObject.reportConversionError(value, type, !useErrorHandler);
                break;
            }
            case 8: {
                if (type == ScriptRuntime.StringClass) {
                    return ScriptRuntime.toString(value);
                }
                if (type.isPrimitive()) {
                    if (type == Boolean.TYPE) {
                        NativeJavaObject.reportConversionError(value, type, !useErrorHandler);
                    }
                    return NativeJavaObject.coerceToNumber(type, value, useErrorHandler);
                }
                if (type.isInstance(value)) {
                    return value;
                }
                if (type.isArray() && value instanceof NativeArray) {
                    NativeArray array = (NativeArray)value;
                    long length = array.getLength();
                    Class<?> arrayType = type.getComponentType();
                    Object Result = Array.newInstance(arrayType, (int)length);
                    int i = 0;
                    while ((long)i < length) {
                        try {
                            Array.set(Result, i, NativeJavaObject.coerceType(arrayType, array.get(i, (Scriptable)array), useErrorHandler));
                        }
                        catch (EvaluatorException ee) {
                            NativeJavaObject.reportConversionError(value, type, !useErrorHandler);
                        }
                        ++i;
                    }
                    return Result;
                }
                if (value instanceof Wrapper) {
                    if (type.isInstance(value = ((Wrapper)value).unwrap())) {
                        return value;
                    }
                    NativeJavaObject.reportConversionError(value, type, !useErrorHandler);
                    break;
                }
                NativeJavaObject.reportConversionError(value, type, !useErrorHandler);
            }
        }
        return value;
    }

    static Object coerceToNumber(Class type, Object value, boolean useErrorHandler) {
        Class<?> valueClass = value.getClass();
        if (type == Character.TYPE || type == ScriptRuntime.CharacterClass) {
            if (valueClass == ScriptRuntime.CharacterClass) {
                return value;
            }
            return new Character((char)NativeJavaObject.toInteger(value, ScriptRuntime.CharacterClass, 0.0, 65535.0, useErrorHandler));
        }
        if (type == ScriptRuntime.ObjectClass || type == ScriptRuntime.DoubleClass || type == Double.TYPE) {
            return valueClass == ScriptRuntime.DoubleClass ? value : new Double(NativeJavaObject.toDouble(value, useErrorHandler));
        }
        if (type == ScriptRuntime.FloatClass || type == Float.TYPE) {
            if (valueClass == ScriptRuntime.FloatClass) {
                return value;
            }
            double number = NativeJavaObject.toDouble(value, useErrorHandler);
            if (Double.isInfinite(number) || Double.isNaN(number) || number == 0.0) {
                return new Float((float)number);
            }
            double absNumber = Math.abs(number);
            if (absNumber < (double)1.4E-45f) {
                return new Float(number > 0.0 ? 0.0 : -0.0);
            }
            if (absNumber > 3.4028234663852886E38) {
                return new Float(number > 0.0 ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY);
            }
            return new Float((float)number);
        }
        if (type == ScriptRuntime.IntegerClass || type == Integer.TYPE) {
            if (valueClass == ScriptRuntime.IntegerClass) {
                return value;
            }
            return new Integer((int)NativeJavaObject.toInteger(value, ScriptRuntime.IntegerClass, -2.147483648E9, 2.147483647E9, useErrorHandler));
        }
        if (type == ScriptRuntime.LongClass || type == Long.TYPE) {
            if (valueClass == ScriptRuntime.LongClass) {
                return value;
            }
            double max = Double.longBitsToDouble(4890909195324358655L);
            double min = Double.longBitsToDouble(-4332462841530417152L);
            return new Long(NativeJavaObject.toInteger(value, ScriptRuntime.LongClass, min, max, useErrorHandler));
        }
        if (type == ScriptRuntime.ShortClass || type == Short.TYPE) {
            if (valueClass == ScriptRuntime.ShortClass) {
                return value;
            }
            return new Short((short)NativeJavaObject.toInteger(value, ScriptRuntime.ShortClass, -32768.0, 32767.0, useErrorHandler));
        }
        if (type == ScriptRuntime.ByteClass || type == Byte.TYPE) {
            if (valueClass == ScriptRuntime.ByteClass) {
                return value;
            }
            return new Byte((byte)NativeJavaObject.toInteger(value, ScriptRuntime.ByteClass, -128.0, 127.0, useErrorHandler));
        }
        return new Double(NativeJavaObject.toDouble(value, useErrorHandler));
    }

    static double toDouble(Object value, boolean useErrorHandler) {
        Method meth;
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            return ScriptRuntime.toNumber((String)value);
        }
        if (value instanceof Scriptable) {
            if (value instanceof Wrapper) {
                return NativeJavaObject.toDouble(((Wrapper)value).unwrap(), useErrorHandler);
            }
            return ScriptRuntime.toNumber(value);
        }
        try {
            meth = value.getClass().getMethod("doubleValue", null);
        }
        catch (NoSuchMethodException e) {
            meth = null;
        }
        catch (SecurityException e) {
            meth = null;
        }
        if (meth != null) {
            try {
                return ((Number)meth.invoke(value, null)).doubleValue();
            }
            catch (IllegalAccessException e) {
                NativeJavaObject.reportConversionError(value, Double.TYPE, !useErrorHandler);
            }
            catch (InvocationTargetException e) {
                NativeJavaObject.reportConversionError(value, Double.TYPE, !useErrorHandler);
            }
        }
        return ScriptRuntime.toNumber(value.toString());
    }

    static long toInteger(Object value, Class type, double min, double max, boolean useErrorHandler) {
        double d = NativeJavaObject.toDouble(value, useErrorHandler);
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            NativeJavaObject.reportConversionError(ScriptRuntime.toString(value), type, !useErrorHandler);
        }
        if ((d = d > 0.0 ? Math.floor(d) : Math.ceil(d)) < min || d > max) {
            NativeJavaObject.reportConversionError(ScriptRuntime.toString(value), type, !useErrorHandler);
        }
        return (long)d;
    }

    static void reportConversionError(Object value, Class type, boolean throwIllegalArg) {
        if (throwIllegalArg) {
            throw new IllegalArgumentException("Cannot convert " + value + " to type " + type);
        }
        throw Context.reportRuntimeError2("msg.conversion.not.allowed", value.toString(), NativeJavaMethod.javaSignature(type));
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.prototype);
        out.writeObject(this.parent);
        if (this.javaObject != null) {
            Class<?> joClass = this.javaObject.getClass();
            if (joClass.getName().startsWith("adapter")) {
                out.writeBoolean(true);
                out.writeObject(joClass.getSuperclass().getName());
                Class<?>[] interfaces = joClass.getInterfaces();
                String[] interfaceNames = new String[interfaces.length];
                int i = 0;
                while (i < interfaces.length) {
                    interfaceNames[i] = interfaces[i].getName();
                    ++i;
                }
                out.writeObject(interfaceNames);
                try {
                    Object delegee = joClass.getField("delegee").get(this.javaObject);
                    Object self = joClass.getField("self").get(this.javaObject);
                    out.writeObject(delegee);
                    out.writeObject(self);
                }
                catch (IllegalAccessException e) {
                }
                catch (NoSuchFieldException e) {}
            } else {
                out.writeBoolean(false);
                out.writeObject(this.javaObject);
            }
        } else {
            out.writeBoolean(false);
            out.writeObject(this.javaObject);
        }
        if (this.staticType != null) {
            out.writeObject(this.staticType.getClass().getName());
        } else {
            out.writeObject(null);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.prototype = (Scriptable)in.readObject();
        this.parent = (Scriptable)in.readObject();
        if (in.readBoolean()) {
            Class<?> superclass = Class.forName((String)in.readObject());
            String[] interfaceNames = (String[])in.readObject();
            Class[] interfaces = new Class[interfaceNames.length];
            int i = 0;
            while (i < interfaceNames.length) {
                interfaces[i] = Class.forName(interfaceNames[i]);
                ++i;
            }
            this.javaObject = JavaAdapter.createAdapterClass(superclass, interfaces, (Scriptable)in.readObject(), (Scriptable)in.readObject());
        } else {
            this.javaObject = in.readObject();
        }
        String className = (String)in.readObject();
        this.staticType = className != null ? Class.forName(className) : null;
        this.initMembers();
    }
}

