package jp.wda.gpss.samples.games;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import jp.wda.gpss.GeneralSocklet;
import jp.wda.gpss.SocketProcessor;
import jp.wda.gpss.Socklet;

/**
 * <FONT SIZE=2><I><B>
 * [ OProject GPSS for FlashMX ] FlashMXpėp\PbgT[o SockletTv
 * </B></I></FONT><BR>
 * CQ[ǗpSocklet
 *
 * @author	amoi
 */
public class NavalBattleAreaAdministrator extends GeneralSocklet {
	
	private LinkedList areaList = new LinkedList();
	private Hashtable  areaInfo = new Hashtable();
	
	// I[@[Ch /////////////////////////////////////////////////////////////////
	//                                                               Over Ride Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * BasicChat Socklet邽߂̃\bhB<BR>
	 * \PbgҎ󂯃T[őNɁA1񂾂Ă΂܂B<BR><BR>
	 * 
	 * ̃\bhł́AǗpSockletN܂B<BR>
	 *
	 * @see jp.wda.gpss.GeneralSocklet#init(List)
	 */
	protected void init(List linkedSocklets) { 
		ChatroomInfo info = new ChatroomInfo("C");
		areaInfo.put("C", info);
		areaList.add(info);
		
		info = new ChatroomInfo("cC");
		areaInfo.put("cC", info);
		areaList.add(info);
	}
	
	public int addToRoom(String room){
		ChatroomInfo info = null;
		if(!areaInfo.containsKey(room)){
			info = new ChatroomInfo(room);
			areaInfo.put(room, info);
			areaList.add(info);
		}else{
			info = (ChatroomInfo)areaInfo.get(room);
		}
		
		sendToAllClients("<area name=\"" + room + "\" users=\"" + (++info.members) + "\" />");
		return info.members;
	}
	public int removeFromRoom(String room){
		if(!areaInfo.containsKey(room)){ return -1; }
		
		ChatroomInfo info = (ChatroomInfo)areaInfo.get(room);
		
		sendToAllClients("<area name=\"" + room + "\" users=\"" + (--info.members) + "\" />");
		return info.members;
	}
	private class ChatroomInfo{
		ChatroomInfo(String name){
			this.name = name;
			this.members = 0;
		}
		private String name;
		private int members;
	}

	/* ***********************************************************************>> */;
	/**
	 * ڑpR}hMANCAǧs߂Ƀ\bhB<BR>
	 * ̃\bh́AT[oVNCAg̐ڑmF_ŁA
	 * ̃NCAg邽߂ɌĂ΂܂B<BR><BR>
	 * 
	 * ̃\bh<BR>
	 * 
	 * @param client ڑ݂ĂNCAg
	 * @return Aؒfꍇ͋UB
	 * 
	 * @see jp.wda.gpss.Socklet#checkConnection(jp.wda.gpss.SocketProcessor)
	 */
	public boolean checkConnection(SocketProcessor client) {
		client.send("+OK welcome");
		return true;
	}

	/* ***********************************************************************>> */;
	/**
	 * NCAg폜OɌĂяo郁\bhB<BR>
	 * ڑ̃NCAgؒfÃAvP[V珜O钼OɌĂ΂܂B<BR><BR>
	 * 
	 * ̃\bh<BR>
	 *
	 * @param client ꂩ폜NCAg
	 * 
	 * @see jp.wda.gpss.Socklet#preRemoveClient(jp.wda.gpss.SocketProcessor)
	 */
	public void preRemoveClient(SocketProcessor client) {

	}

	/* ***********************************************************************>> */;
	/**
	 * R}h邽߂̃\bhB<BR>
	 * ڑ̃NCAgAR}hMĂƂɌĂ΂܂B<BR><BR>
	 * 
	 * ̃\bh<BR>
	 *
	 * @param client R}h𑗐MĂNCAg\Pbg
	 * @param command MR}h
	 * @return R}hsɐꍇ͐^Asꍇ͋U
	 * 	UԂƒɃNCAg\PbgI܂B
	 * 
	 * @see jp.wda.gpss.Socklet#doCommand(jp.wda.gpss.SocketProcessor, java.lang.String)
	 */
	public boolean doCommand(SocketProcessor client, String command) {
		Iterator it = areaList.iterator();
		while(it.hasNext()){
			ChatroomInfo area = (ChatroomInfo)it.next();
			client.send("<area name=\"" + area.name + "\" users=\"" + area.members + "\" />");
		}
		return true;
	}

	
	/* ***********************************************************************>> */;
	/**
	 * Socklet̃ANZX邩ǂmF܂B
	 * 
	 * @param from ANZX݂ĂASocklet
	 * @return Socklet̃ANZXꍇ͐^
	 */
	public boolean allowAccessFromOtherSocklet(Socklet from){
		if(!(from instanceof NavalBattle)){ return false; }
		return this.getName().equals(from.getName() + NavalBattle.ADMIN_FOTTER);
	}
}
