/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.gpss.system;

import java.io.File;

public class ScriptInfo {
    private String extention = null;
    private String encoding = null;
    private File dir = null;
    private Class jsclass = null;

    public String getExtention() {
        return this.extention;
    }

    private boolean setExtention(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        if (s.charAt(0) != '.') {
            s = "." + s;
        }
        this.extention = s;
        return true;
    }

    public String getEncoding() {
        return this.encoding;
    }

    private void setEncoding(String s) {
        if (s == null || s.length() == 0) {
            this.encoding = "UTF-8";
            return;
        }
        this.encoding = s;
    }

    public File getDirectory() {
        return this.dir;
    }

    private boolean setDirectory(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        this.dir = new File(s);
        return this.dir.exists() && this.dir.isDirectory();
    }

    public Class getJSClass() {
        return this.jsclass;
    }

    private boolean setJSClass(String s) {
        try {
            this.jsclass = Class.forName(s);
        }
        catch (Throwable e) {
            this.jsclass = null;
            return false;
        }
        return true;
    }

    public boolean setInfomation(String ext, String enc, String dir, String jsclass) {
        if (!this.setDirectory(dir)) {
            System.out.println("Directory [" + this.getDirectory().getAbsolutePath() + "] is not found...");
            return false;
        }
        if (!this.setJSClass(jsclass)) {
            this.setDirectory(null);
            System.out.println("Class [" + jsclass + "] is not found...");
            return false;
        }
        if (!this.setExtention(ext)) {
            this.setDirectory(null);
            this.setJSClass(null);
            System.out.println("Please be sure to set up an extension.");
            return false;
        }
        this.setEncoding(enc);
        return true;
    }
}

