/**
 * class "SockletService"
 * 
 * Usege : 
 *    IuWFNg̍쐬
 *         service = new SockletService("T[o", |[gԍ, "xml / plain", "xml / plain");
 *
 *             "T[o""auto"w肷ƁAIɂswft@CzuĂT[ow肵܂B
 *             |[gԍɂ́Alw肷邩A܂̓t@Cw肵A
 *                t@Cw肳Ăꍇ́AɋLqĂport=ϐ̒l|[gԍƂĐݒ肵܂B
 *                ) port=nnnňɂ͉sR[hȂłB
 *             3Ԗڂ̈́Af[^M@w肵܂B
 *                "xml"ƁAMf[^XMLƂ݂Ȃ܂B
 *             4Ԗڂ̈́Af[^M@w肵܂B
 *                "xml"ƁAsend(str)ɁAstrXMLp[XĂAT[oւƑM܂B
 *
 *    ڑ / ڑs̏\bhw
 *         service.connectionFailure = function(){ .... };      // ڑs̏
 *         service.connectionSuccessfully = function(){ .... }; // ڑ̏
 *
 *    ڑ[U[̎w
 *         service.username = [U[;
 *
 *    ڑpX[h̎w
 *         service.password = pX[h;
 *
 *    p[^̒ǉ
 *         service.addInitParam("p[^", "p[^l");
 *
 *    Socklet֐ڑ
 *         service.getSocklet("Socklet");
 *
 *    f[^M̏\bhw
 *         service.onReceive = function(){ .... };
 *             onDataonXML͎gpɁAonReceivegpĂB
 *
 * @version 1.04
 */
// RXgN^ ///////////////////////////////////////////////////////////////////
//                                                                    Constructors //
/////////////////////////////////////////////////////////////////////////////////////

/* zXgAhXƃ|[gԍw肵ăIuWFNg\z܂B
 * 
 * hostaddr zXgAhX "auto"w肷ƁAIɐݒ肳܂B
 * portnum  |[gԍ t@Cw肷ƁÃt@C擾AɋLqꂢportϐ̒lQƂ܂B
 * rsw      f[^M@
 * ssw      f[^M@
 */
function SockletService(hostaddr, portnum, rsw, ssw){
	// oϐ
	this._username = "";
	this._password = "";
	this._onDataDefaultFunc = this.onData;
	this._intervalCounter = 0;
	
	this.params = new Array();
	
	// ڑT[oݒ
	if(hostaddr == "auto"){
		var svrurl = _url;
		if (svrurl.substring(0, 4) != "file") {
			svrurl = svrurl.split("/")[2];
			svrurl = svrurl.split(":")[0];
		} else {
			svrurl = "localhost";
		}
		this.host = svrurl;
	}else{
		this.host = hostaddr;
	}
	
	// |[gԍݒ
	this.port = portnum;
	if(isNan(this.port)){
		this.portConf = new LoadVars();
		this.portConf.service = this;
		this.portConf.onLoad = function(bSuccess) {
  			if (bSuccess){ this.service.port = this.port; }
			else         { this.service.port = null; }
			
			this.service.portConf = null;
		}
		this.portConf.load(this.port);
	}
	
	this.setReceiveBy(rsw);
	this.setSendBy(ssw);
	
	this.addProperty("username",  this.getUsername,  this.setUsername);
	this.addProperty("password",  this.getPassword,  this.setPassword);
	this.addProperty("sendBy",    this.getSendBy,    this.setSendBy);
	this.addProperty("receiveBy", this.getReceiveBy, this.setReceiveBy);
}
SockletService.prototype = new XMLSocket();

// vpeB ///////////////////////////////////////////////////////////////////////
//                                                                      Properties //
/////////////////////////////////////////////////////////////////////////////////////

/*
 * [U[
 */
SockletService.prototype.setUsername = function(name){
	this._username = name;
}
SockletService.prototype.getUsername = function(){
	return (this._username);
}
/*
 * pX[h
 */
SockletService.prototype.setPassword = function(pass){
	this._password = pass;
}
SockletService.prototype.getPassword = function(){
	return (this._password);
}

/*
 * f[^M@
 */
SockletService.prototype.getSendBy = function(){ return (this._sendBy); }
SockletService.prototype.setSendBy = function(sw){
	this._sendBy = sw;
	if(sw == "xml"){
		this.send = this.sendWrapperByXML;
	}else{
		this.send = function(str){ super.send(str); }
	}
}

/*
 * f[^M@
 */
SockletService.prototype.getReceiveBy = function(){ return (this._receiveBy); }
SockletService.prototype.setReceiveBy = function(sw){
	this._receiveBy = sw;
	if(sw == "xml"){
		this.onData = this._onDataDefaultFunc;
		this.onXML  = this.onReceiveWrapper;
	}else{
		this.onData = this.onReceiveWrapper;
	}
}

// \bh /////////////////////////////////////////////////////////////////////////
//                                                                         Methods //
/////////////////////////////////////////////////////////////////////////////////////
/**
 * p[^ǉ܂B
 * key   p[^
 * value p[^l
 */
SockletService.prototype.addInitParam = function(key, value){
	this.params.push(key + "=" + value);
}

/**
 * ݐݒ肳ĂSĂ̏p[^폜܂B
 */
SockletService.prototype.removeAllInitParams = function(){
	this.params = new Array();
}

/**
 * SockletT[oɐڑ܂B
 * sockletname ڑSocklet̔z
 */
SockletService.prototype.getSocklet = function(sockletname){
	if(this._intervalCounter > 0){ clearInterval( this._intervalID ); }
	if(this.port == null){
		this.connectionFailure(16);
		return;
	}
	if(isNan(this.port)){
		if(this._intervalCounter < 60){
			trace("Waiting ...(" + ++this._intervalCounter + ")");
			this._intervalID = setInterval( this, "getSocklet", 500, sockletname);
			return;
		}else{
			this.connectionFailure(16);
			return;
		}
	}
	this._intervalCounter = 0;
	
	this.socklet = sockletname;
	this.onData = this.checkStatingMessage;
	this.connect(this.host, this.port);
	trace("connect to server [" + this.host + ":" + this.port + "/" + this.socklet + "]");
}

// \bh /////////////////////////////////////////////////////////////////////
//                                                                 Private Methods //
/////////////////////////////////////////////////////////////////////////////////////

SockletService.prototype.onConnect = function(bOK) {
	if(bOK){
		trace("connect seccessfuly!");
		var command = this.socklet + ":" + 
						this.username + ":" + 
						this.password + ":" + 
						this.params.join("&");
		super.send(command);
	}else{
		this.connectionFailure(0);
	}
}

SockletService.prototype.onClose = function(){
	trace (this.socklet + " is disconnected.");
}

SockletService.prototype.checkStatingMessage = function(command) {
	trace("Starting command : " + command);
	this.setReceiveBy(this._receiveBy);
	
	var ok = command.charAt(0);
	if(ok == "+"){
		this.connectionSuccessfully();
	}else{
		this.connectionFailure(1);
	}
}

SockletService.prototype.onReceiveWrapper = function(receive){
	this.onReceive(receive);
}

SockletService.prototype.sendWrapperByXML = function(str) {
	theXML = new XML();
	theXML.parseXML(str);
	super.send(theXML);
}

/**
 * \bh̃tNV
 */
SockletService.prototype.__resolve = function(methodName){
	trace("Resolve method \"" + methodName + "\"");
	trace("arguments \"" + arguments.length + "\"");
}
