/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESValue;
import FESI.Exceptions.EcmaScriptException;
import FESI.Interpreter.Evaluator;

class NumberPrototype
extends ESObject {
    protected ESNumber value = new ESNumber(0.0);

    NumberPrototype(ESObject eSObject, Evaluator evaluator) {
        super(eSObject, evaluator);
    }

    public String getESClassName() {
        return "Number";
    }

    public boolean isNumberValue() {
        return true;
    }

    public double doubleValue() {
        return this.value.doubleValue();
    }

    public boolean booleanValue() {
        return this.value.booleanValue();
    }

    public String toString() {
        return this.value.toString();
    }

    public ESValue toESNumber() throws EcmaScriptException {
        return this.value;
    }

    public Object toJavaObject() {
        return new Double(this.value.doubleValue());
    }

    public String toDetailString() {
        return "ES:[Object: builtin " + this.getClass().getName() + ":" + (this.value == null ? "null" : this.value.toString()) + "]";
    }
}

