/*
 * Decompiled with CFR 0.152.
 */
package FESI.Extensions;

import FESI.Data.ArrayPrototype;
import FESI.Data.BuiltinFunctionObject;
import FESI.Data.ESBoolean;
import FESI.Data.ESNull;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.GlobalObject;
import FESI.Data.ObjectPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Extensions.ESORORegExp;
import FESI.Extensions.Extension;
import FESI.Extensions.ORORegExp;
import FESI.Interpreter.Evaluator;
import com.oroinc.text.regex.MatchResult;
import com.oroinc.text.regex.PatternCompiler;
import com.oroinc.text.regex.PatternMatcher;
import com.oroinc.text.regex.PatternMatcherInput;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;

public class ORORegExp
extends Extension {
    private static final String INDEXstring = "index".intern();
    private static final int INDEXhash = INDEXstring.hashCode();
    private static final String INPUTstring = "input".intern();
    private static final int INPUThash = INPUTstring.hashCode();
    private Evaluator evaluator;
    private ESObject esRegExpPrototype;
    private PatternCompiler compiler;
    private PatternMatcher matcher;

    public void initializeExtension(Evaluator evaluator) throws EcmaScriptException {
        this.compiler = new Perl5Compiler();
        this.matcher = new Perl5Matcher();
        this.evaluator = evaluator;
        GlobalObject globalObject = evaluator.getGlobalObject();
        ObjectPrototype objectPrototype = (ObjectPrototype)evaluator.getObjectPrototype();
        FunctionPrototype functionPrototype = (FunctionPrototype)evaluator.getFunctionPrototype();
        this.esRegExpPrototype = new ESORORegExp(objectPrototype, evaluator, this.compiler, this.matcher);
        GlobalObjectRegExp globalObjectRegExp = new GlobalObjectRegExp("RegExp", evaluator, functionPrototype);
        globalObjectRegExp.putHiddenProperty("prototype", this.esRegExpPrototype);
        globalObjectRegExp.putHiddenProperty("length", new ESNumber(1.0));
        this.esRegExpPrototype.putHiddenProperty("constructor", globalObjectRegExp);
        this.esRegExpPrototype.putHiddenProperty("test", new ESRegExpPrototypeTest("test", evaluator, functionPrototype));
        this.esRegExpPrototype.putHiddenProperty("exec", new ESRegExpPrototypeExec("exec", evaluator, functionPrototype));
        globalObject.putHiddenProperty("RegExp", globalObjectRegExp);
        ESObject eSObject = evaluator.getStringPrototype();
        eSObject.putHiddenProperty("search", new 1.StringPrototypeSearch(this, "search", evaluator, functionPrototype));
        eSObject.putHiddenProperty("replace", new 1.StringPrototypeReplace(this, "replace", evaluator, functionPrototype));
        eSObject.putHiddenProperty("match", new 1.StringPrototypeMatch(this, "match", evaluator, functionPrototype));
        eSObject.putHiddenProperty("split", new 1.StringPrototypeSplit(this, "split", evaluator, functionPrototype));
    }

    class ESRegExpPrototypeTest
    extends BuiltinFunctionObject {
        ESRegExpPrototypeTest(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            ORORegExp.this = ORORegExp.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            if (eSValueArray.length < 1) {
                throw new EcmaScriptException("test requires 1 string argument");
            }
            ESORORegExp eSORORegExp = (ESORORegExp)eSObject;
            String string = eSValueArray[0].toString();
            PatternMatcherInput patternMatcherInput = new PatternMatcherInput(string);
            return ESBoolean.makeBoolean(ORORegExp.this.matcher.contains(patternMatcherInput, eSORORegExp.getPattern()));
        }
    }

    class ESRegExpPrototypeExec
    extends BuiltinFunctionObject {
        ESRegExpPrototypeExec(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            ORORegExp.this = ORORegExp.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            if (eSValueArray.length < 1) {
                throw new EcmaScriptException("exec requires 1 string argument");
            }
            ESORORegExp eSORORegExp = (ESORORegExp)eSObject;
            String string = eSValueArray[0].toString();
            PatternMatcherInput patternMatcherInput = new PatternMatcherInput(string);
            if (ORORegExp.this.matcher.contains(patternMatcherInput, eSORORegExp.getPattern())) {
                MatchResult matchResult = ORORegExp.this.matcher.getMatch();
                int n = matchResult.groups();
                ESObject eSObject2 = this.evaluator.getArrayPrototype();
                ArrayPrototype arrayPrototype = new ArrayPrototype(eSObject2, this.evaluator);
                arrayPrototype.setSize(n);
                arrayPrototype.putProperty(INDEXstring, new ESNumber(matchResult.beginOffset(0)), INDEXhash);
                arrayPrototype.putProperty(INPUTstring, new ESString(string), INPUThash);
                int n2 = 0;
                while (n2 < n) {
                    int n3 = matchResult.beginOffset(n2);
                    int n4 = matchResult.endOffset(n2);
                    if (n3 < 0 || n4 < 0) {
                        arrayPrototype.setElementAt(new ESString(""), n2);
                    } else {
                        arrayPrototype.setElementAt(new ESString(string.substring(n3, n4)), n2);
                    }
                    ++n2;
                }
                return arrayPrototype;
            }
            return ESNull.theNull;
        }
    }

    class GlobalObjectRegExp
    extends BuiltinFunctionObject {
        GlobalObjectRegExp(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            ORORegExp.this = ORORegExp.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            return this.doConstruct(eSObject, eSValueArray);
        }

        public ESObject doConstruct(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESORORegExp eSORORegExp = null;
            if (eSValueArray.length == 0) {
                throw new EcmaScriptException("RegExp requires 1 or 2 arguments");
            }
            if (eSValueArray.length == 1) {
                eSORORegExp = new ESORORegExp(ORORegExp.this.esRegExpPrototype, this.evaluator, ORORegExp.this.compiler, ORORegExp.this.matcher, eSValueArray[0].toString());
            }
            return eSORORegExp;
        }
    }
}

