package jp.wda.gpss.samples.games;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

import jp.wda.gpss.ColonCommandSocklet;
import jp.wda.gpss.SocketProcessor;
import jp.wda.gpss.SockletDeployInfo;
import jp.wda.gpss.SockletException;
import jp.wda.gpss.util.Finder;
import jp.wda.gpss.util.SimpleXMLCreator;

/**
 * CQ[Socklet
 *
 * @version	1.00008	2003/06/14
 * @since		1.00007	2003/06/08
 * @author	amoi
 */
public class NavalBattle extends ColonCommandSocklet {
	// JtB[h ///////////////////////////////////////////////////////////////////
	//                                                            Public Static Fields //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	public static final String ADMIN_FOTTER = "_Admin";
	
	public static final int STAGE_WIDTH  = 40;
	public static final int STAGE_HEIGHT = 20;
	
	public String adminSockletName = null;
	
	public static final int STATUS_MESSAGE = 1;
	public static final int STATUS_HIT     = 8;
	public static final int STATUS_WOUNDED = 16;
	public static final int STATUS_IGNORE  = 32;
	
	// tB[h` ///////////////////////////////////////////////////////////////
	//                                                                          Fields //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	
	private NavalBattleAreaAdministrator adminSocklet;
	private Hashtable areamap;
	
	// I[@[Ch /////////////////////////////////////////////////////////////////
	//                                                               Over Ride Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * BasicChat Socklet邽߂̃\bhB<BR>
	 * \PbgҎ󂯃T[őNɁA1񂾂Ă΂܂B<BR><BR>
	 * 
	 * ̃\bhł́AǗpSockletN܂B<BR>
	 *
	 * @see jp.wda.gpss.GeneralSocklet#init(List)
	 */
	protected void init(List linkedSocklets) {
		areamap = new Hashtable();
		this.adminSockletName = this.getName() + ADMIN_FOTTER;
		
		SockletDeployInfo appinfo = 
			this.copyInfo(adminSockletName, "jp.wda.gpss.samples.games.NavalBattleAreaAdministrator");
		
		// Rg[̃̕^CAEgԂ͖
		appinfo.setTimeout(0);
		
		linkedSocklets.add(appinfo);
	}
	
	/**
	 * ǉzꂽ(͂)ǗpSocklet\ߎ擾Ă܂B
	 */
	public void afterDeployedLinks(Map linkedSocklets){
		this.adminSocklet = (NavalBattleAreaAdministrator)linkedSocklets.get(adminSockletName);
	}

	/* ***********************************************************************>> */;
	/**
	 * ڑpR}hMANCAǧs߂Ƀ\bhB<BR>
	 * ̃\bh́AT[oVNCAg̐ڑmF_ŁA
	 * ̃NCAg邽߂ɌĂ΂܂B<BR><BR>
	 * 
	 * ̃\bh<BR>
	 * 
	 * @param client ڑ݂ĂNCAg
	 * @return Aؒfꍇ͋UB
	 * 
	 * @see jp.wda.gpss.Socklet#checkConnection(jp.wda.gpss.SocketProcessor)
	 */
	public boolean checkConnection(SocketProcessor client) {
		// OC̃[UmF
		Boolean loginFailure = new Boolean(false);
		client.setAttribute("loginFailure", Boolean.FALSE);
		
		String area = client.getInitParam("AREA");
		if(area == null || area.length() == 0){
			client.send("-Login failure user \"" + client.getUserName() + "\"");
			client.setAttribute("loginFailure", Boolean.TRUE);
			chatlog(area, client.getUserName(), "QC悪w肳Ă܂B");
			return false;
		}
		
		List cls = getClients("username==\"" + client.getUserName() + "\"&a.AREA==\"" + area + "\"");
		if(cls.size() > 0){
			client.send("-Login failure user \"" + client.getUserName() + "\"");
			client.setAttribute("loginFailure", Boolean.TRUE);
			chatlog(area, client.getUserName(), "dOC͂ł܂B");
			return false;
		}
		
		// GA}bvݒ
		ArrayList[][] map;
		if(!areamap.containsKey(area)){
			map = new ArrayList[STAGE_WIDTH][STAGE_HEIGHT];
			for(int i = 0; i < STAGE_WIDTH; i++){
				for(int j = 0; j < STAGE_HEIGHT; j++){
					map[i][j] = new ArrayList();
				}
			}
			areamap.put(area, map);
		}else{
			map = (ArrayList[][])areamap.get(area);
		}
		int newx = (int)((Math.random() * 1000) % STAGE_WIDTH);
		int newy = (int)((Math.random() * 1000) % STAGE_HEIGHT);
		client.setAttribute("POSITION", new Position(newx, newy));
		map[newx][newy].add(client);
		
		// ȊOpFinder
		Finder withoutMe = preCreateFinder("a.AREA==\"" + area + "\"" + "&username!=\"" + client.getUserName() + "\"");
		client.setAttribute("FinderWithoutMe", withoutMe);
		
		client.setAttribute("AREA", area);
		setPoint(client, 100);
		enemyNotify2All(client, client.getUserName() + "Q킵܂B");
		
		client.send("+OK welcome user \"" + client.getUserName() + "\"");
		
		if(adminSocklet != null){
			int members = adminSocklet.addToRoom(area);
			if(members == 1){
				chatlog(area, client.getUserName(), "<<J킵܂>>");
			}else{
				chatlog(area, client.getUserName(), "<<Q킵܂>>");
			}
		}
		return true;
	}

	/* ***********************************************************************>> */;
	/**
	 * NCAg폜OɌĂяo郁\bhB<BR>
	 * ڑ̃NCAgؒfÃAvP[V珜O钼OɌĂ΂܂B<BR><BR>
	 * 
	 * ̃\bh<BR>
	 *
	 * @param client ꂩ폜NCAg
	 * 
	 * @see jp.wda.gpss.Socklet#preRemoveClient(jp.wda.gpss.SocketProcessor)
	 */
	public void preRemoveClient(SocketProcessor client) {
		if(((Boolean)client.getAttribute("loginFailure")).booleanValue()){ return; }
		String area = (String)client.getAttribute("AREA");
		
		Position pos = (Position)client.getAttribute("POSITION");
		ArrayList[][] map = (ArrayList[][])areamap.get(area);
		if(map.length > pos.x && map[pos.x].length > pos.y){
			map[pos.x][pos.y].remove(client);
		}
		
		setPoint(client, -1);
		enemyNotify2All(client, client.getUserName() + "ދp܂B");
		
		if(adminSocklet != null && area != null){
			int members = adminSocklet.removeFromRoom(area);
			if(members == 0){
				chatlog(area, client.getUserName(), "<<킵܂>>");
			}else{
				chatlog(area, client.getUserName(), "<<ދp܂>>");
			}
		}
	}
	
	/* ***********************************************************************>> */;
	/**
	 * R}htNV\bh`̏sȂ܂B
	 * 
	 * @param client R}h𑗐MĂNCAg\Pbg
	 * @param command `̎sR}h
	 * @param params R}hl
	 * @return R}hsɐꍇ͐^Asꍇ͋U
	 * 	UԂƒɃNCAg\PbgI܂B
	 * @see jp.wda.gpss.ColonCommandSocklet#cmdUndefined(SocketProcessor, String, Object[])
	 */
	public boolean cmdUndefined(SocketProcessor client, String command, Object[] params){
		log("receive " + command + " command. method not found. " + client.getUserName());
		return true;
	}
	
	/**
	 * R}hsOʏsȂ܂B<BR>
	 * 
	 * @param client R}h𑗐MĂNCAg\Pbg
	 * @param command MR}h
	 * @return OʃIuWFNg
	 * @throws SockletException R}hߏ𒆎~ꍇB
	 * @see jp.wda.gpss.ColonCommandSocklet#preProcess(SocketProcessor, String)
	 */
	public Object preProcess(SocketProcessor client, String command) throws SockletException{
		if(((Boolean)client.getAttribute("loginFailure")).booleanValue()){
			throw new SockletException("OCɎsĂ܂B");
		}
		try{
			return new Position(command);
		}catch(PositionParseException e){ return null; }
	}

	// R}htNV\bh /////////////////////////////////////////////
	//                                                      Command Reflection Methods //
	/////////////////////////////////////////////////////////////////////////////////////
	
	/* ***********************************************************************>> */;
	/**
	 * init:R}h\bh
	 * 
	 * @param client R}h𑗐MĂNCAg\Pbg
	 * @param value R}hl
	 * @param preprocessed preProcessnꂽOʃIuWFNg
	 * @return ɐ^
	 */
	public boolean cmdInit(SocketProcessor client, String value, Object preprocessed) {
		String area  = (String)client.getAttribute("AREA");
		Position pos = (Position)client.getAttribute("POSITION");

		SimpleXMLCreator xml = new SimpleXMLCreator("INIT", this);
		xml.setAttribute("point", getPoint(client));
		xml.setAttribute("area", area);
		xml.setAttribute("name", client.getUserName());
		xml.setAttribute("x", pos.x);
		xml.setAttribute("y", pos.y);
		xml.send(client);
		
		xml = new SimpleXMLCreator("ENEMY", this);
		List cls = getClients((Finder)client.getAttribute("FinderWithoutMe"));
		for(int i = 0; i < cls.size(); i++){
			SocketProcessor enemy = (SocketProcessor)cls.get(i);
			int point = getPoint(enemy);
			xml.setAttribute("point", getPoint(enemy));
			xml.setAttribute("name", enemy.getUserName());
			xml.send(client);
		}
		
		chatlog(area, client.getUserName(), "Initialize");
		return true;
	}
	
	/* ***********************************************************************>> */;
	/**
	 * move:R}h\bh
	 * 
	 * @param client R}h𑗐MĂNCAg\Pbg
	 * @param value R}hl
	 * @param preprocessed preProcessnꂽOʃIuWFNg
	 * @return ɐ^
	 */
	public boolean cmdMove(SocketProcessor client, String value, Object preprocessed) {
		if(preprocessed == null){ return true; }
		Position newpos = (Position)preprocessed;
		String area = (String)client.getAttribute("AREA");
		ArrayList[][] map = getMap(area, newpos);
		if(map == null){ return true; }
		
		Position oldpos = (Position)client.getAttribute("POSITION");
		client.setAttribute("POSITION", newpos);
		map[oldpos.x][oldpos.y].remove(client);
		map[newpos.x][newpos.y].add(client);
		
		SimpleXMLCreator xml = new SimpleXMLCreator("MOVE", this);
		xml.setAttribute("x", newpos.x);
		xml.setAttribute("y", newpos.y);
		xml.send(client);
		
		return true;
	}
	
	
	/* ***********************************************************************>> */;
	/**
	 * fire:R}h\bh
	 * 
	 * @param client R}h𑗐MĂNCAg\Pbg
	 * @param value R}hl
	 * @param preprocessed preProcessnꂽOʃIuWFNg
	 * @return ɐ^
	 */
	public boolean cmdFire(SocketProcessor client, String value, Object preprocessed) {
		if(preprocessed == null){ return true; }
		Position pos = (Position)preprocessed;
		String area = (String)client.getAttribute("AREA");
		ArrayList[][] map = getMap(area, pos);
		if(map == null){ return true; }
		
		Position cpos = (Position)client.getAttribute("POSITION");
		int xdis = Math.abs(cpos.x - pos.x);
		int ydis = Math.abs(cpos.y - pos.y);
		double distance = Math.sqrt(xdis * xdis + ydis * ydis);
		int pow = (int)Math.round(20.0 - (distance / Math.sqrt(5)));
		double dir = ((pos.x - cpos.x) < 0 ? 1 : -1) * 180 * Math.acos((pos.y - cpos.y) / distance) / Math.PI;
		
		addPoint(client, -1);
		SimpleXMLCreator xml = new SimpleXMLCreator("FIRED", this);
		xml.setAttribute("x", pos.x);
		xml.setAttribute("y", pos.y);
		xml.setAttribute("dir", dir);
		xml.send((Finder)client.getAttribute("FinderWithoutMe"));
		
		synchronized(map){
			// emF
			int bonus = 0, hit = 0;
			for(int i = 0; i < map[pos.x][pos.y].size(); i++){
				SocketProcessor enemy = (SocketProcessor)map[pos.x][pos.y].get(i);
				
				// ŏIě
				if(enemy.containsAttributeKey("LastWounded")){
					try{
						long lastWounded = enemy.getAttributeLong("LastWounded");
						if(System.currentTimeMillis() - lastWounded < 1000){ continue; }
					}catch(Exception e){ ; }
					
					enemy.removeAttribute("LastWounded");
				}
				
				hit++;
				bonus += (20 - pow) / 2 + 1;
				addPoint(enemy, -pow);
				
				int now = getPoint(enemy);
				if(now <= 0){
					enemy.send("<GAMEOVER />");
					map[pos.x][pos.y].remove(enemy);
				}else{
					sendNotify(enemy, STATUS_WOUNDED, "", "");
					enemy.setAttribute("LastWounded", System.currentTimeMillis());
				}
				chatlog(area, client.getUserName(), enemy.getUserName() + "ɒe");
				
				enemyNotify2All(enemy, null);
			}
			
			if(hit > 0){
				addPoint(client, bonus + 1);
				sendNotify(client, STATUS_HIT, "" + bonus, "");
			}else{
				sendNotify(client, STATUS_IGNORE, "", "");
			}
			enemyNotify2All(client, null);
			
			// ӌ
			int w = map.length - 1, h = map[pos.x].length - 1;
			int f1 = 0;
			if(pos.x > 0)             { f1 += map[pos.x - 1][pos.y].size(); }
			if(pos.x > 0 && pos.y > 0){ f1 += map[pos.x - 1][pos.y - 1].size(); }
			if(             pos.y > 0){ f1 += map[pos.x][pos.y - 1].size(); }
			if(pos.x < w && pos.y > 0){ f1 += map[pos.x + 1][pos.y - 1].size(); }
			if(pos.x < w)             { f1 += map[pos.x + 1][pos.y].size(); }
			if(pos.x < w && pos.y < h){ f1 += map[pos.x + 1][pos.y + 1].size(); }
			if(             pos.y < h){ f1 += map[pos.x][pos.y + 1].size(); }
			if(pos.x > 0 && pos.y < h){ f1 += map[pos.x - 1][pos.y + 1].size(); }
			
			int f2 = 0;
			if(pos.x > 1)                     { f2 += map[pos.x - 2][pos.y].size(); }
			if(pos.x > 1     && pos.y > 0)    { f2 += map[pos.x - 2][pos.y - 1].size(); }
			if(pos.x > 1     && pos.y > 1)    { f2 += map[pos.x - 2][pos.y - 2].size(); }
			if(pos.x > 0     && pos.y > 1)    { f2 += map[pos.x - 1][pos.y - 2].size(); }
			if(                 pos.y > 1)    { f2 += map[pos.x][pos.y - 2].size(); }
			if(pos.x     < w && pos.y > 1)    { f2 += map[pos.x + 1][pos.y - 2].size(); }
			if(pos.x + 1 < w && pos.y > 1)    { f2 += map[pos.x + 2][pos.y - 2].size(); }
			if(pos.x + 1 < w && pos.y > 0)    { f2 += map[pos.x + 2][pos.y - 1].size(); }
			if(pos.x + 1 < w)                 { f2 += map[pos.x + 2][pos.y].size(); }
			if(pos.x + 1 < w && pos.y     < h){ f2 += map[pos.x + 2][pos.y + 1].size(); }
			if(pos.x + 1 < w && pos.y + 1 < h){ f2 += map[pos.x + 2][pos.y + 2].size(); }
			if(pos.x     < w && pos.y + 1 < h){ f2 += map[pos.x + 1][pos.y + 2].size(); }
			if(                 pos.y + 1 < h){ f2 += map[pos.x][pos.y + 2].size(); }
			if(pos.x > 0     && pos.y + 1 < h){ f2 += map[pos.x - 1][pos.y + 2].size(); }
			if(pos.x > 1     && pos.y + 1 < h){ f2 += map[pos.x - 2][pos.y + 2].size(); }
			if(pos.x > 1     && pos.y     < h){ f2 += map[pos.x - 2][pos.y + 1].size(); }
			
			// ܂܂Ăꍇ
			if(f2 > 0 && (distance <= Math.sqrt(8.0) && distance >= 2.0)){ f2--; }
			
			xml = new SimpleXMLCreator("FIRE_RESULT", this);
			xml.setAttribute("x", pos.x);
			xml.setAttribute("y", pos.y);
			xml.setAttribute("f1", f1);
			xml.setAttribute("f2", f2);
			xml.setAttribute("hit", hit);
			xml.send(client);
		}
		
		return true;
	}

	// \bh /////////////////////////////////////////////////////////////////////
	//                                                                 Private Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	private void setPoint(SocketProcessor client, int point){
		client.setAttribute("POINT", point);
	}
	
	private int getPoint(SocketProcessor client){
		try{
			return client.getAttributeInt("POINT");
		}catch(Exception e){ return -1; }
	}
	
	private void addPoint(SocketProcessor client, int point){
		try{
			client.setAttribute("POINT", client.getAttributeInt("POINT") + point);
		}catch(Exception e){ return; }
	}
	
	private void enemyNotify2All(SocketProcessor client, String message){
		int point = getPoint(client);
		
		SimpleXMLCreator xml = new SimpleXMLCreator("ENEMY", this);
		xml.setAttribute("name", client.getUserName());
		xml.setAttribute("point", (point >= 0 ? "" + point : "retreat"));
		xml.send((Finder)client.getAttribute("FinderWithoutMe"));
		
		if(message == null){ return; }
		
		xml = new SimpleXMLCreator("NOTIFY", this);
		xml.setAttribute("status", STATUS_MESSAGE);
		xml.setAttribute("message", message);
		xml.send((Finder)client.getAttribute("FinderWithoutMe"));
	}
	
	private void sendNotify(SocketProcessor client, int status, String option, String message){
		SimpleXMLCreator xml = new SimpleXMLCreator("NOTIFY", this);
		xml.setAttribute("point", getPoint(client));
		xml.setAttribute("status", status);
		xml.setAttribute("option", option);
		xml.setAttribute("message", message);
		xml.send(client);
	}
	
	private ArrayList[][] getMap(String area, Position pos){
		ArrayList[][] map = (ArrayList[][])areamap.get(area);
		if(map               == null){ return null; }
		if(map.length        <= pos.x){ return null; }
		if(map[pos.x].length <= pos.y){ return null; }
		
		return map;
	}
	
	/* ***********************************************************************>> */;
	/**
	 * `bgOƂ܂B
	 * 
	 * @param room `bg
	 * @param user [U[
	 * @param memo eA܂̓VXebZ[W
	 */
	private void chatlog(String room, String user, String memo){
		log(room + "," + user + "," + memo);
	}

	// NX ///////////////////////////////////////////////////////////////////////
	//                                                                     Inner Class //
	/////////////////////////////////////////////////////////////////////////////////////
	private class PositionParseException extends Exception{
		PositionParseException(String message){ super(message); }
	}
	private class Position{
		Position(int x, int y){
			this.x = x;
			this.y = y;
		}
		Position(String str) throws PositionParseException{
			int colonIdx = str.indexOf(':');
			if(colonIdx >= 0){
				str = str.substring(colonIdx + 1);
			}
			
			int idx = str.indexOf(',');
			if(idx < 0){ throw new PositionParseException("\",\" not found"); }
			int newx = 0, newy = 0;
			this.x = Integer.parseInt(str.substring(0, idx));
			this.y = Integer.parseInt(str.substring(idx + 1));
		}
		private int x;
		private int y;
	}
}
