/*
 * Decompiled with CFR 0.152.
 */
package jp.moja.socklet.util.security;

import jp.moja.socklet.util.security.ClientChecker;
import jp.wda.gpss.SocketProcessor;

public class IPAddressChecker
extends ClientChecker {
    private String[] addresses;
    private int trueOperation;
    private int falseOperation;

    public IPAddressChecker(String addresses, int trueOperation, int falseOperation) {
        this.addresses = addresses.split(",");
        int i = 0;
        while (i < this.addresses.length) {
            String str = this.addresses[i];
            str = str.trim();
            str = str.replaceAll("\\.", "\\\\.");
            this.addresses[i] = str = str.replaceAll("\\*", ".*");
            ++i;
        }
        this.trueOperation = trueOperation;
        this.falseOperation = falseOperation;
    }

    public int enter(SocketProcessor client) {
        String ipAddress = client.getIPAddress();
        return this.check(ipAddress);
    }

    private int check(String ipAddress) {
        int i = 0;
        while (i < this.addresses.length) {
            if (ipAddress.matches(this.addresses[i])) {
                return this.trueOperation;
            }
            ++i;
        }
        return this.falseOperation;
    }
}

