/*
 * Decompiled with CFR 0.152.
 */
package jp.moja.socklet.util.security;

import java.util.HashMap;
import jp.moja.socklet.util.security.ClientChecker;
import jp.wda.gpss.SocketProcessor;

public class LimitedConnectionPerHostChecker
extends ClientChecker {
    private int maxConnection;
    private HashMap connections;
    private int trueOperation;
    private int falseOperation;

    public LimitedConnectionPerHostChecker(int max, int trueOperation, int falseOperation) {
        this.maxConnection = max;
        this.connections = new HashMap();
        this.trueOperation = trueOperation;
        this.falseOperation = falseOperation;
    }

    public synchronized int enter(SocketProcessor client) {
        int connectionCount = 0;
        String ipAddress = client.getIPAddress();
        Object o = this.connections.get(ipAddress);
        if (o != null) {
            connectionCount = (Integer)o;
        }
        this.connections.put(ipAddress, new Integer(++connectionCount));
        if (connectionCount <= this.maxConnection) {
            return this.trueOperation;
        }
        return this.falseOperation;
    }

    public synchronized void exit(SocketProcessor client) {
        int connectionCount = 0;
        String ipAddress = client.getIPAddress();
        Object o = this.connections.get(ipAddress);
        if (o == null) {
            return;
        }
        connectionCount = (Integer)o;
        if (--connectionCount > 0) {
            this.connections.put(ipAddress, new Integer(connectionCount));
        } else {
            this.connections.remove(ipAddress);
        }
    }
}

