package jp.wda.gpss.system;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.Iterator;

import jp.wda.gpss.Progress;
import jp.wda.gpss.Socklet;
import jp.wda.gpss.SockletDeployInfo;
import jp.wda.gpss.SockletDeployingException;
import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;

/**
 * <FONT SIZE=2><I><B>
 * [ OProject GPSS for FlashMX ] FlashMXpėp\PbgT[o
 * </B></I></FONT><BR>
 * \Pbg҂CT[oNX<BR>
 * java.nioutil.concurrentgłB<BR>
 * ڑtƃf[^t͑SăCXbhōs܂B<BR>
 * Mf[^̏̓v[ꂽXbhŎs܂<BR>
 * <BR>
 * NCAgMR}h̎s͗_ۏ؂܂B<BR>
 * <BR>
 * Ԗڂ̈ɁAconfig.xmlݒt@Cw肵āANĂB<BR>
 *
 * @version	2		2003/12/21
 * @since		0		2003/12/18
 * @author	amoi, TakenoriAdachi(TheCoolMuseum)
 */
public class MainNioPooledThread extends ExecutableBase {
	// AvP[VGg[|Cg ///////////////////////////////////////////////
	//                                                         Application Entry Point //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * Ҏ󂯃CT[oN܂B<BR>
	 * Ԗڂ̈ɁAconfig.xmlݒt@Cw肵āANĂB<BR>
	 * 
	 * @param args
	 */
	public static void main(String[] args) {
		if (args.length == 0) {
			System.out.println("Usage : ");
			System.out.println("  java jp.wda.gpss.system.Main config.xml");
			System.out.println("    config.xml - ݒt@C");

			return;
		}
		File configfile = new File(args[0]);
		if (!configfile.exists()) {
			System.out.println("ݒt@C܂B");
			System.out.println("File : " + configfile.getAbsolutePath());
			return;
		}

		MainNioPooledThread main =
			new MainNioPooledThread(new Configuration(configfile));
	}

	// RXgN^ ///////////////////////////////////////////////////////////////////
	//                                                                    Constructors //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 *	ftHg̐ݒpăIuWFNg\zRXgN^
	 */
	private MainNioPooledThread(Configuration config) {
		super(config);

		this.terminator = false;
	}

	/* ***********************************************************************>> */;
	/**
	 * JVMKx[WRN^ɂČĂ΂AIB<BR>
	 * zĂSĂSocklet̏IsȂ܂B<BR>
	 * IĂꍇ́AɉsȂ܂B
	 */
	protected void finalize() {
		if (this.terminator) {
			return;
		}

		Iterator it = getSocklets();
		while (it.hasNext()) {
			Socklet app = (Socklet) it.next();
			app.destroy();
		}
	}

	// tB[h` ///////////////////////////////////////////////////////////////
	//                                                                          Fields //
	/////////////////////////////////////////////////////////////////////////////////////

	/**
	 * T[o[`l
	 */
	private ServerSocketChannel serverChannel;
	/**
	 * ZN^[
	 */
	private Selector selector;
	/**
	 * ZN^[擾
	 * @return
	 */
	Selector getSelector() {
		return selector;
	}

	/**
	 * T[oIXCb`
	 */
	private boolean terminator = false;

	/**
	 * f[^Mobt@
	 */
	private ByteBuffer buffer = null;
	/**
	 * bZ[Wꎞobt@
	 */
	//private ByteBuffer tempBuffer = null;

	private static final int BUFFER_SIZE = 4096;

	/**
	 * obt@̃GR[_[EfR[_[
	 */
	private Charset codec = null;
	/**
	 * obt@p̃R[_[擾
	 * @return T[o[̃R[_[
	 */
	Charset getCodec() {
		return codec;
	}

	/**
	 * R}hpXbhv[
	 */
	private PooledExecutor pool;
	/**
	 * T[o[̃Xbhv[擾
	 * @return
	 */
	PooledExecutor getPool() {
		return pool;
	}

	// \bh /////////////////////////////////////////////////////////////////////
	//                                                                 Private Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * T[oJnAڑEf[^󂯕t܂B
	 * @see jp.wda.gpss.system.ExecutableBase#accept()
	 */
	public void accept() {
		System.out.println("Starting server...");

		int n = 0;
		SleeperSweeper sweeper = null;
		ServerSocket serverSocket = null;

		buffer = ByteBuffer.allocateDirect(BUFFER_SIZE);
		//tempBuffer = ByteBuffer.allocateDirect(BUFFER_SIZE);

		codec = Charset.forName(getEncoding());

		pool = makeThreadPool(); //Xbhv[̍쐬

		try {

			serverChannel = ServerSocketChannel.open();
			serverSocket = serverChannel.socket();
			selector = Selector.open();

			sweeper = new SleeperSweeper(selector);
			new Thread(sweeper, "Sweeper").start();

			serverSocket.bind(new InetSocketAddress(getPort()));

			serverChannel.configureBlocking(false);

			serverChannel.register(selector, SelectionKey.OP_ACCEPT);

			// T[oNĂԂ́BBB
			while (true) {
				try {
					n = selector.select();

					//ItO`FbN
					if (terminator) {
						break; //I
					}

					//ZNgĂȂ
					if (n == 0) {
						continue;
					}

					//L[̃Ce[^[쐬
					Iterator it = selector.selectedKeys().iterator();

					//SẴL[ɃV[N
					while (it.hasNext()) {
						SelectionKey key = (SelectionKey) it.next();

						//NCAgڑ
						if (key.isAcceptable()) {
							createSocketProcessor(key);
						}

						//ǂݍݏ
						if (key.isReadable()) {
							readMessage(key);
						}

						//L[Xg폜
						it.remove();
					}
				} catch (RuntimeException e) {
					//̗O͗vEE
					e.printStackTrace();
				}
			}
		} catch (ClosedSelectorException cse) {
			//  ZN^[N[YĂ
			getProgress().syslog("Selector closed.");
		} catch (ClosedChannelException cse) {
			//  `lN[YĂ
			getProgress().syslog("Channel closed.");
		} catch (IOException ioe) {
			getProgress().errlog("o̓G[܂B", ioe);
		} catch (Throwable e) {
			//  ڑsƂ`
			e.printStackTrace();
		} finally {
			//T[o[`lƃZN^[N[Y
			try {
				sweeper.terminate();
				if (serverChannel != null) {
					serverChannel.close();
				}
				if (selector != null) {
					selector.close();
				}
			} catch (Exception e) {
				;
			}

			this.terminator = false;
		}
	}

	/**
	 * [J[Xbh쐬đҋ@܂
	 * el͐ݒt@Cǂ߂قB
	 */
	private PooledExecutor makeThreadPool() {
		PooledExecutor pool = new PooledExecutor(new BoundedBuffer(10), 100);
		//ő100Xbh
		pool.setMinimumPoolSize(5); //ŏ5Xbh
		pool.setKeepAliveTime(5 * 60 * 1000); //^CAEg5
		pool.waitWhenBlocked(); //EFCg[hݒ
		pool.createThreads(5); //5XbhŊJn
		return pool;
	}

	/**
	 * bZ[WǂݎNCAgɑ܂
	 * @param key
	 */
	private void readMessage(SelectionKey key) {
		int length = -1;
		byte b = 0;

		//L[`l̎擾
		SocketChannel socketChannel = (SocketChannel) key.channel();

		//L[NCAgIuWFNg̎擾
		SocketProcessorImplNioPooledThread client =
			(SocketProcessorImplNioPooledThread) (key.attachment());

		buffer.clear();

		try {
			while ((length = socketChannel.read(buffer)) > 0) {
				buffer.flip(); //obt@ǂݏo\
				client.setMessage(buffer); //NCAgɃobt@n
				buffer.clear(); //obt@̃NA
			}
		} catch (ClosedChannelException e) {
			getProgress().errlog("\Pbg͊ɃN[YĂ܂B:" + client.getClientID());
		} catch (IOException ioe) {
			getProgress().errlog("̓G[܂B:" + client.getClientID());
		}

		//\PbgN[YEǂݏoG[
		if (length < 0) {
			client.terminate(); //NCAgI
		}
	}

	/* ***********************************************************************>> */;
	/**
	 * NCAgIuWFNg쐬܂B
	 * 
	 * @param key acceptʒmL[
	 */
	private void createSocketProcessor(SelectionKey key) {
		SocketProcessorImplNioPooledThread client = null;
		try {
			ServerSocketChannel server = (ServerSocketChannel) key.channel();

			SocketChannel channel = server.accept();

			Socket socket = channel.socket();

			getProgress().syslog(
				"Create Client... " + socket.getInetAddress().getHostAddress());

			//NCAgIuWFNg̐
			client =
				new SocketProcessorImplNioPooledThread(
					this,
					channel,
					getEncoding(),
					getMessagesBufferSize());
			if (channel != null) {
				channel.configureBlocking(false);
				channel.register(key.selector(), SelectionKey.OP_READ, client);
			}

			getProgress().syslog(
				"Create Client... " + socket.getInetAddress().getHostAddress());

			socket.setSoTimeout(getInitialTimeout()); //
			client.setTimeout(getInitialTimeout());

			getProgress().syslog(
				"Welcome "
					+ client.getIPAddress()
					+ "! (ID:"
					+ client.getClientID()
					+ ")");

		} catch (InterruptedIOException e) {
			getProgress().errlog("^CAEgݒɎs܂B:" + client.getClientID(), e);
			return;
		} catch (IOException e) {
			e.printStackTrace();
			return;
		}

		return;
	}

	// SystemCommandSockletp\bh ///////////////////////////////////////////////////
	//                                                Methods for SystemCommandSocklet //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * T[oI܂B
	 * @param sys ĂяoSystemCommandSocklet
	 * @see jp.wda.gpss.ExecutableBase#shutdown(SystemCommandSocklet)
	 */
	void shutdown(SystemCommandSocklet sys) {
		if (!checkSystemCommandSocklet(sys)) {
			return;
		}

		getProgress().syslog("Shutdown server...");

		// ڑ̑SNCAgؒf
		Iterator it = getSocklets();
		while (it.hasNext()) {
			Socklet app = (Socklet) it.next();
			app.disconnectAllClients("Good by...");
			app.destroy();
		}

		this.terminator = true;

		try {
			serverChannel.close();
			selector.wakeup();
			selector.close();
		} catch (IOException ioe) {
			getProgress().syslog("Shutdown Failed!");
			return;
		}

		pool.shutdownNow();

		getProgress().syslog("Shutdown successfully!");
	}

	/* ***********************************************************************>> */;
	/**
	 * T[oċN܂B
	 * @param sys ĂяoSystemCommandSocklet
	 * @see jp.wda.gpss.ExecutableBase#restart(SystemCommandSocklet)
	 */
	void restart(SystemCommandSocklet sys) {
		if (!checkSystemCommandSocklet(sys)) {
			return;
		}

		setRestartAfterShutdown();
		shutdown(sys);
	}

	/* ***********************************************************************>> */;
	/**
	 * w肵zSockletċN܂
	 * 
	 * @param sys ĂяoSystemCommandSocklet
	 * @param name Sockletz
	 * @return ċNɐ^
	 * @see jp.wda.gpss.ExecutableBase#restartSocklet(SystemCommandSocklet, String)
	 */
	boolean restartSocklet(SystemCommandSocklet sys, String name) {
		if (!checkSystemCommandSocklet(sys)) {
			return false;
		}

		getProgress().syslog("Restart socklet \"" + name + "\"");
		Socklet socklet = this.getSocklet(name);
		SockletDeployInfo info = null;
		String scriptExt = null;
		File scriptFile = null;
		SockletLoader loader = null;
		if (socklet != null && socklet instanceof ScriptSocklet) {
			scriptExt = ((ScriptSocklet) socklet).getExtention();
			scriptFile = ((ScriptSocklet) socklet).getScriptFile();
			ScriptInfo scrinfo = getScriptInfomation(scriptExt);

			if (scrinfo != null && scriptFile != null && scriptFile.exists()) {
				info = getScriptSockletInformation(name);
				info.addInitParam("source", scriptFile.getAbsolutePath());
				info.addInitParam("sourceEncoding", scrinfo.getEncoding());
				info.setClassname(scrinfo.getJSClass().getName());
			}

			loader = this.scriptLoader;
		} else {
			info = getSockletInformation(name);
		}

		if (info == null) {
			getProgress().syslog(
				"Socket \"" + name + "\"'s infomation is not found.",
				Progress.ERROR);
			return false;
		}

		// Socklet̒~
		terminateSocklet(socklet, "Good by...");

		getProgress().syslog(
			"Socklet\""
				+ info.getName()
				+ "\"("
				+ info.getClassname()
				+ ")z܂B");
		try {
			socklet = deployNewSocklet(info, DEPLOY_BY_SYSTEM, loader);
			if (socklet instanceof ScriptSocklet) {
				((ScriptSocklet) socklet).setExtention(scriptExt);
				((ScriptSocklet) socklet).setScriptFile(scriptFile);
			}
		} catch (SockletDeployingException e) {
			getProgress().errlog("Socklet̔zɎs܂B", e);
			return false;
		}
		return true;
	}

	/* ***********************************************************************>> */;
	/**
	 * ݒt@CēǍ܂B
	 * @param sys ĂяoSystemCommandSocklet
	 * @return ēǍɐ^
	 * @see jp.wda.gpss.ExecutableBase#reloadCongif(SystemCommandSocklet)
	 */
	boolean reloadConfig(SystemCommandSocklet sys) {
		if (!checkSystemCommandSocklet(sys)) {
			return false;
		}

		System.out.println("Reload config...");
		try {
			loadConfig();
		} catch (ConfigurationError e) {
			getProgress().errlog("ݒt@C̍ēǍɎs܂B", e);
			return false;
		}

		reloadSystemCommandInfo();

		System.out.println("Reload config successfully!");
		return true;
	}

	/**
	 * ^CAEgؒfNX
	 * Ȏ__ȋCEE
	 * @̂EE
	 */
	final class SleeperSweeper implements Runnable {
		Selector selector;
		boolean terminator;

		public SleeperSweeper(Selector selector) {
			this.selector = selector;
			this.terminator = false;
		}

		public synchronized void terminate() {
			terminator = true;
			notify();
		}

		public synchronized void run() {
			while (true) {
				if (terminator) {
					break;
				}
				Object[] keyArray;
				try {
					keyArray = selector.keys().toArray();
					Thread.yield();
				} catch (ClosedSelectorException cse) {
					break;
				}
				for (int i = 0; keyArray.length > i; i++) {
					try {
						(
							(SocketProcessorImplNioPooledThread)
								(((SelectionKey) keyArray[i])
							.attachment()))
							.terminateIfInactive();
					} catch (Throwable e) {
						;
					}
				}
				keyArray = null;
				try {
					wait(10000);
				} catch (Throwable e) {
					;
				}
			}
		}
	}

}

/**
 * <FONT SIZE=2><I><B>
 * [ OProject GPSS for FlashMX ] FlashMXpėp\PbgT[o
 * </B></I></FONT><BR>
 *	NCAg\PbgC^[tF[X̎
 *
 *	@author	amoi, TakenoriAdachi(TheCoolMuseum)
 */
final class SocketProcessorImplNioPooledThread
	extends SocketProcessorBase
	implements Runnable {
	// RXgN^ ///////////////////////////////////////////////////////////////////
	//                                                                    Constructors //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 *	CT[oƃ\Pbgw肵ăIuWFNg\z܂B
	 *
	 * @param main CT[o
	 * @param socket \Pbg
	 */
	public SocketProcessorImplNioPooledThread(
		MainNioPooledThread server,
		SocketChannel channel,
		String encoding,
		int buffersize)
		throws IOException {
		super(
			server,
			encoding,
			buffersize,
			channel.socket().getInetAddress().getHostAddress());
		this.server = server;
		this.channel = channel;
		this.codec = server.getCodec();
		this.messageBuffer = ByteBuffer.allocate(BUFFER_SIZE);
	}

	// tB[h` ///////////////////////////////////////////////////////////////
	//                                                                          Fields //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * \Pbg`l
	 */
	private SocketChannel channel;

	/**
	 * byteBufferGR[_[
	 */
	private Charset codec;

	/**
	 * bZ[Wobt@
	 */
	private ByteBuffer messageBuffer;
	private static final int BUFFER_SIZE = 4096;

	/**
	 * ҂󂯃T[o[
	 */
	private MainNioPooledThread server;

	//-------------------------------
	//^CAEg
	//nioł@ł傤EE
	//-------------------------------

	/**
	 * ^CAEg
	 */
	private long timeout = 0;
	/**
	 * ŏI
	 */
	private long lastAct = System.currentTimeMillis();
	/**
	 * ^CAEgԂ~bŐݒ<BR>
	 * ݒ莞0Ŗ<BR>
	 * @param timeout
	 */
	void setTimeout(long timeout) {
		this.timeout = timeout;
	}
	/**
	 * ^CAEgĂ邩ǂ`FbN
	 * @return
	 */
	boolean isInactive() {
		if (timeout == 0) {
			return false;
		}
		return System.currentTimeMillis() > timeout + lastAct;
	}
	/**
	 * ŏIL^
	 */
	private void recordActive() {
		lastAct = System.currentTimeMillis();
	}

	/**
	 * ^CAEgĂȂI
	 */
	void terminateIfInactive() {
		if (isInactive() && !isTerminated()) {
			terminate();
		}
	}

	// vpeB ///////////////////////////////////////////////////////////////////////
	//                                                                      Properties //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * ItO
	 */
	private boolean terminated = false;
	/**
	 * ItOmF
	 */
	public boolean isTerminated() {
		return terminated;
	}

	// CX^X\bh /////////////////////////////////////////////////////////////
	//                                                                Instance Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/**
	 * obt@ǂݏoAR}hs܂
	 * @param buffer
	 */
	void setMessage(ByteBuffer buffer) {
		recordActive(); //L^ @͂Ƃŕς邩

		byte b = 0;
		while (buffer.hasRemaining()) {
			b = buffer.get(); //1oCg擾
			if (b != 0) {
				messageBuffer.put(b); //bZ[Wobt@ɒ~
			} else {
				messageBuffer.flip(); //bZ[Wobt@̓ǂݏo\Ԃ
				try {
					server.getPool().execute(
						new CommandProcessor(this, messageBuffer));
				} catch (InterruptedException ie) {
					;
				}
				//sXbhŎs
				//new CommandProcessor(this, messageBuffer.toString()).run(); 

				messageBuffer = ByteBuffer.allocate(BUFFER_SIZE); //Vobt@̍쐬
			}
		}
	}

	/* ***********************************************************************>> */;
	/**
	 * \PbgR}hMAAvP[ṼC^v^ɗ܂B
	 *	@see java.lang.Runnable#run()
	 */
	public void run() {
		//܂EE
	}

	/**
	 * NCAg̐ڑ
	 * @param mesage
	 */
	private void onInitialize(String mesage) {
		try {
			getProgress().log(
				"debuglogger",
				"connection:" + mesage + " [" + getClientID() + "]");
			doInitialCommand(mesage);

			// Sockletݒ肳ĂȂꍇ͒ɏIB
			if (getApplication() == null) {
				terminate();
				return;
			}

			// NCAg̐ڑsAʂʒm܂B
			// ʒmbZ[WMɎsꍇ͒ɏIB
			if (!getApplication().checkConnection(this)) {
				terminate();
				return;
			}

			this.terminated = false;

			// ^CAEgԂݒ  
			channel.socket().setSoTimeout(getApplication().getTimeout());
			setTimeout(getApplication().getTimeout());

		} catch (SocketException ioe) {
			getProgress().errlog(ioe.getMessage() + ":" + getClientID());
			terminate();
		} catch (Throwable e) {
			getProgress().errlog("O܂B" + getClientID(), e);

		}
	}

	/**
	 * NCAg̃R}h̏
	 * @param message
	 */
	private void onCommand(String message) {
		try {
			if (!getApplication().doCommand(this, message)) {
				terminate();
			}
		} catch (Throwable e) {
			getProgress().errlog("O܂B" + getClientID(), e);

		}
	}

	/* ***********************************************************************>> */;
	/**
	 * NCAgɃbZ[W𑗂܂B<BR>
	 * bZ[Wnull"\0"I[Ƃ܂B<BR>
	 * ̃\bhł́AMp̕ʃXbhgp܂B<BR>
	 * NCAgɃbZ[WM̂҂܂B<BR>
	 *
	 * @param msg NCAgɑ郁bZ[W
	 * @return Mɐꍇ͐^Asꍇ͋U
	 */
	public boolean send(String message) {
		if (this.channel == null) {
			getProgress().errlog("C^r܂B" + getClientID());
			return false;
		}
		try {
			channel.write(codec.encode(message + "\0"));
		} catch (IOException e) {
			getProgress().errlog(
				"MɎs܂B" + getClientID() + "\n" + message,
				e);
			return false;
		}

		return true;
	}

	/* ***********************************************************************>> */;
	/**
	 * NCAgIɏI܂B
	 * @see jp.wda.gpss.SocketProcessor#terminate()
	 */
	public synchronized void terminate() {
		this.terminated = true;

		// fobOpóB
		getProgress().log("debuglogger", "disconnect [" + getClientID() + "]");

		try {
			// AvP[V炱̃NCAg폜
			if (getApplication() != null) {
				getApplication().preRemoveClient(this);
				getApplication().removeClient(this);
				notifyToSystemCommandSocklet();
			}
		} catch (Throwable e) {
			getProgress().errlog("IɗO܂B" + getClientID(), e);
			e.printStackTrace();
		}

		// \Pbg
		try {
			if (channel != null) {
				channel.close();
				server.getSelector().wakeup();
				//System.out.println("Terminate client");
			}
		} catch (IOException e) {
			getProgress().errlog("`lIɗO܂B" + getClientID(), e);
		}

		channel = null;
	}

	/**
	 * NCAgɏIbZ[WoANCAg\PbgI܂B
	 * @param message IbZ[W
	 * @see jp.wda.gpss.SocketProcessor#terminate(String)
	 */
	public synchronized void terminate(String message) {
		send(message);
		terminate();
	}

	/**
	 * R}hXbhŎs邽߂̓NX 
	 */
	private class CommandProcessor implements Runnable {
		private ByteBuffer command;
		private SocketProcessorImplNioPooledThread client;

		/**
		 * R}hIuWFNg̃RXgN^
		 * @param client
		 * @param command
		 */
		private CommandProcessor(
			SocketProcessorImplNioPooledThread client,
			ByteBuffer command) {
			this.command = command;
			this.client = client;
		}

		/**
		 * R}hIuWFNg̎s
		 * sXbhs܂B
		 * @see java.lang.Runnable#run()
		 */
		public void run() {
			if (!client.isTerminated()) {
				//obt@𕶎ɕϊ
				String com = codec.decode(command).toString();

				//R}hs
				if (client.getApplication() != null) {
					client.onCommand(com);
				} else {
					client.onInitialize(com);
				}
			}
			//			//[׃eXĝ߂̃EFCg
			//			try {
			//				Thread.sleep(3000);
			//			} catch (Throwable e) {
			//				;
			//			}
		}
	}
}
