/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.BuiltinFunctionObject;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.ObjectPrototype;
import FESI.Data.StringObject;
import FESI.Data.StringPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.Evaluator;

public class StringObject
extends BuiltinFunctionObject {
    private StringObject(ESObject eSObject, Evaluator evaluator) {
        super(eSObject, evaluator, "String", 1);
    }

    public String toString() {
        return "<String>";
    }

    public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
        if (eSValueArray.length == 0) {
            return new ESString("");
        }
        return new ESString(eSValueArray[0].toString());
    }

    public ESObject doConstruct(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
        StringPrototype stringPrototype = null;
        ESObject eSObject2 = this.evaluator.getStringPrototype();
        stringPrototype = new StringPrototype(eSObject2, this.evaluator);
        stringPrototype.value = eSValueArray.length > 0 ? new ESString(eSValueArray[0].toString()) : new ESString("");
        return stringPrototype;
    }

    public static StringObject makeStringObject(Evaluator evaluator, ObjectPrototype objectPrototype, FunctionPrototype functionPrototype) {
        StringPrototype stringPrototype = new StringPrototype(objectPrototype, evaluator);
        StringObject stringObject = new StringObject(functionPrototype, evaluator);
        try {
            stringObject.putHiddenProperty("prototype", stringPrototype);
            stringObject.putHiddenProperty("length", new ESNumber(1.0));
            stringObject.putHiddenProperty("fromCharCode", new 1.StringObjectFromCharCode("fromCharCode", evaluator, functionPrototype));
            stringPrototype.putHiddenProperty("constructor", stringObject);
            stringPrototype.putHiddenProperty("toString", new 1.StringPrototypeToString("toString", evaluator, functionPrototype));
            stringPrototype.putHiddenProperty("valueOf", new 1.StringPrototypeValueOf("valueOf", evaluator, functionPrototype));
            stringPrototype.putHiddenProperty("charAt", new 1.StringPrototypeCharAt("charAt", evaluator, functionPrototype));
            stringPrototype.putHiddenProperty("charCodeAt", new 1.StringPrototypeCharCodeAt("charCodeAt", evaluator, functionPrototype));
            stringPrototype.putHiddenProperty("indexOf", new 1.StringPrototypeIndexOf("indexOf", evaluator, functionPrototype));
            stringPrototype.putHiddenProperty("lastIndexOf", new 1.StringPrototypeLastIndexOf("lastIndexOf", evaluator, functionPrototype));
            stringPrototype.putHiddenProperty("split", new 1.StringPrototypeSplit("split", evaluator, functionPrototype));
            stringPrototype.putHiddenProperty("substring", new 1.StringPrototypeSubstring("substring", evaluator, functionPrototype));
            stringPrototype.putHiddenProperty("toLowerCase", new 1.StringPrototypeToLowerCase("toLowerCase", evaluator, functionPrototype));
            stringPrototype.putHiddenProperty("toUpperCase", new 1.StringPrototypeToUpperCase("toUpperCase", evaluator, functionPrototype));
        }
        catch (EcmaScriptException ecmaScriptException) {
            ecmaScriptException.printStackTrace();
            throw new ProgrammingError(ecmaScriptException.getMessage());
        }
        evaluator.setStringPrototype(stringPrototype);
        return stringObject;
    }
}

