/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.gpss.system;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Set;
import jp.wda.gpss.Progress;
import jp.wda.gpss.Socklet;
import jp.wda.gpss.SockletDeployInfo;
import jp.wda.gpss.SockletDeployingException;
import jp.wda.gpss.system.Configuration;
import jp.wda.gpss.system.ConfigurationError;
import jp.wda.gpss.system.ExecutableBase;
import jp.wda.gpss.system.ScriptInfo;
import jp.wda.gpss.system.ScriptSocklet;
import jp.wda.gpss.system.SocketProcessorBase;
import jp.wda.gpss.system.SocketProcessorImplReactor;
import jp.wda.gpss.system.SockletLoader;
import jp.wda.gpss.system.SystemCommandSocklet;

public class MainReactor
extends ExecutableBase {
    private ServerSocketChannel serverChannel;
    private Selector selector;
    private boolean terminator = false;
    private Charset coder = null;
    private PooledExecutor pool;

    public MainReactor(Configuration config) {
        super(config);
    }

    protected void finalize() {
        if (this.terminator) {
            return;
        }
        Iterator it = this.getSocklets();
        while (it.hasNext()) {
            Socklet app = (Socklet)it.next();
            app.destroy();
        }
    }

    Charset getCodec() {
        return this.coder;
    }

    PooledExecutor getPool() {
        return this.pool;
    }

    public void accept() {
        System.out.println("Starting server...");
        int n = 0;
        SleeperSweeper sweeper = null;
        ServerSocket serverSocket = null;
        this.coder = Charset.forName(this.getEncoding());
        this.pool = this.makeThreadPool();
        try {
            try {
                this.serverChannel = ServerSocketChannel.open();
                serverSocket = this.serverChannel.socket();
                this.selector = Selector.open();
                serverSocket.bind(new InetSocketAddress(this.getPort()));
                this.serverChannel.configureBlocking(false);
                SelectionKey acceptKey = this.serverChannel.register(this.selector, 16);
                acceptKey.attach(new AcceptHandler(acceptKey, this));
                sweeper = new SleeperSweeper(this.selector);
                new Thread((Runnable)sweeper, "Sweeper").start();
            }
            catch (IOException ioe) {
                this.getProgress().errlog("\u30b5\u30fc\u30d0\u30fc\u30bd\u30b1\u30c3\u30c8\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f", ioe);
                Object var7_10 = null;
                try {
                    if (this.serverChannel != null) {
                        this.serverChannel.close();
                    }
                    if (this.selector != null) {
                        this.selector.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (sweeper != null) {
                    sweeper.terminate();
                }
                if (this.pool != null) {
                    this.pool.shutdownNow();
                }
                this.getProgress().syslog("Shutdown successfully!");
                this.terminator = false;
                return;
            }
            block13: while (true) {
                try {
                    if (!this.terminator) {
                        n = this.selector.select();
                        if (n == 0) continue;
                        Set<SelectionKey> selected = this.selector.selectedKeys();
                        Iterator<SelectionKey> it = selected.iterator();
                        while (true) {
                            if (this.terminator || !it.hasNext()) continue block13;
                            SelectionKey key = it.next();
                            it.remove();
                            this.dispatch(key);
                        }
                    }
                }
                catch (ClosedSelectorException cse) {
                    this.getProgress().errlog("\u30bb\u30ec\u30af\u30bf\u30fc\u306f\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059", cse);
                }
                catch (IOException ioe) {
                    this.getProgress().errlog("\u5165\u51fa\u529b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", ioe);
                }
                catch (RuntimeException e) {
                    this.getProgress().errlog("\u30e9\u30f3\u30bf\u30a4\u30e0\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", e);
                    e.printStackTrace();
                    continue;
                }
                catch (Throwable e) {
                    this.getProgress().errlog("\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
                    e.printStackTrace();
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            try {
                if (this.serverChannel != null) {
                    this.serverChannel.close();
                }
                if (this.selector != null) {
                    this.selector.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (sweeper != null) {
                sweeper.terminate();
            }
            if (this.pool != null) {
                this.pool.shutdownNow();
            }
            this.getProgress().syslog("Shutdown successfully!");
            this.terminator = false;
            throw throwable;
        }
        Object var7_12 = null;
        try {
            if (this.serverChannel != null) {
                this.serverChannel.close();
            }
            if (this.selector != null) {
                this.selector.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sweeper != null) {
            sweeper.terminate();
        }
        if (this.pool != null) {
            this.pool.shutdownNow();
        }
        this.getProgress().syslog("Shutdown successfully!");
        this.terminator = false;
    }

    private void dispatch(SelectionKey key) {
        Runnable handler = (Runnable)key.attachment();
        if (handler != null) {
            try {
                handler.run();
            }
            catch (Exception e) {
                this.getProgress().errlog("Exception:", e);
            }
        }
    }

    private PooledExecutor makeThreadPool() {
        PooledExecutor pool = new PooledExecutor((Channel)new BoundedBuffer(100), 30);
        pool.setMinimumPoolSize(5);
        pool.setKeepAliveTime(600000L);
        pool.waitWhenBlocked();
        pool.createThreads(5);
        return pool;
    }

    void shutdown(SystemCommandSocklet sys) {
        if (this.terminator || !this.checkSystemCommandSocklet(sys)) {
            return;
        }
        this.getProgress().syslog("Shutdown server...");
        Iterator it = this.getSocklets();
        while (it.hasNext()) {
            Socklet app = (Socklet)it.next();
            app.disconnectAllClients("Good by...");
            app.destroy();
        }
        this.terminator = true;
        System.out.println("selector.wakeup()");
        this.selector.wakeup();
    }

    void restart(SystemCommandSocklet sys) {
        if (!this.checkSystemCommandSocklet(sys)) {
            return;
        }
        this.setRestartAfterShutdown();
        this.shutdown(sys);
    }

    boolean restartSocklet(SystemCommandSocklet sys, String name) {
        if (!this.checkSystemCommandSocklet(sys)) {
            return false;
        }
        this.getProgress().syslog("Restart socklet \"" + name + "\"");
        Socklet socklet = this.getSocklet(name);
        SockletDeployInfo info = null;
        String scriptExt = null;
        File scriptFile = null;
        SockletLoader loader = null;
        if (socklet != null && socklet instanceof ScriptSocklet) {
            scriptExt = ((ScriptSocklet)socklet).getExtention();
            scriptFile = ((ScriptSocklet)socklet).getScriptFile();
            ScriptInfo scrinfo = this.getScriptInfomation(scriptExt);
            if (scrinfo != null && scriptFile != null && scriptFile.exists()) {
                info = this.getScriptSockletInformation(name);
                info.addInitParam("source", scriptFile.getAbsolutePath());
                info.addInitParam("sourceEncoding", scrinfo.getEncoding());
                info.setClassname(scrinfo.getJSClass().getName());
            }
            loader = this.scriptLoader;
        } else {
            info = this.getSockletInformation(name);
        }
        if (info == null) {
            this.getProgress().syslog("Socket \"" + name + "\"'s infomation is not found.", Progress.ERROR);
            return false;
        }
        this.terminateSocklet(socklet, "Good by...");
        this.getProgress().syslog("Socklet\"" + info.getName() + "\"(" + info.getClassname() + ")\u3092\u914d\u5099\u3057\u307e\u3059\u3002");
        try {
            socklet = this.deployNewSocklet(info, "BySystemServer", loader);
            if (socklet instanceof ScriptSocklet) {
                ((ScriptSocklet)socklet).setExtention(scriptExt);
                ((ScriptSocklet)socklet).setScriptFile(scriptFile);
            }
        }
        catch (SockletDeployingException e) {
            this.getProgress().errlog("Socklet\u306e\u914d\u5099\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
            return false;
        }
        return true;
    }

    boolean reloadConfig(SystemCommandSocklet sys) {
        if (!this.checkSystemCommandSocklet(sys)) {
            return false;
        }
        System.out.println("Reload config...");
        try {
            this.loadConfig();
        }
        catch (ConfigurationError e) {
            this.getProgress().errlog("\u521d\u671f\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u518d\u8aad\u8fbc\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
            return false;
        }
        this.reloadSystemCommandInfo();
        System.out.println("Reload config successfully!");
        return true;
    }

    private class AcceptHandler
    implements Runnable {
        SelectionKey key;
        MainReactor main;

        public AcceptHandler(SelectionKey key, MainReactor main) {
            this.key = key;
            this.main = main;
        }

        public void run() {
            SocketProcessorBase client = null;
            try {
                ServerSocketChannel server = (ServerSocketChannel)this.key.channel();
                SocketChannel channel = server.accept();
                if (channel != null) {
                    Socket socket = channel.socket();
                    MainReactor.this.getProgress().syslog("Create Client... " + socket.getInetAddress().getHostAddress());
                    channel.configureBlocking(false);
                    SelectionKey clientKey = channel.register(this.key.selector(), 1);
                    client = new SocketProcessorImplReactor(this.main, channel, clientKey, MainReactor.this.getEncoding(), MainReactor.this.getMessagesBufferSize());
                    clientKey.attach(client);
                    socket.setSoTimeout(MainReactor.this.getInitialTimeout());
                    ((SocketProcessorImplReactor)client).setTimeout(MainReactor.this.getInitialTimeout());
                    if (MainReactor.this.getSecurityController().enter(client)) {
                        MainReactor.this.getProgress().syslog("Welcome " + client.getIPAddress() + "! (ID:" + client.getClientID() + ")");
                    } else {
                        MainReactor.this.getProgress().syslog("Connection Rejected... " + client.getIPAddress());
                        ((SocketProcessorImplReactor)client).terminate();
                    }
                }
            }
            catch (InterruptedIOException e) {
                MainReactor.this.getProgress().errlog("\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u8a2d\u5b9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002:" + client.getClientID(), e);
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }

    private final class SleeperSweeper
    implements Runnable {
        Selector selector;
        boolean terminator;

        public SleeperSweeper(Selector selector) {
            this.selector = selector;
            this.terminator = false;
        }

        public synchronized void terminate() {
            this.terminator = true;
            this.notify();
        }

        public synchronized void run() {
            while (!this.terminator) {
                Object[] keyArray;
                try {
                    keyArray = this.selector.keys().toArray();
                }
                catch (ClosedSelectorException cse) {
                    break;
                }
                catch (ConcurrentModificationException e) {
                    try {
                        this.wait(10000L);
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                int i = 0;
                while (keyArray.length > i) {
                    try {
                        ((SocketProcessorImplReactor)((SelectionKey)keyArray[i]).attachment()).terminateIfInactive();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    Thread.yield();
                    ++i;
                }
                keyArray = null;
                try {
                    this.wait(10000L);
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

