/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.gpss.system;

import java.io.IOException;
import java.net.SocketException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import jp.wda.gpss.system.MainReactor;
import jp.wda.gpss.system.SocketProcessorBase;

final class SocketProcessorImplReactor
extends SocketProcessorBase
implements Runnable {
    private SocketChannel channel;
    private SelectionKey key;
    private Charset codec;
    private ByteBuffer buffer;
    private ByteBufferList messageBuffer;
    private static final int BUFFER_SIZE = 4096;
    private static final int BUFFER_POOL_SIZE = 16;
    private MainReactor server;
    private long timeout = 0L;
    private long lastAct = System.currentTimeMillis();
    private boolean terminator = false;

    public SocketProcessorImplReactor(MainReactor server, SocketChannel channel, SelectionKey key, String encoding, int buffersize) throws IOException {
        super(server, encoding, buffersize, channel.socket().getInetAddress().getHostAddress());
        this.server = server;
        this.channel = channel;
        this.key = key;
        this.codec = server.getCodec();
        this.buffer = ByteBuffer.allocate(4096);
        this.messageBuffer = new ByteBufferList(4096);
        this.recordActive();
    }

    void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    boolean isInactive() {
        if (this.timeout == 0L) {
            return false;
        }
        return System.currentTimeMillis() > this.timeout + this.lastAct;
    }

    void recordActive() {
        this.lastAct = System.currentTimeMillis();
    }

    void terminateIfInactive() {
        if (this.isInactive() && !this.isTerminated()) {
            this.terminate("Connection timeout..");
        }
    }

    public boolean isTerminated() {
        return this.terminator;
    }

    public void run() {
        int length = -1;
        byte b = 0;
        ((Buffer)this.buffer).clear();
        try {
            while (!this.terminator && (length = this.channel.read(this.buffer)) > 0) {
                ((Buffer)this.buffer).flip();
                this.recordActive();
                while (this.buffer.hasRemaining()) {
                    b = this.buffer.get();
                    if (b != 0) {
                        this.messageBuffer.put(b);
                        continue;
                    }
                    try {
                        this.server.getPool().execute((Runnable)new CommandProcessor(this, this.messageBuffer));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.messageBuffer.clear();
                }
                ((Buffer)this.buffer).clear();
            }
        }
        catch (ClosedChannelException e) {
            this.getProgress().errlog("\u30bd\u30b1\u30c3\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059\u3002:" + this.getClientID());
            this.terminate();
            return;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.getProgress().errlog("\u5165\u529b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002:" + this.getClientID(), ioe);
            this.terminate();
            return;
        }
        catch (Exception e) {
            this.getProgress().errlog("\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002:" + this.getClientID(), e);
            e.printStackTrace();
            this.terminate();
            return;
        }
        if (length < 0) {
            this.terminate();
        }
    }

    private synchronized void onInitialize(String message) {
        try {
            this.getProgress().log("debuglogger", "connection:" + message + " [" + this.getClientID() + "]");
            this.doInitialCommand(message);
            if (this.getApplication() == null) {
                this.terminate();
                return;
            }
            if (!this.getApplication().checkConnection(this)) {
                this.terminate();
                return;
            }
            this.terminator = false;
            this.channel.socket().setSoTimeout(this.getApplication().getTimeout());
            this.setTimeout(this.getApplication().getTimeout());
        }
        catch (SocketException ioe) {
            this.getProgress().errlog(String.valueOf(ioe.getMessage()) + ":" + this.getClientID());
            this.terminate();
        }
        catch (Throwable e) {
            this.getProgress().errlog("\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u521d\u671f\u5316\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + this.getClientID(), e);
        }
    }

    private synchronized void onCommand(String message) {
        try {
            if (!this.getApplication().doCommand(this, message)) {
                this.terminate();
            }
        }
        catch (Throwable e) {
            this.getProgress().errlog(message);
            this.getProgress().errlog("\u30b3\u30de\u30f3\u30c9\u51e6\u7406\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + this.getClientID(), e);
        }
    }

    public boolean send(String message) {
        if (this.terminator) {
            return false;
        }
        if (this.channel == null) {
            this.getProgress().errlog("\u30e9\u30a4\u30bf\u3092\u55aa\u5931\u3057\u307e\u3057\u305f\u3002" + this.getClientID());
            return false;
        }
        ByteBuffer buffer = Charset.forName(this.getEncoding()).encode(String.valueOf(message) + "\u0000");
        try {
            this.channel.write(buffer);
            return true;
        }
        catch (IOException e) {
            this.getProgress().errlog("\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + this.getClientID() + "\n" + message, e);
            return false;
        }
    }

    public synchronized void terminate() {
        if (this.terminator) {
            return;
        }
        this.terminator = true;
        this.getProgress().log("debuglogger", "disconnect [" + this.getClientID() + "]");
        this.server.getSecurityController().exit(this);
        try {
            if (this.getApplication() != null) {
                this.getApplication().preRemoveClient(this);
                this.getApplication().removeClient(this);
                this.notifyToSystemCommandSocklet();
            }
        }
        catch (Throwable e) {
            this.getProgress().errlog("\u7d42\u4e86\u51e6\u7406\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + this.getClientID(), e);
            e.printStackTrace();
        }
        if (this.channel != null) {
            try {
                this.channel.socket().shutdownInput();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.channel.socket().shutdownOutput();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                Selector e = this.key.selector();
                synchronized (e) {
                    this.channel.close();
                }
            }
            catch (IOException e) {
                this.getProgress().errlog("\u30c1\u30e3\u30f3\u30cd\u30eb\u7d42\u4e86\u51e6\u7406\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + this.getClientID(), e);
                e.printStackTrace();
            }
        }
        this.channel = null;
    }

    public synchronized void terminate(String message) {
        this.send(message);
        this.terminate();
    }

    private class CommandProcessor
    implements Runnable {
        private ByteBuffer command;
        private SocketProcessorImplReactor client;

        CommandProcessor(SocketProcessorImplReactor client, ByteBufferList command) {
            this.command = command.toByteBuffer();
            this.client = client;
        }

        public void run() {
            if (!this.client.isTerminated()) {
                String com = Charset.forName(SocketProcessorImplReactor.this.getEncoding()).decode(this.command).toString();
                if (this.client.getApplication() != null) {
                    this.client.onCommand(com);
                } else {
                    this.client.onInitialize(com);
                }
            }
        }
    }

    private class ByteBufferList {
        private ArrayList list = new ArrayList();
        private ByteBuffer current;
        private int bufferLength;

        public ByteBufferList(int length) {
            this.bufferLength = length;
            this.current = null;
        }

        public void put(byte b) {
            if (this.current == null || this.current.position() == this.current.limit()) {
                this.current = ByteBuffer.allocate(this.bufferLength);
                this.list.add(this.current);
            }
            this.current.put(b);
        }

        public void put(ByteBuffer bb) {
            while (bb.hasRemaining()) {
                this.put(bb.get());
            }
        }

        public ByteBuffer toByteBuffer() {
            ByteBuffer buf = ByteBuffer.allocate(this.bufferLength * this.list.size());
            Iterator itr = ((AbstractList)this.list).iterator();
            while (itr.hasNext()) {
                ByteBuffer tmpBuf = (ByteBuffer)itr.next();
                ((Buffer)tmpBuf).flip();
                buf.put(tmpBuf);
            }
            ((Buffer)buf).flip();
            return buf;
        }

        public void clear() {
            this.list.clear();
            this.current = null;
        }
    }
}

