/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.gpss.system;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.Iterator;
import jp.wda.gpss.Progress;
import jp.wda.gpss.Socklet;
import jp.wda.gpss.SockletDeployInfo;
import jp.wda.gpss.SockletDeployingException;
import jp.wda.gpss.system.Configuration;
import jp.wda.gpss.system.ConfigurationError;
import jp.wda.gpss.system.ExecutableBase;
import jp.wda.gpss.system.ScriptInfo;
import jp.wda.gpss.system.ScriptSocklet;
import jp.wda.gpss.system.SocketProcessorBase;
import jp.wda.gpss.system.SocketProcessorImplNioPooledThread;
import jp.wda.gpss.system.SockletLoader;
import jp.wda.gpss.system.SystemCommandSocklet;

public class MainNioPooledThread
extends ExecutableBase {
    private ServerSocketChannel serverChannel;
    private Selector selector;
    private boolean terminator = false;
    private ByteBuffer buffer = null;
    private static final int BUFFER_SIZE = 4096;
    private Charset codec = null;
    private PooledExecutor pool;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage : ");
            System.out.println("  java jp.wda.gpss.system.Main config.xml");
            System.out.println("    config.xml - \u521d\u671f\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb");
            return;
        }
        File configfile = new File(args[0]);
        if (!configfile.exists()) {
            System.out.println("\u521d\u671f\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
            System.out.println("File : " + configfile.getAbsolutePath());
            return;
        }
        MainNioPooledThread main = new MainNioPooledThread(new Configuration(configfile));
    }

    private MainNioPooledThread(Configuration config) {
        super(config);
    }

    protected void finalize() {
        if (this.terminator) {
            return;
        }
        Iterator it = this.getSocklets();
        while (it.hasNext()) {
            Socklet app = (Socklet)it.next();
            app.destroy();
        }
    }

    Selector getSelector() {
        return this.selector;
    }

    Charset getCodec() {
        return this.codec;
    }

    PooledExecutor getPool() {
        return this.pool;
    }

    public void accept() {
        System.out.println("Starting server...");
        int n = 0;
        SleeperSweeper sweeper = null;
        ServerSocket serverSocket = null;
        this.buffer = ByteBuffer.allocateDirect(4096);
        this.codec = Charset.forName(this.getEncoding());
        this.pool = this.makeThreadPool();
        try {
            try {
                this.serverChannel = ServerSocketChannel.open();
                serverSocket = this.serverChannel.socket();
                this.selector = Selector.open();
                sweeper = new SleeperSweeper(this.selector);
                new Thread((Runnable)sweeper, "Sweeper").start();
                serverSocket.bind(new InetSocketAddress(this.getPort()));
                this.serverChannel.configureBlocking(false);
                this.serverChannel.register(this.selector, 16);
                block12: while (true) {
                    try {
                        n = this.selector.select();
                        if (!this.terminator) {
                            if (n == 0) continue;
                            Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
                            while (true) {
                                if (!it.hasNext()) continue block12;
                                SelectionKey key = it.next();
                                if (key.isAcceptable()) {
                                    this.createSocketProcessor(key);
                                }
                                if (key.isReadable()) {
                                    this.readMessage(key);
                                }
                                it.remove();
                            }
                        }
                        break;
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (ClosedSelectorException cse) {
                this.getProgress().syslog("Selector closed.");
            }
            catch (ClosedChannelException cse) {
                this.getProgress().syslog("Channel closed.");
            }
            catch (IOException ioe) {
                this.getProgress().errlog("\u5165\u51fa\u529b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", ioe);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            try {
                sweeper.terminate();
                if (this.serverChannel != null) {
                    this.serverChannel.close();
                }
                if (this.selector != null) {
                    this.selector.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.terminator = false;
            throw throwable;
        }
        Object var6_13 = null;
        try {
            sweeper.terminate();
            if (this.serverChannel != null) {
                this.serverChannel.close();
            }
            if (this.selector != null) {
                this.selector.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.terminator = false;
    }

    private PooledExecutor makeThreadPool() {
        PooledExecutor pool = new PooledExecutor((Channel)new BoundedBuffer(10), 100);
        pool.setMinimumPoolSize(5);
        pool.setKeepAliveTime(300000L);
        pool.waitWhenBlocked();
        pool.createThreads(5);
        return pool;
    }

    private void readMessage(SelectionKey key) {
        int length = -1;
        boolean b = false;
        SocketChannel socketChannel = (SocketChannel)key.channel();
        SocketProcessorImplNioPooledThread client = (SocketProcessorImplNioPooledThread)key.attachment();
        this.buffer.clear();
        try {
            while ((length = socketChannel.read(this.buffer)) > 0) {
                this.buffer.flip();
                client.setMessage(this.buffer);
                this.buffer.clear();
            }
        }
        catch (ClosedChannelException e) {
            this.getProgress().errlog("\u30bd\u30b1\u30c3\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059\u3002:" + client.getClientID());
        }
        catch (IOException ioe) {
            this.getProgress().errlog("\u5165\u529b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002:" + client.getClientID());
        }
        if (length < 0) {
            client.terminate();
        }
    }

    private void createSocketProcessor(SelectionKey key) {
        SocketProcessorBase client = null;
        try {
            ServerSocketChannel server = (ServerSocketChannel)key.channel();
            SocketChannel channel = server.accept();
            Socket socket = channel.socket();
            this.getProgress().syslog("Create Client... " + socket.getInetAddress().getHostAddress());
            client = new SocketProcessorImplNioPooledThread(this, channel, this.getEncoding(), this.getMessagesBufferSize());
            if (channel != null) {
                channel.configureBlocking(false);
                channel.register(key.selector(), 1, client);
            }
            this.getProgress().syslog("Create Client... " + socket.getInetAddress().getHostAddress());
            socket.setSoTimeout(this.getInitialTimeout());
            ((SocketProcessorImplNioPooledThread)client).setTimeout(this.getInitialTimeout());
            this.getProgress().syslog("Welcome " + client.getIPAddress() + "! (ID:" + client.getClientID() + ")");
        }
        catch (InterruptedIOException e) {
            this.getProgress().errlog("\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u8a2d\u5b9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002:" + client.getClientID(), e);
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    void shutdown(SystemCommandSocklet sys) {
        if (!this.checkSystemCommandSocklet(sys)) {
            return;
        }
        this.getProgress().syslog("Shutdown server...");
        Iterator it = this.getSocklets();
        while (it.hasNext()) {
            Socklet app = (Socklet)it.next();
            app.disconnectAllClients("Good by...");
            app.destroy();
        }
        this.terminator = true;
        try {
            this.serverChannel.close();
            this.selector.wakeup();
            this.selector.close();
        }
        catch (IOException ioe) {
            this.getProgress().syslog("Shutdown Failed!");
            return;
        }
        this.pool.shutdownNow();
        this.getProgress().syslog("Shutdown successfully!");
    }

    void restart(SystemCommandSocklet sys) {
        if (!this.checkSystemCommandSocklet(sys)) {
            return;
        }
        this.setRestartAfterShutdown();
        this.shutdown(sys);
    }

    boolean restartSocklet(SystemCommandSocklet sys, String name) {
        if (!this.checkSystemCommandSocklet(sys)) {
            return false;
        }
        this.getProgress().syslog("Restart socklet \"" + name + "\"");
        Socklet socklet = this.getSocklet(name);
        SockletDeployInfo info = null;
        String scriptExt = null;
        File scriptFile = null;
        SockletLoader loader = null;
        if (socklet != null && socklet instanceof ScriptSocklet) {
            scriptExt = ((ScriptSocklet)socklet).getExtention();
            scriptFile = ((ScriptSocklet)socklet).getScriptFile();
            ScriptInfo scrinfo = this.getScriptInfomation(scriptExt);
            if (scrinfo != null && scriptFile != null && scriptFile.exists()) {
                info = this.getScriptSockletInformation(name);
                info.addInitParam("source", scriptFile.getAbsolutePath());
                info.addInitParam("sourceEncoding", scrinfo.getEncoding());
                info.setClassname(scrinfo.getJSClass().getName());
            }
            loader = this.scriptLoader;
        } else {
            info = this.getSockletInformation(name);
        }
        if (info == null) {
            this.getProgress().syslog("Socket \"" + name + "\"'s infomation is not found.", Progress.ERROR);
            return false;
        }
        this.terminateSocklet(socklet, "Good by...");
        this.getProgress().syslog("Socklet\"" + info.getName() + "\"(" + info.getClassname() + ")\u3092\u914d\u5099\u3057\u307e\u3059\u3002");
        try {
            socklet = this.deployNewSocklet(info, "BySystemServer", loader);
            if (socklet instanceof ScriptSocklet) {
                ((ScriptSocklet)socklet).setExtention(scriptExt);
                ((ScriptSocklet)socklet).setScriptFile(scriptFile);
            }
        }
        catch (SockletDeployingException e) {
            this.getProgress().errlog("Socklet\u306e\u914d\u5099\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
            return false;
        }
        return true;
    }

    boolean reloadConfig(SystemCommandSocklet sys) {
        if (!this.checkSystemCommandSocklet(sys)) {
            return false;
        }
        System.out.println("Reload config...");
        try {
            this.loadConfig();
        }
        catch (ConfigurationError e) {
            this.getProgress().errlog("\u521d\u671f\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u518d\u8aad\u8fbc\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
            return false;
        }
        this.reloadSystemCommandInfo();
        System.out.println("Reload config successfully!");
        return true;
    }

    final class SleeperSweeper
    implements Runnable {
        Selector selector;
        boolean terminator;

        public SleeperSweeper(Selector selector) {
            this.selector = selector;
            this.terminator = false;
        }

        public synchronized void terminate() {
            this.terminator = true;
            this.notify();
        }

        public synchronized void run() {
            while (!this.terminator) {
                Object[] keyArray;
                try {
                    keyArray = this.selector.keys().toArray();
                    Thread.yield();
                }
                catch (ClosedSelectorException cse) {
                    break;
                }
                int i = 0;
                while (keyArray.length > i) {
                    try {
                        ((SocketProcessorImplNioPooledThread)((SelectionKey)keyArray[i]).attachment()).terminateIfInactive();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ++i;
                }
                keyArray = null;
                try {
                    this.wait(10000L);
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

