package jp.haw.grain.transform.transformer;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.util.TargetNode;
import jp.haw.grain.transform.util.Util;

import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * @author nakajo
 */
public class Span2Inlinegroup extends AbstractTransformer {

	public Span2Inlinegroup(GudBuilder builder) {
		super(builder);
	}
	
	

	public Element getCurrentElement() {
		return this.current;
	}

	protected boolean isTarget(Node node) {
		if(node.getNodeType() != Node.ELEMENT_NODE) return false;
		if(!GudBuilder.XHTML_NS.equals(node.getNamespaceURI())) return false;
		
		//xhtml:bodyȉ̗vf[ƂɂB
		if(!Util.parentNodeAs(node, new TargetNode(GudBuilder.XHTML_NS, "body", Node.ELEMENT_NODE)))
			return false;
			
		return node.getLocalName().equals("span");
	}

	public DocumentFragment transform() {
		Document dom = builder.getGudDoc();
		DocumentFragment df = dom.createDocumentFragment();
		
		Element xhtml_span = (Element)node;
		Element gud_inlineblock = dom.createElementNS(GudBuilder.GUD_NS, "inline-group");
		Util.copyAttributes(xhtml_span, gud_inlineblock);
		df.appendChild(gud_inlineblock);
		
		this.current = gud_inlineblock;
		
		return df;
	}
}
