package jp.haw.grain.transform.transformer;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.util.Util;

import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/**
 * @author nakajo
 */
public abstract class ElementHasLabelBaseTransformer extends AbstractTransformer {

	public ElementHasLabelBaseTransformer(GudBuilder builder) {
		super(builder);
	}

	/**
	 * ϊxformsvf̎qvfƂlabelvf΁Ainlinevfɕϊ܂B
	 * @param df
	 * @param xfroms
	 */
	protected void transformLabel(DocumentFragment df, Element xforms) {
		Document dom = df.getOwnerDocument();
		Element gud_inline = dom.createElementNS(GudBuilder.GUD_NS, "inline");
		NodeList labels = Util.getNamedChildNode(xforms, GudBuilder.XFORMS_NS, "label");
		if(labels.getLength() == 0) return;
		
		Element label = (Element)labels.item(0); //ŏɌꂽlabelvf݂̂ϊBȊO͖
		StringBuffer textBuf = new StringBuffer();
		Util.getTextContent(label, textBuf);
		
		String textContent = textBuf.toString();
		if(textContent == null || textContent.equals("")) return; //񂪂ȂΒǉȂB
		
		Text gud_text = dom.createTextNode(Util.normalizedString(textContent));
		gud_inline.appendChild(gud_text);

		Util.copyAttributes((Element)label, gud_inline);
		
		//inlineɕϊlabelvftextvfXLbvXgɓo^
		//ῗȂAlabelvf`Ă΂XLbvXgɓo^
		for(int i=0; i<labels.getLength(); i++) {
			Node skipNode = labels.item(i);
			builder.addSkipNode(skipNode);
			
			//̎qvfׂ͂ăXLbvXgɓo^
			NodeList childChildren = skipNode.getChildNodes();
			for (int j = 0; j < childChildren.getLength(); j++) {
				builder.addSkipNode(childChildren.item(j));
			}
		}

		df.appendChild(gud_inline);
	}
}
