/*
 * Decompiled with CFR 0.152.
 */
class DeckStatus
extends Rider {
    private static final int CHEMISTRY_UNIT = 50;
    private Rider vanguard;
    private Rider rearguard;

    DeckStatus(Rider vanguard, Rider rearguard) {
        super("status", 0, 0, 0, 0, 0, 0, new int[4], new RiderSkill(0, 0, 0, 0, 0, 0), 0);
        this.vanguard = vanguard;
        this.rearguard = rearguard;
        this.calcChemistry(vanguard, rearguard);
        this.offense = vanguard.getOffense() + this.chemistry[0] * 50;
        this.defense = vanguard.getDefense() + this.chemistry[1] * 50;
        this.hitpoint = vanguard.getHitpoint() + rearguard.getHitpoint() + this.chemistry[3] * 50;
        this.specialAttack = vanguard.getSpecialAttack() + this.chemistry[2] * 50;
        this.rearGuardTactics = rearguard.getRearGuardTactics();
        this.reflectSkills(vanguard, rearguard);
    }

    private void calcChemistry(Rider vanguard, Rider rearguard) {
        int i = 0;
        while (i < 4) {
            this.chemistry[i] = vanguard.getChemistry(i) + rearguard.getChemistry(i);
            ++i;
        }
        int first = 0;
        int second = first + 1;
        int i2 = first + 1;
        while (i2 < 4) {
            if (this.chemistry[first] < this.chemistry[i2]) {
                second = first;
                first = i2;
            } else if (this.chemistry[second] < this.chemistry[i2]) {
                second = i2;
            }
            ++i2;
        }
        int n = first;
        this.chemistry[n] = this.chemistry[n] + 1;
        i2 = 0;
        while (i2 < 4) {
            if (i2 != first && i2 != second) {
                this.chemistry[i2] = 0;
            }
            ++i2;
        }
    }

    private void reflectSkills(Rider vanguard, Rider rearguard) {
        if (vanguard.isVanguardSkillValid(rearguard)) {
            this.offense += vanguard.getOffenseSkill();
            this.defense += vanguard.getDefenseSkill();
            this.hitpoint += vanguard.getHitpointSkill();
            this.specialAttack += vanguard.getSpecialAttackSkill();
        }
        if (rearguard.isRearguardSkillValid(vanguard)) {
            this.offense += rearguard.getOffenseSkill();
            this.defense += rearguard.getDefenseSkill();
            this.hitpoint += rearguard.getHitpointSkill();
            this.specialAttack += rearguard.getSpecialAttackSkill();
        }
    }

    @Override
    public String toString() {
        String str = new String("");
        str = String.valueOf(str) + "\u30bc\u30f3\u30a8\u30a4(" + this.vanguard.getSeries() + "-" + this.vanguard.getNumber() + "),";
        str = String.valueOf(str) + "\u30b3\u30a6\u30a8\u30a4(" + this.rearguard.getSeries() + "-" + this.rearguard.getNumber() + ")\t=>\t";
        str = String.valueOf(str) + "\u30b3\u30a6\u30b2\u30ad\uff1a" + this.offense + ", ";
        str = String.valueOf(str) + "\u30dc\u30a6\u30ae\u30e7 \uff1a" + this.defense + ", ";
        str = String.valueOf(str) + "\u30bf\u30a4\u30ea\u30e7\u30af \uff1a" + this.hitpoint + ", ";
        str = String.valueOf(str) + "\u30d2\u30c3\u30b5\u30c4 \uff1a " + this.specialAttack;
        return str;
    }

    public Rider getVanguard() {
        return this.vanguard;
    }

    public Rider getRearguard() {
        return this.rearguard;
    }
}

