/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import jp.sourceforge.gtibuilder.editor.Editor;
import jp.sourceforge.gtibuilder.editor.EditorComponent;
import jp.sourceforge.gtibuilder.editor.EditorUpdataManager;
import jp.sourceforge.gtibuilder.io.FileDataBase;
import jp.sourceforge.gtibuilder.io.FileType;
import jp.sourceforge.gtibuilder.main.NewPanel;
import jp.sourceforge.gtibuilder.project.EditorUpdataEvent;
import jp.sourceforge.gtibuilder.project.EditorUpdataListener;
import jp.sourceforge.gtibuilder.util.ErrorDialog;
import jp.sourceforge.gtibuilder.util.StringArray;

public class ImageViewer
extends JComponent
implements EditorComponent {
    private Image image = null;
    private byte[] data = null;
    private String fileName = null;
    private String directory = null;
    private JScrollPane sp = new JScrollPane(this);
    private FileType ft = null;
    private EditorUpdataManager eum = new EditorUpdataManager();

    public void addEditorUpdataListener(EditorUpdataListener editorUpdataListener) {
        this.eum.addEditorUpdataListener(editorUpdataListener);
    }

    public void compiled() {
    }

    public void copy() {
    }

    public void cut() {
    }

    public void delete() {
    }

    public Component getComponent() {
        return this.sp;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Dialog getFilePreference() {
        return null;
    }

    public FileType getFileType() {
        return this.ft;
    }

    public NewPanel getNewFilePropertyPane() {
        return null;
    }

    public Component getPrintComponent() {
        return this;
    }

    public FileType[] getSupportedTypes() {
        FileType fileType;
        boolean bl;
        FileType fileType2;
        boolean bl2;
        boolean bl3;
        FileType fileType3 = FileDataBase.getWithExtension("txt");
        int n = 0;
        FileType fileType4 = FileDataBase.getWithMime("image/png");
        boolean bl4 = bl3 = fileType4 != fileType3;
        if (bl3) {
            ++n;
        }
        boolean bl5 = bl2 = (fileType2 = FileDataBase.getWithMime("image/jpeg")) != fileType3;
        if (bl2) {
            ++n;
        }
        boolean bl6 = bl = (fileType = FileDataBase.getWithMime("image/gif")) != fileType3;
        if (bl) {
            ++n;
        }
        int n2 = 0;
        FileType[] fileTypeArray = new FileType[n];
        if (bl3) {
            fileTypeArray[n2] = fileType4;
            ++n2;
        }
        if (bl2) {
            fileTypeArray[n2] = fileType2;
            ++n2;
        }
        if (bl) {
            fileTypeArray[n2] = fileType;
            ++n2;
        }
        return fileTypeArray;
    }

    public void init(StringArray stringArray, FileType fileType) {
        this.setFileType(fileType);
        this.setFileName((String)stringArray.getContent("NAME"));
        this.setDirectory((String)stringArray.getContent("DIRECTORY"));
    }

    public boolean isAutoCheckProperty() {
        return false;
    }

    public boolean isCompiled() {
        return false;
    }

    public boolean isEdited() {
        return false;
    }

    public boolean isSupportedType(FileType fileType) {
        if (fileType.getMimeType().equals("image/png")) {
            return true;
        }
        if (fileType.getMimeType().equals("image/jpeg")) {
            return true;
        }
        return fileType.getMimeType().equals("image/gif");
    }

    public void paste() {
    }

    public boolean readData(byte[] byArray) {
        try {
            this.image = this.getToolkit().createImage(byArray);
        }
        catch (Exception exception) {
            ErrorDialog.showError(exception);
            return false;
        }
        this.data = byArray;
        return true;
    }

    public void redo() {
    }

    public void removeEditorUpdataListener(EditorUpdataListener editorUpdataListener) {
        this.eum.removeEditorUpdataListener(editorUpdataListener);
    }

    public void saved() {
    }

    public boolean setDirectory(String string) {
        this.directory = string;
        this.eum.updataEditor(new EditorUpdataEvent(this, this.fileName, this.directory));
        return true;
    }

    public boolean setFileName(String string) {
        this.fileName = string;
        this.eum.updataEditor(new EditorUpdataEvent(this, this.fileName, this.directory));
        return true;
    }

    public boolean setFileType(FileType fileType) {
        if (this.isSupportedType(fileType)) {
            this.ft = fileType;
            return true;
        }
        return false;
    }

    public void undo() {
    }

    public boolean usingEditMenu() {
        return false;
    }

    public JMenuItem[] usingMenu() {
        return null;
    }

    public void paintComponent(Graphics graphics) {
        if (this.image != null && !graphics.drawImage(this.image, 0, 0, new Color(255, 255, 255), this)) {
            graphics.drawString("NOW LOADING", 10, 10);
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(this.image.getWidth(this), this.image.getHeight(this));
        return dimension;
    }

    public void setEditor(Editor editor) {
    }
}

