/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.editor;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.UnsupportedEncodingException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import jp.sourceforge.gtibuilder.editor.Editor;
import jp.sourceforge.gtibuilder.editor.EditorComponent;
import jp.sourceforge.gtibuilder.editor.EditorUpdataManager;
import jp.sourceforge.gtibuilder.editor.TextColoring;
import jp.sourceforge.gtibuilder.editor.TextFind;
import jp.sourceforge.gtibuilder.io.FileDataBase;
import jp.sourceforge.gtibuilder.io.FileType;
import jp.sourceforge.gtibuilder.main.DefaultNewPanel;
import jp.sourceforge.gtibuilder.main.NewPanel;
import jp.sourceforge.gtibuilder.project.EditorUpdataEvent;
import jp.sourceforge.gtibuilder.project.EditorUpdataListener;
import jp.sourceforge.gtibuilder.project.Project;
import jp.sourceforge.gtibuilder.util.ErrorDialog;
import jp.sourceforge.gtibuilder.util.StringArray;

public class TextEditor
implements EditorComponent,
DocumentListener {
    private TextPane jtp = new TextPane();
    private JScrollPane sp = new JScrollPane(this.jtp);
    private boolean inited = false;
    private boolean autoCheck = false;
    private FileType ft = null;
    private boolean edited = true;
    private boolean compiled = false;
    private String name = null;
    private String pack = null;
    private EditorUpdataManager eumanager = new EditorUpdataManager();
    private TextColoring tc = null;
    private UndoManager um = new UndoManager();
    private PrivateListener pl = new PrivateListener();
    private TextFind textFind = null;
    private Project project = null;
    private Editor editor = null;
    private JMenuItem mFind = new JMenuItem(ResourceBundle.getBundle("jp/sourceforge/gtibuilder/editor/TextEditor").getString("Find"));
    private JMenuItem mFindNext = new JMenuItem(ResourceBundle.getBundle("jp/sourceforge/gtibuilder/editor/TextEditor").getString("Find_Next"));
    private JMenuItem mReplace = new JMenuItem(ResourceBundle.getBundle("jp/sourceforge/gtibuilder/editor/TextEditor").getString("Replace"));

    public void insertUpdate(final DocumentEvent documentEvent) {
        new Thread(){

            public void run() {
                if (documentEvent.getLength() == 1) {
                    char c = TextEditor.this.jtp.getText().toCharArray()[documentEvent.getOffset()];
                    try {
                        if (c == '\t') {
                            TextEditor.this.jtp.getDocument().remove(documentEvent.getOffset(), 1);
                            TextEditor.this.jtp.getDocument().insertString(documentEvent.getOffset(), "    ", null);
                            TextEditor.this.jtp.setCaretPosition(TextEditor.this.jtp.getCaretPosition() + 3);
                        } else if (c != '\n' && c == '\\') {
                            TextEditor.this.jtp.getDocument().remove(documentEvent.getOffset(), 1);
                            TextEditor.this.jtp.getDocument().insertString(documentEvent.getOffset(), "\\", null);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        }.start();
        this.edited = true;
        this.compiled = false;
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.edited = true;
        this.compiled = false;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public boolean readData(byte[] byArray) {
        try {
            String string = new String(byArray, "UTF-8");
            this.jtp.setText(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ErrorDialog.showError(unsupportedEncodingException);
            return false;
        }
        this.edited = false;
        this.um.die();
        return true;
    }

    public byte[] getData() {
        String string = this.jtp.getText();
        try {
            byte[] byArray = string.getBytes("UTF-8");
            return byArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ErrorDialog.showError(unsupportedEncodingException);
            return null;
        }
    }

    public FileType getFileType() {
        this.isInited();
        return this.ft;
    }

    public boolean setFileType(FileType fileType) {
        this.isInited();
        if (this.isSupportedType(fileType)) {
            this.ft = fileType;
            return true;
        }
        return false;
    }

    public boolean isAutoCheckProperty() {
        this.isInited();
        return this.autoCheck;
    }

    public String getFileName() {
        this.isInited();
        return this.name;
    }

    public boolean setFileName(String string) {
        this.isInited();
        if (this.isAutoCheckProperty()) {
            return false;
        }
        this.name = string;
        this.eumanager.updataEditor(new EditorUpdataEvent(this, string, this.pack));
        return true;
    }

    public String getDirectory() {
        this.isInited();
        return this.pack;
    }

    public boolean setDirectory(String string) {
        this.isInited();
        if (this.isAutoCheckProperty()) {
            return false;
        }
        this.pack = string;
        this.eumanager.updataEditor(new EditorUpdataEvent(this, this.name, string));
        return true;
    }

    public JMenuItem[] usingMenu() {
        JMenuItem[] jMenuItemArray = new JMenuItem[]{this.mFind, this.mFindNext, this.mReplace};
        return jMenuItemArray;
    }

    public boolean usingEditMenu() {
        return true;
    }

    public void copy() {
        this.isInited();
        this.jtp.copy();
    }

    public void cut() {
        this.isInited();
        this.jtp.cut();
    }

    public void delete() {
        this.isInited();
        String string = this.jtp.getText().substring(0, this.jtp.getSelectionStart());
        String string2 = this.jtp.getText().substring(this.jtp.getSelectionEnd());
        this.jtp.setText(string + string2);
    }

    public void paste() {
        this.isInited();
        this.jtp.paste();
    }

    public void undo() {
        this.isInited();
        try {
            this.um.undo();
        }
        catch (CannotUndoException cannotUndoException) {
            // empty catch block
        }
    }

    public void redo() {
        this.isInited();
        try {
            this.um.redo();
        }
        catch (CannotRedoException cannotRedoException) {
            // empty catch block
        }
    }

    public void saved() {
        this.edited = false;
    }

    public NewPanel getNewFilePropertyPane() {
        return new DefaultNewPanel();
    }

    public JPanel getFilePropertyPane() {
        this.isInited();
        return null;
    }

    public FileType[] getSupportedTypes() {
        this.isInited();
        FileType[] fileTypeArray = new FileType[]{FileDataBase.getWithMime("text/plain"), FileDataBase.getWithMime("text/x-java-source")};
        return fileTypeArray;
    }

    public boolean isSupportedType(FileType fileType) {
        this.isInited();
        String string = fileType.getMimeType();
        return string.startsWith("text");
    }

    public Component getComponent() {
        this.isInited();
        return this.sp;
    }

    public void init(StringArray stringArray, FileType fileType) {
        this.jtp.getDocument().addDocumentListener(this);
        this.name = (String)stringArray.getContent("NAME");
        this.pack = (String)stringArray.getContent("DIRECTORY");
        this.project = (Project)stringArray.getContent("PROJECT");
        this.ft = fileType;
        this.init();
    }

    private void init() {
        this.inited = true;
        if (this.ft.getExtension().equals("java")) {
            this.tc = new TextColoring(this.jtp);
        }
        final TextEditor textEditor = this;
        this.jtp.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        this.jtp.getDocument().addUndoableEditListener(new UndoableEditListener(){

            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                if (undoableEditEvent.getEdit().getUndoPresentationName().indexOf(ResourceBundle.getBundle("jp/sourceforge/gtibuilder/main/Bundle").getString("Editor.style")) == -1) {
                    textEditor.um.addEdit(undoableEditEvent.getEdit());
                }
            }
        });
        this.textFind = new TextFind(1, this.jtp, this.sp, this, this.project);
        this.mFind.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Find16.gif")));
        this.mFindNext.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/FindAgain16.gif")));
        this.mReplace.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Replace16.gif")));
        this.mFind.addActionListener(this.pl);
        this.mFindNext.addActionListener(this.pl);
        this.mReplace.addActionListener(this.pl);
    }

    private void isInited() {
        if (!this.inited) {
            throw new IllegalStateException();
        }
    }

    public Dialog getFilePreference() {
        return null;
    }

    public void compiled() {
        this.compiled = true;
    }

    public boolean isCompiled() {
        return this.compiled;
    }

    public boolean isEdited() {
        return this.edited;
    }

    public Component getPrintComponent() {
        return this.jtp;
    }

    public void addEditorUpdataListener(EditorUpdataListener editorUpdataListener) {
        this.eumanager.addEditorUpdataListener(editorUpdataListener);
    }

    public void removeEditorUpdataListener(EditorUpdataListener editorUpdataListener) {
        this.eumanager.removeEditorUpdataListener(editorUpdataListener);
    }

    public void setEditor(Editor editor) {
        this.editor = editor;
        this.textFind.setInternalFrame(this.editor);
    }

    private class TextPane
    extends JTextPane {
        private TextPane() {
        }

        public boolean getScrollableTracksViewportWidth() {
            return this.getParent().getSize().width >= this.getSize().width;
        }
    }

    private class PrivateListener
    implements ActionListener {
        private PrivateListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object.equals(TextEditor.this.mFind)) {
                TextFind textFind = TextEditor.this.textFind;
                TextEditor.this.textFind;
                textFind.setType(1);
                TextEditor.this.project.addSheet(TextEditor.this.textFind);
                TextEditor.this.textFind.show();
            } else if (object.equals(TextEditor.this.mFindNext)) {
                if (TextEditor.this.textFind.getType() == 1) {
                    TextEditor.this.textFind.nextFind();
                }
            } else if (object.equals(TextEditor.this.mReplace)) {
                TextFind textFind = TextEditor.this.textFind;
                TextEditor.this.textFind;
                textFind.setType(2);
                TextEditor.this.project.addSheet(TextEditor.this.textFind);
                TextEditor.this.textFind.show();
            }
        }
    }
}

