/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.main;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import jp.sourceforge.gtibuilder.main.NewWindowListener;
import jp.sourceforge.gtibuilder.main.ProjectFile;
import jp.sourceforge.gtibuilder.project.EditorUpdataEvent;
import jp.sourceforge.gtibuilder.project.EditorUpdataListener;
import jp.sourceforge.gtibuilder.project.Project;

public class WindowManager
implements NewWindowListener {
    private Vector windows = new Vector();
    private Vector frames = new Vector();
    private JMenu menu = new JMenu("Window");

    public void addWindow(Frame frame) {
        this.windows.addElement(frame);
        this.menu.add(new WindowMenu(frame, this.menu));
    }

    public void addWindow(JInternalFrame jInternalFrame, Project project) {
        this.frames.addElement(jInternalFrame);
        this.menu.add(new WindowMenu(jInternalFrame, this.menu, project));
    }

    public Frame[] getFrames() {
        Enumeration enumeration = this.windows.elements();
        Frame[] frameArray = new Frame[this.windows.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            frameArray[n] = (Frame)enumeration.nextElement();
            ++n;
        }
        return frameArray;
    }

    public JInternalFrame[] getInternalFrames() {
        Enumeration enumeration = this.frames.elements();
        JInternalFrame[] jInternalFrameArray = new JInternalFrame[this.frames.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            jInternalFrameArray[n] = (JInternalFrame)enumeration.nextElement();
            ++n;
        }
        return jInternalFrameArray;
    }

    public void setWindowMenu(JMenu jMenu) {
        this.menu = jMenu;
    }

    public JMenu getWindowMenu() {
        return this.menu;
    }

    public void updataLookAndFeel() {
        for (int i = 0; i < this.windows.size(); ++i) {
            SwingUtilities.updateComponentTreeUI((Window)this.windows.elementAt(i));
        }
    }

    public void restart() {
        int n;
        for (n = 0; n < this.frames.size(); ++n) {
            ((JInternalFrame)this.frames.elementAt(n)).setVisible(false);
            ((JInternalFrame)this.frames.elementAt(n)).dispose();
        }
        for (n = 0; n < this.windows.size(); ++n) {
            ((Component)((Window)this.windows.elementAt(n))).setVisible(false);
            ((Window)this.windows.elementAt(n)).dispose();
        }
    }

    class WindowMenu
    extends JMenuItem
    implements ActionListener,
    WindowListener,
    InternalFrameListener,
    EditorUpdataListener {
        Window window;
        JInternalFrame frame;
        boolean isWindow = true;
        boolean isAdded = false;
        JMenu menu;
        Project project = null;

        public WindowMenu(Frame frame, JMenu jMenu) {
            this.window = frame;
            this.setText(frame.getTitle());
            frame.addWindowListener(this);
            this.init(jMenu);
        }

        public WindowMenu(JInternalFrame jInternalFrame, JMenu jMenu, Project project) {
            this.frame = jInternalFrame;
            this.setText(jInternalFrame.getTitle());
            jInternalFrame.addInternalFrameListener(this);
            this.isWindow = false;
            this.project = project;
            this.init(jMenu);
            if (jInternalFrame instanceof ProjectFile) {
                ((ProjectFile)((Object)jInternalFrame)).addEditorUpdataListener(this);
            }
        }

        private void init(JMenu jMenu) {
            this.addActionListener(this);
            this.menu = jMenu;
            this.isAdded = true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isWindow) {
                this.window.show();
            } else {
                this.frame.hide();
                this.frame.show();
                this.frame.toFront();
            }
        }

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            if (!this.isAdded) {
                this.menu.add(this);
            }
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            this.menu.remove(this);
            this.isAdded = false;
        }

        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
            this.menu.remove(this);
            this.isAdded = false;
        }

        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
            this.menu.remove(this);
        }

        public void windowClosing(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void updataEditor(EditorUpdataEvent editorUpdataEvent) {
            this.setText(editorUpdataEvent.getNewName());
        }
    }
}

