/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.project;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.sourceforge.gtibuilder.io.ProjectReader;
import jp.sourceforge.gtibuilder.io.UserPreferences;
import jp.sourceforge.gtibuilder.main.MainWindow;
import jp.sourceforge.gtibuilder.main.NewDialog;
import jp.sourceforge.gtibuilder.main.NewWindowListener;
import jp.sourceforge.gtibuilder.main.WindowManager;
import jp.sourceforge.gtibuilder.plugin.PluginManager;
import jp.sourceforge.gtibuilder.project.NameUpdataEvent;
import jp.sourceforge.gtibuilder.project.NameUpdataListener;
import jp.sourceforge.gtibuilder.project.Project;
import jp.sourceforge.gtibuilder.util.Debug;
import jp.sourceforge.gtibuilder.util.StringArray;
import jp.sourceforge.gtibuilder.util.TextBuffer;

public class ProjectManager
extends JPanel
implements NewWindowListener,
NameUpdataListener,
ChangeListener {
    public static final String FILE = "FILE";
    public static final String EDIT = "EDIT";
    public static final String TOOLS = "TOOLS";
    public static final String PROJECT = "PROJECT";
    public static final String HELP = "HELP";
    private JTabbedPane tp = null;
    private JMenuBar bar = null;
    private boolean barSet = false;
    private boolean keySet = false;
    private WindowManager wmanager;
    private PluginManager pmanager;
    private StringArray keyMenuItems;
    private int menuAddPoint = 0;

    public ProjectManager() {
        this.setLayout(new GridLayout(1, 1));
        this.wmanager = new WindowManager();
        this.pmanager = new PluginManager(this);
        String string = UserPreferences.getSystemPreferences().getData("OPENED_PROJECT");
        boolean bl = Boolean.valueOf(UserPreferences.getSystemPreferences().getData("AUTO_OPEN_PROJECT"));
        ProjectManager projectManager = this;
        if (string != null && bl) {
            Debug.print("Auto open system");
            String[] stringArray = TextBuffer.cutString(string, File.pathSeparator);
            for (int i = 0; stringArray.length - 1 > i; ++i) {
                Project project;
                Debug.print("OPEN = " + stringArray[i]);
                File file = new File(stringArray[i]);
                if (!file.exists() || (project = ProjectReader.read(file, projectManager, false)) == null) continue;
                this.add(project);
            }
        }
    }

    public void add(Project project) {
        if (this.tp == null) {
            this.tp = new JTabbedPane();
            this.add(this.tp);
            this.tp.getModel().addChangeListener(this);
        }
        project.addNameUpdataListener(this);
        this.tp.addTab(project.getProjectName(), project);
        if (this.tp.getTabCount() == 0) {
            MainWindow.getMainWindow().setSaveMenuEnabled(false);
        } else {
            MainWindow.getMainWindow().setSaveMenuEnabled(true);
        }
    }

    public void addMenuAt(String string, JMenuItem jMenuItem) {
        ((JMenu)this.keyMenuItems.getContent(string)).add(jMenuItem);
    }

    public void addMenuAt(String string, JMenuItem[] jMenuItemArray) {
        for (int i = 0; jMenuItemArray.length > i; ++i) {
            ((JMenu)this.keyMenuItems.getContent(string)).add(jMenuItemArray[i]);
        }
    }

    public void addMenu(JMenu jMenu) {
        JMenu jMenu2 = this.bar.getMenu(this.bar.getMenuCount() - 1);
        this.bar.remove(this.bar.getMenuCount() - 1);
        this.bar.add(jMenu);
        this.bar.add(jMenu2);
    }

    public Project getProject() {
        if (this.tp == null) {
            return null;
        }
        return (Project)this.tp.getSelectedComponent();
    }

    public Project[] getProjects() {
        if (this.tp == null) {
            return null;
        }
        Component[] componentArray = this.tp.getComponents();
        int n = 0;
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof Project)) continue;
            ++n;
        }
        Project[] projectArray = new Project[n];
        int n2 = 0;
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof Project)) continue;
            projectArray[n2] = (Project)componentArray[i];
            ++n2;
        }
        return projectArray;
    }

    public void openProject() {
        final ProjectManager projectManager = this;
        new Thread(){

            public void run() {
                FileDialog fileDialog = new FileDialog((Frame)MainWindow.getMainWindow(), "Open Project", 0);
                fileDialog.setFilenameFilter(new FilenameFilter(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public boolean accept(File file, String string) {
                        File file2 = new File(file.getAbsolutePath() + File.separator + string);
                        if (file2.isDirectory()) {
                            return file2.getName().lastIndexOf(".app") != string.length() - 4;
                        }
                        return string.lastIndexOf(".gtb") == string.length() - 4;
                    }
                });
                fileDialog.show();
                if (fileDialog.getFile() != null) {
                    String string = fileDialog.getFile();
                    File file = new File(fileDialog.getDirectory() + string);
                    Project project = ProjectReader.read(file, projectManager, true);
                    projectManager.add(project);
                }
            }
        }.start();
    }

    public void remove(Project project) {
        if (this.tp == null) {
            return;
        }
        this.tp.remove(project);
    }

    public void closeProject() {
        Project project = this.getProject();
        this.pmanager.closeProject(project);
        project.close();
        this.remove(project);
        if (this.tp.getTabCount() == 0) {
            MainWindow.getMainWindow().setSaveMenuEnabled(false);
        } else {
            MainWindow.getMainWindow().setSaveMenuEnabled(true);
        }
    }

    public void newFile() {
        NewDialog newDialog = new NewDialog(this);
        newDialog.show();
    }

    public boolean exit() {
        if (this.tp == null) {
            return true;
        }
        Component[] componentArray = this.tp.getComponents();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; componentArray.length > i; ++i) {
            this.tp.setSelectedComponent(componentArray[i]);
            this.pmanager.closeProject((Project)componentArray[i]);
            ((Project)componentArray[i]).close();
            File file = ((Project)componentArray[i]).getSaveFile();
            if (file == null) continue;
            stringBuffer.append(file.getAbsolutePath());
            stringBuffer.append(File.pathSeparator);
        }
        this.pmanager.exit();
        UserPreferences.getSystemPreferences().setData("OPENED_PROJECT", stringBuffer.toString());
        return true;
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        if (!this.barSet) {
            this.bar = jMenuBar;
            this.barSet = true;
        }
        if (this.keySet) {
            this.pmanager.init();
        }
    }

    public void setKeyMenuItems(StringArray stringArray) {
        if (!this.keySet) {
            this.keyMenuItems = stringArray;
            this.keySet = true;
        }
        if (this.barSet) {
            this.pmanager.init();
        }
    }

    public void addWindow(Frame frame) {
        this.wmanager.addWindow(frame);
    }

    public void addWindow(JInternalFrame jInternalFrame, Project project) {
        this.wmanager.addWindow(jInternalFrame, project);
    }

    public void updataName(NameUpdataEvent nameUpdataEvent) {
        this.tp.setTitleAt(this.tp.indexOfComponent((Project)nameUpdataEvent.getSource()), nameUpdataEvent.getNewName());
        this.tp.setToolTipTextAt(this.tp.indexOfComponent((Project)nameUpdataEvent.getSource()), ((Project)nameUpdataEvent.getSource()).getComment());
    }

    public WindowManager getWindowManager() {
        return this.wmanager;
    }

    public PluginManager getPluginManager() {
        return this.pmanager;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.tp.getTabCount() == 0) {
            MainWindow.getMainWindow().setSaveMenuEnabled(false);
        } else {
            MainWindow.getMainWindow().setSaveMenuEnabled(true);
        }
    }
}

