/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.io;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jp.sourceforge.gtibuilder.editor.EditorComponent;
import jp.sourceforge.gtibuilder.util.ErrorDialog;

public class FileType {
    private String mimetype;
    private String extension;
    private String comment;
    private String newComment;
    private Class clazz;
    private boolean canNew;

    public FileType(String mime, String ex, Class cla, boolean canNew) {
        if (mime == null) {
            throw new IllegalArgumentException();
        }
        if (ex == null) {
            throw new IllegalArgumentException();
        }
        if (cla == null) {
            throw new IllegalArgumentException();
        }
        ResourceBundle comment = null;
        try {
            comment = ResourceBundle.getBundle("jp.sourceforge.gtibuilder.io.FileStrings");
            this.comment = comment.getString("Comment." + ex);
            this.newComment = comment.getString("New." + ex);
        }
        catch (MissingResourceException mre) {
            new ErrorDialog(mre);
            return;
        }
        this.mimetype = mime;
        this.extension = ex;
        this.clazz = cla;
        this.canNew = canNew;
    }

    public String getMimeType() {
        return this.mimetype;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getComment() {
        return this.comment;
    }

    public String getNewComment() {
        return this.newComment;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public boolean getCanNew() {
        return this.canNew;
    }

    public Object getIntance() throws IllegalAccessException, InstantiationException, SecurityException {
        return this.clazz.newInstance();
    }

    public EditorComponent getEditor() {
        try {
            return (EditorComponent)this.clazz.newInstance();
        }
        catch (SecurityException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public void setMimeType(String mime) {
        this.mimetype = mime;
    }

    public void setExtension(String exten) {
        this.extension = exten;
    }

    public void setComment(String comm) {
        this.comment = comm;
    }

    public void setNewComment(String comm) {
        this.newComment = comm;
    }

    public void setClass(Class cla) {
        this.clazz = cla;
    }

    public void setClazz(String cla) throws ClassNotFoundException {
        this.clazz = Class.forName(cla);
    }

    public String toString() {
        return "FileType / MIME TYPE : " + this.mimetype + " / EXTENSION : " + this.extension + " / CLASS : " + this.clazz.getName();
    }
}

