/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jp.sourceforge.gtibuilder.main.ProjectFile;
import jp.sourceforge.gtibuilder.project.Project;
import jp.sourceforge.gtibuilder.util.Debug;
import jp.sourceforge.gtibuilder.util.TextBuffer;

public class ProjectWriter {
    public static String HEADER_LAST = "END_OF_HEADER";

    private ProjectWriter() {
    }

    public static void save(File file, Project project) {
        try {
            ZipEntry entry;
            ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(file));
            ProjectFile[] pfiles = project.getProjectFiles();
            int count = 0;
            while (pfiles.length > count) {
                entry = new ZipEntry(TextBuffer.replace(pfiles[count].getPackage(), ".", "/") + "/" + pfiles[count].getFileName());
                zip.putNextEntry(entry);
                ProjectFile pfile = pfiles[count];
                byte[] data = pfile.getData();
                zip.write(data);
                zip.closeEntry();
                ++count;
            }
            entry = new ZipEntry("gtibuilder");
            zip.putNextEntry(entry);
            zip.write(project.getProjectInfo());
            zip.closeEntry();
            zip.close();
        }
        catch (IOException ioe) {
            Debug.print(ioe);
        }
    }
}

