/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.project;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import jp.sourceforge.gtibuilder.editor.Editor;
import jp.sourceforge.gtibuilder.io.ProjectWriter;
import jp.sourceforge.gtibuilder.main.NewWindowListener;
import jp.sourceforge.gtibuilder.main.ProjectFile;
import jp.sourceforge.gtibuilder.main.WindowManager;
import jp.sourceforge.gtibuilder.project.NameUpdataEvent;
import jp.sourceforge.gtibuilder.project.NameUpdataListener;
import jp.sourceforge.gtibuilder.project.ProjectPreference;
import jp.sourceforge.gtibuilder.util.Debug;
import jp.sourceforge.gtibuilder.util.StringArray;
import jp.sourceforge.gtibuilder.util.TextBuffer;

public class Project
extends JPanel
implements ActionListener,
MouseListener {
    public static final String MASTER = "MASTER";
    public static final String NAME = "NAME";
    public static final String COPYRIGHT = "COPYRIGHT";
    public static final String ORGANIZATION = "ORGANIZATION";
    public static final String COMMENT = "COMMENT";
    public static final String WINDOW_MANAGER = "WINDOW_MANAGER";
    private JSplitPane sp = null;
    private JDesktopPane dp = null;
    private JTree jt = null;
    private Vector editors = new Vector();
    private DefaultMutableTreeNode node = null;
    private DefaultTreeModel model = null;
    private File file = null;
    private String mainClass = null;
    private String copyright = null;
    private String projectName = null;
    private String org = null;
    private String comment = null;
    private String master = null;
    private String dpackage = null;
    private Timer timer = null;
    private WindowListener listener = null;
    private NewWindowListener newListener = null;
    private Vector listeners = new Vector();
    private int newx = 0;
    private int newy = 0;

    public Project(StringArray map) {
        this.timer = new Timer(1000, this);
        this.projectName = (String)map.getContent(NAME);
        this.copyright = (String)map.getContent(COPYRIGHT);
        this.org = (String)map.getContent(ORGANIZATION);
        this.master = (String)map.getContent(MASTER);
        this.comment = (String)map.getContent(COMMENT);
        this.dp = new JDesktopPane();
        this.node = new DefaultMutableTreeNode(this.projectName);
        this.model = new DefaultTreeModel(this.node);
        this.jt = new JTree(this.model);
        JScrollPane spp = new JScrollPane(this.jt);
        this.sp = new JSplitPane(1, false, spp, this.dp);
        this.sp.setDividerLocation(200);
        this.setLayout(new GridLayout(1, 1));
        this.add(this.sp);
        this.listener = new WindowListener();
        this.newListener = (NewWindowListener)map.getContent(WINDOW_MANAGER);
        this.timer.start();
        this.jt.addMouseListener(this);
    }

    public Project(byte[] info, WindowManager manager) {
        this.timer = new Timer(1000, this);
        this.setProjectInfo(info);
        this.dp = new JDesktopPane();
        this.node = new DefaultMutableTreeNode(this.projectName);
        this.model = new DefaultTreeModel(this.node);
        this.jt = new JTree(this.model);
        JScrollPane spp = new JScrollPane(this.jt);
        this.sp = new JSplitPane(1, false, spp, this.dp);
        this.sp.setDividerLocation(200);
        this.setLayout(new GridLayout(1, 1));
        this.add(this.sp);
        this.listener = new WindowListener();
        this.newListener = manager;
        this.timer.start();
        this.jt.addMouseListener(this);
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getOrg() {
        return this.org;
    }

    public String getComment() {
        return this.comment;
    }

    public String getMaster() {
        return this.master;
    }

    public byte[] getProjectInfo() {
        StringBuffer buff = new StringBuffer();
        buff.append("Master=");
        buff.append(this.master);
        buff.append("\n");
        buff.append("Comment=");
        buff.append(this.comment);
        buff.append("\n");
        buff.append("Project_Name=");
        buff.append(this.projectName);
        buff.append("\n");
        buff.append("Copyright=");
        buff.append(this.copyright);
        buff.append("\n");
        buff.append("Main_Class=");
        buff.append(this.mainClass);
        buff.append("\n");
        return buff.toString().getBytes();
    }

    public boolean setProjectInfo(byte[] info) {
        StringArray list = new StringArray(new ByteArrayInputStream(info));
        this.master = (String)list.getContent("Master");
        this.projectName = (String)list.getContent("Project_Name");
        this.mainClass = (String)list.getContent("Main_Class");
        this.comment = (String)list.getContent("Comment");
        this.copyright = (String)list.getContent("Copyright");
        return true;
    }

    public void setMainClass(String clazz) {
        this.mainClass = clazz;
    }

    public void setCopyright(String copy) {
        this.copyright = copy;
    }

    public void setProjectName(String name) {
        this.projectName = name;
        Enumeration array = this.listeners.elements();
        while (array.hasMoreElements()) {
            ((NameUpdataListener)array.nextElement()).updataName(new NameUpdataEvent((Object)this, name));
        }
    }

    public void setOrg(String org) {
        this.org = org;
    }

    public void setMaster(String master) {
        this.master = master;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void addEditor(Editor editor) {
        Debug.print("----------STRAT ADD EDITOR--------");
        editor.addInternalFrameListener(this.listener);
        this.newListener.addWindow(editor);
        editor.setBounds(this.newx, this.newy, 400, 300);
        this.newx += 40;
        this.newy += 40;
        this.editors.addElement(editor);
        this.dp.add(editor);
        editor.show();
        Object[] pack = TextBuffer.cutString(editor.getPackage(), ".");
        Debug.print(pack);
        DefaultMutableTreeNode node = this.node;
        DefaultMutableTreeNode temp = null;
        int count = 0;
        while (count < pack.length) {
            Debug.print("START SEARCHING-------");
            if (((String)pack[count]).equals("")) break;
            Enumeration<TreeNode> enu = node.children();
            System.out.print("NODE'S CHILDREN : ");
            Debug.print(enu);
            enu = node.children();
            Object[] arrays = node.getPath();
            System.out.print("NODE'S PATH : ");
            Debug.print(arrays);
            boolean found = false;
            while (enu.hasMoreElements() && !found) {
                temp = (DefaultMutableTreeNode)enu.nextElement();
                if (((String)pack[count]).equals(temp.getUserObject())) {
                    node = temp;
                    found = true;
                    Debug.print("FOUND");
                }
                Debug.print("SERCH TREE" + count + ":" + node.getUserObject() + " / 1:" + temp.getUserObject() + " / 2:" + (String)pack[count]);
            }
            if (!found) {
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(pack[count]);
                node.add(newNode);
                node = newNode;
                Debug.print("NOT FOUND" + count + " : " + (String)pack[count]);
            }
            ++count;
        }
        temp = new FileNode(editor);
        node.add(temp);
        this.model.reload();
        this.jt.treeDidChange();
    }

    public ProjectFile[] getProjectFiles() {
        return this.getEditors();
    }

    protected Editor[] getEditors() {
        Editor[] edits = new Editor[this.editors.size()];
        int loop = 0;
        int size = edits.length;
        while (loop < size) {
            edits[loop] = (Editor)this.editors.elementAt(loop);
            ++loop;
        }
        return edits;
    }

    protected Editor getSelectedEditor() {
        JInternalFrame jif = this.listener.getSelectedFrame();
        if (jif == null) {
            return null;
        }
        if (jif instanceof Editor) {
            return (Editor)jif;
        }
        return null;
    }

    public void showFilePreference() {
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().showFilePreference();
        }
    }

    public void showProjectPreference() {
        ProjectPreference pre = new ProjectPreference(this);
        pre.show();
    }

    public void copy() {
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().copy();
        }
    }

    public void cut() {
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().cut();
        }
    }

    public void paste() {
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().paste();
        }
    }

    public void delete() {
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().delete();
        }
    }

    public void undo() {
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().undo();
        }
    }

    public void redo() {
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().redo();
        }
    }

    public void task() {
    }

    public void save() {
        if (this.file == null) {
            this.saveAs();
        }
        ProjectWriter.save(this.file, this);
    }

    public void saveAs() {
        JFileChooser chooser = new JFileChooser();
        int re = chooser.showSaveDialog(null);
        if (re == 0) {
            this.file = chooser.getSelectedFile();
            this.save();
        }
    }

    public void addNameUpdataListener(NameUpdataListener listener) {
        if (this.listeners.indexOf(listener) != -1) {
            return;
        }
        this.listeners.addElement(listener);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.timer) {
            this.task();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.jt.getLastSelectedPathComponent();
        if (node instanceof FileNode && mouseEvent.getClickCount() == 2) {
            ((Editor)((FileNode)node).getProjectFile()).show();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    class FileNode
    extends DefaultMutableTreeNode
    implements NameUpdataListener {
        private ProjectFile file = null;

        public FileNode(ProjectFile file) {
            this.file = file;
            this.setUserObject(file.getFileName());
        }

        public void updataName(NameUpdataEvent event) {
            this.setUserObject(this.file.getFileName());
        }

        public ProjectFile getProjectFile() {
            return this.file;
        }
    }

    class WindowListener
    implements InternalFrameListener {
        private JInternalFrame selectedFrame = null;

        WindowListener() {
        }

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            this.selectedFrame = (JInternalFrame)internalFrameEvent.getSource();
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            if (this.selectedFrame == internalFrameEvent.getSource()) {
                this.selectedFrame = null;
            }
        }

        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
        }

        public JInternalFrame getSelectedFrame() {
            return this.selectedFrame;
        }
    }
}

