/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.editor;

import java.awt.Component;
import java.awt.Dialog;
import java.io.UnsupportedEncodingException;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jp.sourceforge.gtibuilder.editor.EditorComponent;
import jp.sourceforge.gtibuilder.io.FileDataBase;
import jp.sourceforge.gtibuilder.io.FileType;
import jp.sourceforge.gtibuilder.main.DefaultNewPanel;
import jp.sourceforge.gtibuilder.main.NewPanel;
import jp.sourceforge.gtibuilder.util.ErrorDialog;
import jp.sourceforge.gtibuilder.util.StringArray;

public class TextEditor
implements EditorComponent,
DocumentListener {
    private JTextPane jtp = new JTextPane();
    private JScrollPane sp = new JScrollPane(this.jtp);
    private boolean inited = false;
    private boolean autoCheck = false;
    private FileType ft = null;
    private boolean edited = false;
    private String name = null;
    private String pack = null;

    public void insertUpdate(DocumentEvent e) {
        this.edited = true;
    }

    public void removeUpdate(DocumentEvent e) {
        this.edited = true;
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public boolean readData(byte[] data) {
        try {
            String text = new String(data, "UTF-8");
            this.jtp.setText(text);
        }
        catch (UnsupportedEncodingException uee) {
            new ErrorDialog(uee).show();
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getData() {
        String text = this.jtp.getText();
        try {
            void uee;
            byte[] array = text.getBytes("UTF-8");
            return uee;
        }
        catch (UnsupportedEncodingException uee) {
            new ErrorDialog(uee).show();
            return null;
        }
    }

    public FileType getFileType() {
        this.isInited();
        return this.ft;
    }

    public boolean setFileType(FileType ft) {
        this.isInited();
        if (this.isSupportedType(ft)) {
            this.ft = ft;
            return true;
        }
        return false;
    }

    public boolean isAutoCheckProperty() {
        this.isInited();
        return this.autoCheck;
    }

    public String getFileName() {
        this.isInited();
        return this.name;
    }

    public boolean setFileName(String name) {
        this.isInited();
        if (this.isAutoCheckProperty()) {
            return false;
        }
        this.name = name;
        return true;
    }

    public String getDirectory() {
        this.isInited();
        return this.pack;
    }

    public boolean setDirectory(String pack) {
        this.isInited();
        if (this.isAutoCheckProperty()) {
            return false;
        }
        this.pack = pack;
        return true;
    }

    public boolean close() {
        int re;
        this.isInited();
        return !this.edited || (re = JOptionPane.showConfirmDialog(null, "Are you sure close this file?", "Close", 0)) != 1;
    }

    public JMenu[] usingMenu() {
        return null;
    }

    public boolean usingEditMenu() {
        return true;
    }

    public void copy() {
        this.isInited();
        this.jtp.copy();
    }

    public void cut() {
        this.isInited();
        this.jtp.cut();
    }

    public void delete() {
        this.isInited();
        String f = this.jtp.getText().substring(0, this.jtp.getSelectionStart());
        String b = this.jtp.getText().substring(this.jtp.getSelectionEnd());
        this.jtp.setText(f + b);
    }

    public void paste() {
        this.isInited();
        this.jtp.paste();
    }

    public void undo() {
        this.isInited();
    }

    public void redo() {
        this.isInited();
    }

    public void saved() {
        this.edited = false;
    }

    public NewPanel getNewFilePropertyPane(Component owner) {
        return new DefaultNewPanel(owner);
    }

    public JPanel getFilePropertyPane() {
        this.isInited();
        return null;
    }

    public FileType[] getSupportedTypes() {
        this.isInited();
        FileType[] types = new FileType[]{FileDataBase.getWithMime("text/plain"), FileDataBase.getWithMime("text/x-java-source")};
        return types;
    }

    public boolean isSupportedType(FileType ft) {
        this.isInited();
        String mime = ft.getMimeType();
        return mime.startsWith("text");
    }

    public Component getComponent() {
        this.isInited();
        return this.sp;
    }

    public void init(NewPanel comp) {
        this.jtp.getDocument().addDocumentListener(this);
        StringArray map = comp.getProperties();
        this.name = (String)map.getContent("NAME");
        this.pack = (String)map.getContent("DIRECTORY");
        this.ft = comp.getFileType();
        this.init();
    }

    public void init(StringArray map, FileType type) {
        this.jtp.getDocument().addDocumentListener(this);
        this.name = (String)map.getContent("NAME");
        this.pack = (String)map.getContent("DIRECTORY");
        this.ft = type;
        this.init();
    }

    private void init() {
        this.inited = true;
        if (this.ft == FileDataBase.getWithExtension("java")) {
            StringBuffer buff = new StringBuffer();
            buff.append("/*\n");
            buff.append(" *  " + this.getFileName() + "\n");
            buff.append(" */\n");
            buff.append("\n");
            buff.append("package " + this.getDirectory() + ";\n");
            buff.append("\n");
            buff.append("public class " + this.getFileName().substring(0, this.getFileName().lastIndexOf(46)) + " {\n");
            buff.append("\n");
            buff.append("}\n");
            this.jtp.setText(buff.toString());
        }
    }

    private void isInited() {
        if (!this.inited) {
            throw new IllegalStateException();
        }
    }

    public Dialog getFilePreference() {
        return null;
    }
}

