/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.swing.JProgressBar;
import jp.sourceforge.gtibuilder.editor.Editor;
import jp.sourceforge.gtibuilder.editor.EditorComponent;
import jp.sourceforge.gtibuilder.io.FileDataBase;
import jp.sourceforge.gtibuilder.io.FileType;
import jp.sourceforge.gtibuilder.main.MainWindow;
import jp.sourceforge.gtibuilder.project.Project;
import jp.sourceforge.gtibuilder.project.ProjectManager;
import jp.sourceforge.gtibuilder.util.Debug;
import jp.sourceforge.gtibuilder.util.ErrorDialog;
import jp.sourceforge.gtibuilder.util.StringArray;

public class ProjectReader {
    private ProjectReader() {
    }

    public static Project read(File file, ProjectManager manager, boolean showState) {
        try {
            ZipFile zfile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enu = zfile.entries();
            int size = 0;
            while (enu.hasMoreElements()) {
                enu.nextElement();
                ++size;
            }
            JProgressBar bar = null;
            if (showState) {
                MainWindow.getMainWindow().showProgressBar();
                MainWindow.getMainWindow().setStatus("Reading : " + file.getAbsolutePath());
                bar = MainWindow.getMainWindow().getProgressBar();
                bar.setMinimum(0);
                bar.setMaximum(size + 2);
                bar.setValue(0);
            }
            ZipInputStream zip = new ZipInputStream(new FileInputStream(file));
            ZipEntry entry = null;
            Project project = null;
            Vector<Editor> editors = new Vector<Editor>();
            if (showState) {
                bar.setValue(1);
                bar.setStringPainted(true);
            }
            while ((entry = zip.getNextEntry()) != null) {
                if (entry.getName().equals("gtibuilder")) {
                    if (showState) {
                        MainWindow.getMainWindow().getProgressBar().setString("Reading : Project Info");
                    }
                    ByteArrayOutputStream str = new ByteArrayOutputStream();
                    int data = 0;
                    while ((data = ((InflaterInputStream)zip).read()) != -1) {
                        str.write(data);
                    }
                    byte[] arrayData = str.toByteArray();
                    project = new Project(arrayData, manager.getWindowManager());
                    if (showState) {
                        bar.setValue(bar.getValue() + 1);
                    }
                } else {
                    String extension;
                    FileType type;
                    EditorComponent comp;
                    if (showState) {
                        MainWindow.getMainWindow().getProgressBar().setString("Reading : " + entry.getName());
                    }
                    if ((comp = (type = FileDataBase.getWithExtension(extension = entry.getName().substring(entry.getName().lastIndexOf(46) + 1))).getEditor()) != null) {
                        StringArray array = new StringArray();
                        array.add("NAME", entry.getName().substring(entry.getName().lastIndexOf(47) + 1));
                        array.add("DIRECTORY", entry.getName().substring(0, entry.getName().lastIndexOf(47)));
                        comp.init(array, type);
                        editors.addElement(new Editor(comp));
                    }
                    ByteArrayOutputStream str = new ByteArrayOutputStream();
                    int data = 0;
                    while ((data = ((InflaterInputStream)zip).read()) != -1) {
                        str.write(data);
                    }
                    byte[] arrayData = str.toByteArray();
                    comp.readData(arrayData);
                    if (showState) {
                        bar.setValue(bar.getValue() + 1);
                    }
                }
                zip.closeEntry();
            }
            if (showState) {
                bar.setString("Closing");
            }
            zip.close();
            if (project != null) {
                Enumeration e = editors.elements();
                while (e.hasMoreElements()) {
                    project.addEditor((Editor)e.nextElement());
                }
                project.setSaveFile(file);
                if (showState) {
                    bar.setValue(bar.getMaximum());
                    bar.setString("");
                    bar.setStringPainted(false);
                    MainWindow.getMainWindow().hideProgressBar();
                    MainWindow.getMainWindow().setStatus("Done.");
                }
                return project;
            }
            if (showState) {
                MainWindow.getMainWindow().hideProgressBar();
                MainWindow.getMainWindow().setStatus("Error! Did not found Project Info.");
            }
            return null;
        }
        catch (IOException ioe) {
            Debug.print(ioe);
            new ErrorDialog(ioe).show();
            return null;
        }
    }
}

