/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JProgressBar;
import jp.sourceforge.gtibuilder.main.MainWindow;
import jp.sourceforge.gtibuilder.main.ProjectFile;
import jp.sourceforge.gtibuilder.project.Project;
import jp.sourceforge.gtibuilder.util.Debug;
import jp.sourceforge.gtibuilder.util.ErrorDialog;

public class ProjectWriter {
    public static String HEADER_LAST = "END_OF_HEADER";

    private ProjectWriter() {
    }

    public static void save(File file, Project project) {
        try {
            ZipEntry entry;
            ProjectFile[] pfiles = project.getProjectFiles();
            MainWindow.getMainWindow().showProgressBar();
            MainWindow.getMainWindow().setStatus("Saveing : " + file.getAbsolutePath());
            JProgressBar bar = MainWindow.getMainWindow().getProgressBar();
            bar.setMinimum(0);
            bar.setMaximum(pfiles.length + 3);
            bar.setValue(0);
            bar.setStringPainted(true);
            bar.setString("Opening file");
            ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(file));
            int count = 0;
            bar.setValue(1);
            while (pfiles.length > count) {
                entry = new ZipEntry(pfiles[count].getDirectory() + "/" + pfiles[count].getFileName());
                bar.setString("Writing : " + entry.getName());
                zip.putNextEntry(entry);
                ProjectFile pfile = pfiles[count];
                byte[] data = pfile.getData();
                zip.write(data);
                zip.closeEntry();
                bar.setValue(bar.getValue() + 1);
                ++count;
            }
            bar.setString("Writing : Project Info");
            entry = new ZipEntry("gtibuilder");
            zip.putNextEntry(entry);
            zip.write(project.getProjectInfo());
            zip.closeEntry();
            bar.setValue(bar.getValue() + 1);
            bar.setString("Closing : Project Info");
            zip.close();
            bar.setValue(bar.getMaximum());
            bar.setStringPainted(false);
            bar.setString("");
            MainWindow.getMainWindow().hideProgressBar();
            MainWindow.getMainWindow().setStatus("Done.");
        }
        catch (IOException ioe) {
            Debug.print(ioe);
            MainWindow.getMainWindow().getProgressBar().setStringPainted(false);
            MainWindow.getMainWindow().getProgressBar().setString("");
            MainWindow.getMainWindow().hideProgressBar();
            MainWindow.getMainWindow().setStatus("Error.");
            new ErrorDialog(ioe).show();
        }
    }
}

